/*
 * Decompiled with CFR 0.152.
 */
package sdsu.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import sdsu.util.ConversionException;
import sdsu.util.LabeledData;
import sdsu.util.OrderedCollection;
import sdsu.util.ReverseListEnumerator;
import sdsu.util.SimpleTokenizer;
import sdsu.util.Stringizable;
import sdsu.util.Stringizer;
import sdsu.util.TokenCharacters;

public class List
implements OrderedCollection,
Stringizable,
Serializable {
    protected Vector internalVector = null;
    private static final char DEFAULT_SEPARATOR = ',';
    private char separatorChar = (char)44;
    private TokenCharacters parseTable = new TokenCharacters(String.valueOf(this.separatorChar));

    public List() {
        this(10);
    }

    public List(int n) {
        this.internalVector = new Vector(n, 0);
    }

    public List(Vector vector) {
        this.internalVector = new Vector();
        this.addElements(vector);
    }

    public List(Object[] objectArray) {
        this.internalVector = new Vector();
        this.addElements(objectArray);
    }

    public final synchronized void addElement(double d) {
        this.addElement(new Double(d));
    }

    public final synchronized void addElement(int n) {
        this.addElement(new Integer(n));
    }

    public void addElement(Object object) {
        this.internalVector.addElement(object);
    }

    public void addElements(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            this.internalVector.addElement(vector.elementAt(n));
            ++n;
        }
    }

    public void addElements(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            this.internalVector.addElement(objectArray[n]);
            ++n;
        }
    }

    public int capacity() {
        return this.internalVector.capacity();
    }

    public synchronized Object clone() {
        try {
            List list = (List)super.clone();
            list.internalVector = (Vector)this.internalVector.clone();
            return list;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean contains(Object object) {
        return this.internalVector.contains(object);
    }

    public final synchronized double doubleAt(int n) {
        Number number = (Number)this.elementAt(n);
        return number.doubleValue();
    }

    public Object elementAt(int n) {
        return this.internalVector.elementAt(n);
    }

    public Enumeration elements() {
        return this.internalVector.elements();
    }

    public final synchronized Enumeration elementsReversed() {
        return new ReverseListEnumerator(this);
    }

    public void ensureCapacity(int n) {
        this.internalVector.ensureCapacity(n);
    }

    public Object firstElement() {
        return this.internalVector.firstElement();
    }

    public void fromString(String string) throws ConversionException {
        this.load(new StringReader(string));
    }

    public LabeledData getMetaData() {
        LabeledData labeledData = this.parseTable.toLabeledData();
        if (this.separatorChar != ',') {
            String string = String.valueOf(this.separatorChar);
            ((Hashtable)labeledData).put("separatorChar", string);
        }
        ((Hashtable)labeledData).put("class", this.getClass().getName());
        return labeledData;
    }

    public int indexOf(Object object) {
        return this.internalVector.indexOf(object);
    }

    public int indexOf(Object object, int n) {
        return this.internalVector.indexOf(object, n);
    }

    public void insertElementAt(Object object, int n) {
        this.internalVector.insertElementAt(object, n);
    }

    public final synchronized int intAt(int n) {
        Number number = (Number)this.elementAt(n);
        return number.intValue();
    }

    public boolean isEmpty() {
        return this.internalVector.isEmpty();
    }

    public Object lastElement() {
        return this.internalVector.lastElement();
    }

    public int lastIndexOf(Object object) {
        return this.internalVector.lastIndexOf(object);
    }

    public int lastIndexOf(Object object, int n) {
        return this.internalVector.lastIndexOf(object, n);
    }

    public void load(InputStream inputStream) throws ConversionException {
        this.load(new InputStreamReader(inputStream));
    }

    public void load(Reader reader) throws ConversionException {
        try {
            SimpleTokenizer simpleTokenizer = new SimpleTokenizer(reader, this.parseTable);
            while (simpleTokenizer.hasMoreTokens()) {
                this.addElement(simpleTokenizer.nextToken());
            }
        }
        catch (IOException iOException) {
            throw new ConversionException("IO Exception thrown in converting object");
        }
    }

    public void removeAllElements() {
        this.internalVector.removeAllElements();
    }

    public boolean removeElement(Object object) {
        return this.internalVector.removeElement(object);
    }

    public void removeElementAt(int n) {
        this.internalVector.removeElementAt(n);
    }

    public void replaceElements(Object[] objectArray) {
        this.internalVector.removeAllElements();
        int n = 0;
        while (n < objectArray.length) {
            this.internalVector.addElement(objectArray[n]);
            ++n;
        }
    }

    public synchronized OrderedCollection reversed() {
        List list = new List(this.size());
        Enumeration enumeration = this.elementsReversed();
        while (enumeration.hasMoreElements()) {
            list.addElement(enumeration.nextElement());
        }
        return list;
    }

    public void save(OutputStream outputStream, String string) {
        PrintWriter printWriter = new PrintWriter(outputStream);
        printWriter.println(this.toString(string));
        printWriter.flush();
    }

    public void setElementAt(Object object, int n) {
        this.internalVector.setElementAt(object, n);
    }

    public void setMetaData(LabeledData labeledData) {
        this.parseTable = new TokenCharacters();
        this.parseTable.fromLabeledData(labeledData);
        if (((Hashtable)labeledData).containsKey("separatorChar")) {
            this.setSeparatorChar(labeledData.getData("separatorChar").charAt(0));
        } else {
            this.setSeparatorChar(',');
        }
    }

    public void setSeparatorChar(char c) {
        this.separatorChar = c;
        this.upDateParseTable();
    }

    public void setSize(int n) {
        this.internalVector.setSize(n);
    }

    public void setTokenCharacters(TokenCharacters tokenCharacters) {
        this.parseTable = tokenCharacters;
        this.upDateParseTable();
    }

    public synchronized OrderedCollection shuffled() {
        List list = new List(this.size());
        Object[] objectArray = new Object[this.size()];
        this.internalVector.copyInto(objectArray);
        Random random = new Random();
        int n = this.size();
        while (n > 0) {
            int n2 = Math.abs(random.nextInt()) % n;
            list.addElement(objectArray[n2]);
            objectArray[n2] = objectArray[n - 1];
            --n;
        }
        return list;
    }

    public int size() {
        return this.internalVector.size();
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.internalVector.size()];
        this.internalVector.copyInto(objectArray);
        return objectArray;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        Stringizer stringizer = new Stringizer(this.parseTable);
        stringizer.setHeader(string);
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            stringizer.appendToken(enumeration.nextElement(), this.separatorChar);
        }
        return stringizer.toString();
    }

    public Vector toVector() {
        Vector vector = new Vector(this.internalVector.capacity());
        Enumeration enumeration = this.internalVector.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public void trimToSize() {
        this.internalVector.trimToSize();
    }

    private void upDateParseTable() {
        this.parseTable.setSeparatorChars(String.valueOf(this.separatorChar));
    }
}

