/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.fate.zookeeper;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.accumulo.fate.util.Retry;
import org.apache.accumulo.fate.zookeeper.IZooReader;
import org.apache.accumulo.fate.zookeeper.ZooSession;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooReader
implements IZooReader {
    private static final Logger log = LoggerFactory.getLogger(ZooReader.class);
    protected String keepers;
    protected int timeout;
    private final Retry.RetryFactory retryFactory;

    protected ZooKeeper getSession(String keepers, int timeout, String scheme, byte[] auth) {
        return ZooSession.getSession(keepers, timeout, scheme, auth);
    }

    protected ZooKeeper getZooKeeper() {
        return this.getSession(this.keepers, this.timeout, null, null);
    }

    protected Retry.RetryFactory getRetryFactory() {
        return this.retryFactory;
    }

    protected void retryOrThrow(Retry retry, KeeperException e) throws KeeperException {
        log.warn("Saw (possibly) transient exception communicating with ZooKeeper", (Throwable)e);
        if (retry.canRetry()) {
            retry.useRetry();
            return;
        }
        log.error("Retry attempts (" + retry.retriesCompleted() + ") exceeded trying to communicate with ZooKeeper");
        throw e;
    }

    @Override
    public byte[] getData(String zPath, Stat stat) throws KeeperException, InterruptedException {
        return this.getData(zPath, false, stat);
    }

    @Override
    public byte[] getData(String zPath, boolean watch, Stat stat) throws KeeperException, InterruptedException {
        Retry retry = this.getRetryFactory().createRetry();
        while (true) {
            try {
                return this.getZooKeeper().getData(zPath, watch, stat);
            }
            catch (KeeperException e) {
                KeeperException.Code code = e.code();
                if (code != KeeperException.Code.CONNECTIONLOSS && code != KeeperException.Code.OPERATIONTIMEOUT && code != KeeperException.Code.SESSIONEXPIRED) {
                    throw e;
                }
                this.retryOrThrow(retry, e);
                retry.waitForNextAttempt();
                continue;
            }
            break;
        }
    }

    @Override
    public byte[] getData(String zPath, Watcher watcher, Stat stat) throws KeeperException, InterruptedException {
        Retry retry = this.getRetryFactory().createRetry();
        while (true) {
            try {
                return this.getZooKeeper().getData(zPath, watcher, stat);
            }
            catch (KeeperException e) {
                KeeperException.Code code = e.code();
                if (code != KeeperException.Code.CONNECTIONLOSS && code != KeeperException.Code.OPERATIONTIMEOUT && code != KeeperException.Code.SESSIONEXPIRED) {
                    throw e;
                }
                this.retryOrThrow(retry, e);
                retry.waitForNextAttempt();
                continue;
            }
            break;
        }
    }

    @Override
    public Stat getStatus(String zPath) throws KeeperException, InterruptedException {
        Retry retry = this.getRetryFactory().createRetry();
        while (true) {
            try {
                return this.getZooKeeper().exists(zPath, false);
            }
            catch (KeeperException e) {
                KeeperException.Code code = e.code();
                if (code != KeeperException.Code.CONNECTIONLOSS && code != KeeperException.Code.OPERATIONTIMEOUT && code != KeeperException.Code.SESSIONEXPIRED) {
                    throw e;
                }
                this.retryOrThrow(retry, e);
                retry.waitForNextAttempt();
                continue;
            }
            break;
        }
    }

    @Override
    public Stat getStatus(String zPath, Watcher watcher) throws KeeperException, InterruptedException {
        Retry retry = this.getRetryFactory().createRetry();
        while (true) {
            try {
                return this.getZooKeeper().exists(zPath, watcher);
            }
            catch (KeeperException e) {
                KeeperException.Code code = e.code();
                if (code != KeeperException.Code.CONNECTIONLOSS && code != KeeperException.Code.OPERATIONTIMEOUT && code != KeeperException.Code.SESSIONEXPIRED) {
                    throw e;
                }
                this.retryOrThrow(retry, e);
                retry.waitForNextAttempt();
                continue;
            }
            break;
        }
    }

    @Override
    public List<String> getChildren(String zPath) throws KeeperException, InterruptedException {
        Retry retry = this.getRetryFactory().createRetry();
        while (true) {
            try {
                return this.getZooKeeper().getChildren(zPath, false);
            }
            catch (KeeperException e) {
                KeeperException.Code code = e.code();
                if (code != KeeperException.Code.CONNECTIONLOSS && code != KeeperException.Code.OPERATIONTIMEOUT && code != KeeperException.Code.SESSIONEXPIRED) {
                    throw e;
                }
                this.retryOrThrow(retry, e);
                retry.waitForNextAttempt();
                continue;
            }
            break;
        }
    }

    @Override
    public List<String> getChildren(String zPath, Watcher watcher) throws KeeperException, InterruptedException {
        Retry retry = this.getRetryFactory().createRetry();
        while (true) {
            try {
                return this.getZooKeeper().getChildren(zPath, watcher);
            }
            catch (KeeperException e) {
                KeeperException.Code code = e.code();
                if (code != KeeperException.Code.CONNECTIONLOSS && code != KeeperException.Code.OPERATIONTIMEOUT && code != KeeperException.Code.SESSIONEXPIRED) {
                    throw e;
                }
                this.retryOrThrow(retry, e);
                retry.waitForNextAttempt();
                continue;
            }
            break;
        }
    }

    @Override
    public boolean exists(String zPath) throws KeeperException, InterruptedException {
        Retry retry = this.getRetryFactory().createRetry();
        while (true) {
            try {
                return this.getZooKeeper().exists(zPath, false) != null;
            }
            catch (KeeperException e) {
                KeeperException.Code code = e.code();
                if (code != KeeperException.Code.CONNECTIONLOSS && code != KeeperException.Code.OPERATIONTIMEOUT && code != KeeperException.Code.SESSIONEXPIRED) {
                    throw e;
                }
                this.retryOrThrow(retry, e);
                retry.waitForNextAttempt();
                continue;
            }
            break;
        }
    }

    @Override
    public boolean exists(String zPath, Watcher watcher) throws KeeperException, InterruptedException {
        Retry retry = this.getRetryFactory().createRetry();
        while (true) {
            try {
                return this.getZooKeeper().exists(zPath, watcher) != null;
            }
            catch (KeeperException e) {
                KeeperException.Code code = e.code();
                if (code != KeeperException.Code.CONNECTIONLOSS && code != KeeperException.Code.OPERATIONTIMEOUT && code != KeeperException.Code.SESSIONEXPIRED) {
                    throw e;
                }
                this.retryOrThrow(retry, e);
                retry.waitForNextAttempt();
                continue;
            }
            break;
        }
    }

    @Override
    public void sync(String path) throws KeeperException, InterruptedException {
        final AtomicInteger rc = new AtomicInteger();
        final CountDownLatch waiter = new CountDownLatch(1);
        this.getZooKeeper().sync(path, new AsyncCallback.VoidCallback(){

            public void processResult(int code, String arg1, Object arg2) {
                rc.set(code);
                waiter.countDown();
            }
        }, null);
        waiter.await();
        KeeperException.Code code = KeeperException.Code.get((int)rc.get());
        if (code != KeeperException.Code.OK) {
            throw KeeperException.create((KeeperException.Code)code);
        }
    }

    @Override
    public List<ACL> getACL(String zPath, Stat stat) throws KeeperException, InterruptedException {
        return ZooUtil.getACL(this.getZooKeeper(), zPath, stat);
    }

    public ZooReader(String keepers, int timeout) {
        this.keepers = keepers;
        this.timeout = timeout;
        this.retryFactory = ZooUtil.DEFAULT_RETRY;
    }
}

