/****************************************************************************
 * drivers/video/nxlogo80.c
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

/* Script-generated framebuffer splashscreen bitmap file.
 * Generated from drivers/video/nxlogo80.png
 * by splashscreen_converter.py
 */

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include <nuttx/video/fb.h>

/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/

/****************************************************************************
 * Private Data
 ****************************************************************************/

#ifdef CONFIG_VIDEO_FB_SPLASHSCREEN_BPP32
static const fb_pixel_t palette[] =
{
  MKRGB(0, 0, 0, 0),
  MKRGB(255, 60, 52, 227),
  MKRGB(255, 255, 255, 255),
  MKRGB(255, 206, 227, 241),
  MKRGB(255, 43, 39, 131),
  MKRGB(255, 254, 254, 255),
  MKRGB(255, 207, 228, 241),
  MKRGB(255, 90, 150, 189),
  MKRGB(255, 249, 251, 253),
  MKRGB(255, 207, 227, 241),
  MKRGB(255, 226, 238, 246),
  MKRGB(19, 60, 52, 227),
  MKRGB(255, 60, 52, 226),
  MKRGB(255, 238, 245, 250),
  MKRGB(255, 254, 255, 255),
  MKRGB(255, 214, 231, 243),
  MKRGB(255, 59, 51, 222),
  MKRGB(255, 54, 47, 194),
  MKRGB(255, 204, 225, 241),
  MKRGB(205, 60, 52, 227),
  MKRGB(255, 68, 63, 227),
  MKRGB(255, 205, 226, 240),
  MKRGB(5, 206, 227, 241),
  MKRGB(255, 232, 242, 248),
  MKRGB(250, 206, 227, 241),
  MKRGB(255, 169, 185, 209),
  MKRGB(255, 204, 225, 239),
  MKRGB(255, 74, 122, 212),
  MKRGB(255, 193, 213, 230),
  MKRGB(205, 61, 56, 227),
  MKRGB(255, 136, 149, 183),
  MKRGB(255, 92, 99, 153),
  MKRGB(255, 59, 68, 203),
  MKRGB(255, 54, 53, 135),
  MKRGB(255, 51, 50, 134),
  MKRGB(19, 94, 174, 225),
  MKRGB(205, 80, 134, 226),
  MKRGB(255, 170, 186, 236),
  MKRGB(255, 205, 226, 241),
  MKRGB(128, 90, 150, 189),
  MKRGB(255, 46, 41, 150),
  MKRGB(255, 43, 39, 133),
  MKRGB(255, 58, 50, 217),
  MKRGB(255, 52, 46, 187),
  MKRGB(255, 50, 44, 175),
  MKRGB(255, 54, 48, 198),
  MKRGB(255, 99, 104, 229),
  MKRGB(255, 153, 169, 196),
  MKRGB(255, 68, 108, 194),
  MKRGB(255, 68, 92, 226),
  MKRGB(255, 59, 54, 222),
  MKRGB(255, 94, 152, 190),
  MKRGB(98, 60, 52, 227),
  MKRGB(252, 60, 52, 226),
  MKRGB(255, 204, 226, 240),
  MKRGB(255, 148, 184, 211),
  MKRGB(36, 90, 150, 189),
  MKRGB(4, 90, 150, 189),
  MKRGB(255, 93, 152, 190),
  MKRGB(255, 195, 218, 235),
  MKRGB(255, 58, 56, 213),
  MKRGB(251, 90, 150, 189),
  MKRGB(96, 90, 150, 189),
  MKRGB(159, 206, 227, 241),
  MKRGB(251, 206, 227, 241),
  MKRGB(255, 63, 71, 227),
  MKRGB(255, 43, 39, 134),
  MKRGB(219, 90, 150, 189),
  MKRGB(255, 73, 121, 202),
  MKRGB(159, 90, 150, 189),
  MKRGB(255, 210, 229, 242),
  MKRGB(255, 204, 225, 240),
  MKRGB(36, 206, 227, 241),
  MKRGB(255, 194, 213, 239),
  MKRGB(255, 174, 203, 223),
  MKRGB(255, 116, 164, 197),
  MKRGB(255, 66, 60, 227),
  MKRGB(219, 206, 227, 241),
  MKRGB(4, 206, 227, 241),
  MKRGB(206, 60, 52, 227),
  MKRGB(96, 206, 227, 241),
  MKRGB(255, 139, 151, 231),
  MKRGB(255, 98, 102, 229),
  MKRGB(255, 56, 78, 145),
  MKRGB(255, 223, 237, 246),
  MKRGB(250, 90, 150, 189),
  MKRGB(255, 139, 151, 232),
  MKRGB(255, 88, 145, 186),
  MKRGB(255, 76, 122, 170),
  MKRGB(64, 90, 150, 189),
  MKRGB(255, 44, 42, 132),
  MKRGB(255, 249, 252, 253),
  MKRGB(19, 206, 227, 241),
  MKRGB(255, 194, 214, 239),
  MKRGB(248, 206, 227, 241),
  MKRGB(5, 90, 150, 189),
  MKRGB(206, 61, 56, 227),
  MKRGB(255, 51, 50, 135),
  MKRGB(255, 48, 43, 163),
  MKRGB(255, 44, 40, 141),
  MKRGB(255, 244, 248, 252),
  MKRGB(255, 217, 233, 244),
  MKRGB(255, 200, 220, 240),
  MKRGB(255, 195, 218, 234),
  MKRGB(255, 194, 214, 230),
  MKRGB(255, 194, 213, 238),
  MKRGB(255, 155, 171, 198),
  MKRGB(206, 80, 134, 226),
  MKRGB(255, 91, 98, 152),
  MKRGB(82, 206, 227, 241),
  MKRGB(255, 65, 60, 226),
  MKRGB(255, 43, 39, 132),
  MKRGB(5, 254, 255, 255),
  MKRGB(250, 254, 254, 255),
  MKRGB(255, 250, 252, 253),
  MKRGB(34, 90, 150, 189),
  MKRGB(255, 56, 49, 208),
  MKRGB(255, 243, 248, 251),
  MKRGB(255, 241, 247, 251),
  MKRGB(255, 235, 243, 249),
  MKRGB(255, 227, 239, 247),
  MKRGB(255, 227, 238, 247),
  MKRGB(255, 220, 235, 245),
  MKRGB(255, 215, 232, 243),
  MKRGB(3, 206, 227, 241),
  MKRGB(255, 206, 226, 241),
  MKRGB(254, 205, 226, 241),
  MKRGB(255, 204, 226, 241),
  MKRGB(255, 204, 224, 239),
  MKRGB(255, 203, 224, 239),
  MKRGB(255, 200, 222, 237),
  MKRGB(255, 199, 220, 235),
  MKRGB(236, 195, 218, 235),
  MKRGB(191, 90, 150, 189),
  MKRGB(255, 195, 215, 231),
  MKRGB(255, 183, 201, 221),
  MKRGB(205, 206, 227, 241),
  MKRGB(203, 206, 227, 241),
  MKRGB(35, 206, 227, 241),
  MKRGB(236, 206, 227, 241),
  MKRGB(220, 206, 227, 241),
  MKRGB(244, 206, 227, 241),
  MKRGB(81, 206, 227, 241),
  MKRGB(235, 206, 227, 241),
  MKRGB(63, 206, 227, 241),
  MKRGB(21, 134, 189, 229),
  MKRGB(255, 171, 188, 211),
  MKRGB(20, 90, 150, 189),
  MKRGB(69, 90, 150, 189),
  MKRGB(81, 90, 150, 189),
  MKRGB(126, 90, 150, 189),
  MKRGB(255, 131, 173, 203),
  MKRGB(255, 155, 170, 197),
  MKRGB(203, 120, 166, 199),
  MKRGB(255, 115, 163, 197),
  MKRGB(238, 144, 157, 233),
  MKRGB(255, 139, 153, 185),
  MKRGB(255, 98, 153, 191),
  MKRGB(255, 97, 153, 191),
  MKRGB(255, 136, 150, 183),
  MKRGB(255, 92, 147, 187),
  MKRGB(255, 108, 145, 183),
  MKRGB(206, 80, 133, 225),
  MKRGB(21, 120, 129, 231),
  MKRGB(255, 79, 125, 203),
  MKRGB(175, 90, 150, 189),
  MKRGB(255, 70, 114, 197),
  MKRGB(203, 90, 150, 189),
  MKRGB(19, 90, 150, 189),
  MKRGB(248, 90, 150, 189),
  MKRGB(255, 94, 100, 179),
  MKRGB(255, 44, 40, 135),
  MKRGB(255, 66, 90, 221),
  MKRGB(255, 64, 84, 147),
  MKRGB(255, 62, 83, 147),
  MKRGB(255, 79, 81, 195),
  MKRGB(255, 70, 79, 227),
  MKRGB(255, 65, 79, 227),
  MKRGB(255, 57, 67, 193),
  MKRGB(205, 69, 65, 227),
  MKRGB(255, 67, 63, 227),
  MKRGB(255, 66, 62, 219),
  MKRGB(255, 60, 61, 137),
  MKRGB(255, 62, 59, 195),
  MKRGB(255, 64, 58, 227),
  MKRGB(255, 58, 51, 217),
  MKRGB(255, 49, 44, 169),
  MKRGB(142, 90, 150, 189),
  MKRGB(158, 90, 150, 189),
  MKRGB(127, 206, 227, 241),
  MKRGB(252, 254, 254, 254),
  MKRGB(255, 253, 253, 254),
  MKRGB(255, 252, 253, 254),
  MKRGB(255, 239, 246, 250),
  MKRGB(255, 239, 245, 250),
  MKRGB(255, 233, 242, 248),
  MKRGB(255, 232, 241, 248),
  MKRGB(255, 223, 236, 246),
  MKRGB(255, 208, 228, 242),
  MKRGB(255, 206, 226, 240),
  MKRGB(20, 201, 223, 238),
  MKRGB(254, 60, 52, 226),
  MKRGB(255, 199, 219, 240),
  MKRGB(255, 195, 219, 238),
  MKRGB(175, 198, 218, 240),
  MKRGB(255, 188, 207, 238),
  MKRGB(255, 168, 198, 220),
  MKRGB(255, 52, 46, 186),
  MKRGB(255, 169, 186, 224),
  MKRGB(190, 142, 180, 208),
  MKRGB(255, 141, 180, 208),
  MKRGB(255, 132, 174, 204),
  MKRGB(255, 124, 169, 200),
  MKRGB(36, 153, 167, 234),
  MKRGB(130, 104, 156, 192),
  MKRGB(3, 99, 154, 192),
  MKRGB(250, 93, 152, 190),
  MKRGB(255, 92, 151, 190),
  MKRGB(94, 90, 150, 189),
  MKRGB(222, 88, 146, 186),
  MKRGB(146, 87, 142, 194),
  MKRGB(98, 86, 140, 196),
  MKRGB(205, 87, 138, 226),
  MKRGB(255, 111, 118, 230),
  MKRGB(178, 69, 107, 162),
  MKRGB(255, 97, 105, 156),
  MKRGB(255, 99, 104, 228),
  MKRGB(255, 95, 101, 190),
  MKRGB(255, 93, 101, 154),
  MKRGB(255, 64, 99, 188),
  MKRGB(126, 206, 227, 241),
  MKRGB(5, 207, 228, 241),
  MKRGB(255, 64, 89, 208),
  MKRGB(255, 83, 84, 228),
  MKRGB(254, 63, 81, 196),
  MKRGB(255, 65, 75, 204),
  MKRGB(255, 54, 74, 156),
  MKRGB(255, 58, 68, 198),
  MKRGB(255, 57, 67, 192),
  MKRGB(110, 206, 227, 241),
  MKRGB(255, 66, 65, 214),
  MKRGB(255, 57, 65, 194),
  MKRGB(255, 67, 63, 226),
  MKRGB(255, 67, 62, 222),
  MKRGB(255, 63, 59, 198),
  MKRGB(255, 59, 57, 178),
  MKRGB(205, 60, 56, 226),
  MKRGB(255, 56, 55, 150),
  MKRGB(255, 60, 53, 226),
  MKRGB(255, 58, 52, 218),
  MKRGB(255, 57, 50, 212),
  MKRGB(252, 56, 49, 206),
  MKRGB(255, 54, 49, 194),
  MKRGB(255, 53, 49, 192),
  MKRGB(255, 55, 48, 202),
};
#endif

#if defined(CONFIG_VIDEO_FB_SPLASHSCREEN_BPP24) || \
    defined(CONFIG_VIDEO_FB_SPLASHSCREEN_BPP16) || \
    defined(CONFIG_VIDEO_FB_SPLASHSCREEN_BPP8)
static const fb_pixel_t palette[] =
{
  MKRGB(0, 0, 0),
  MKRGB(60, 52, 227),
  MKRGB(255, 255, 255),
  MKRGB(206, 227, 241),
  MKRGB(43, 39, 131),
  MKRGB(90, 150, 189),
  MKRGB(254, 254, 255),
  MKRGB(207, 228, 241),
  MKRGB(249, 251, 253),
  MKRGB(207, 227, 241),
  MKRGB(226, 238, 246),
  MKRGB(60, 52, 226),
  MKRGB(238, 245, 250),
  MKRGB(254, 255, 255),
  MKRGB(214, 231, 243),
  MKRGB(59, 51, 222),
  MKRGB(54, 47, 194),
  MKRGB(204, 225, 241),
  MKRGB(68, 63, 227),
  MKRGB(205, 226, 240),
  MKRGB(232, 242, 248),
  MKRGB(169, 185, 209),
  MKRGB(204, 225, 239),
  MKRGB(61, 56, 227),
  MKRGB(74, 122, 212),
  MKRGB(193, 213, 230),
  MKRGB(136, 149, 183),
  MKRGB(92, 99, 153),
  MKRGB(59, 68, 203),
  MKRGB(54, 53, 135),
  MKRGB(51, 50, 134),
  MKRGB(94, 174, 225),
  MKRGB(80, 134, 226),
  MKRGB(205, 226, 241),
  MKRGB(170, 186, 236),
  MKRGB(46, 41, 150),
  MKRGB(43, 39, 133),
  MKRGB(58, 50, 217),
  MKRGB(52, 46, 187),
  MKRGB(50, 44, 175),
  MKRGB(54, 48, 198),
  MKRGB(99, 104, 229),
  MKRGB(153, 169, 196),
  MKRGB(68, 108, 194),
  MKRGB(68, 92, 226),
  MKRGB(59, 54, 222),
  MKRGB(94, 152, 190),
  MKRGB(204, 226, 240),
  MKRGB(195, 218, 235),
  MKRGB(148, 184, 211),
  MKRGB(93, 152, 190),
  MKRGB(58, 56, 213),
  MKRGB(63, 71, 227),
  MKRGB(43, 39, 134),
  MKRGB(73, 121, 202),
  MKRGB(210, 229, 242),
  MKRGB(204, 225, 240),
  MKRGB(194, 213, 239),
  MKRGB(174, 203, 223),
  MKRGB(116, 164, 197),
  MKRGB(66, 60, 227),
  MKRGB(139, 151, 231),
  MKRGB(98, 102, 229),
  MKRGB(56, 78, 145),
  MKRGB(223, 237, 246),
  MKRGB(139, 151, 232),
  MKRGB(88, 145, 186),
  MKRGB(76, 122, 170),
  MKRGB(44, 42, 132),
  MKRGB(249, 252, 253),
  MKRGB(206, 226, 241),
  MKRGB(194, 214, 239),
  MKRGB(51, 50, 135),
  MKRGB(48, 43, 163),
  MKRGB(44, 40, 141),
  MKRGB(244, 248, 252),
  MKRGB(217, 233, 244),
  MKRGB(200, 220, 240),
  MKRGB(195, 218, 234),
  MKRGB(194, 214, 230),
  MKRGB(194, 213, 238),
  MKRGB(155, 171, 198),
  MKRGB(91, 98, 152),
  MKRGB(65, 60, 226),
  MKRGB(43, 39, 132),
  MKRGB(250, 252, 253),
  MKRGB(56, 49, 208),
  MKRGB(243, 248, 251),
  MKRGB(241, 247, 251),
  MKRGB(235, 243, 249),
  MKRGB(227, 239, 247),
  MKRGB(227, 238, 247),
  MKRGB(220, 235, 245),
  MKRGB(215, 232, 243),
  MKRGB(204, 226, 241),
  MKRGB(204, 224, 239),
  MKRGB(203, 224, 239),
  MKRGB(200, 222, 237),
  MKRGB(199, 220, 235),
  MKRGB(195, 215, 231),
  MKRGB(183, 201, 221),
  MKRGB(134, 189, 229),
  MKRGB(171, 188, 211),
  MKRGB(131, 173, 203),
  MKRGB(155, 170, 197),
  MKRGB(120, 166, 199),
  MKRGB(115, 163, 197),
  MKRGB(144, 157, 233),
  MKRGB(139, 153, 185),
  MKRGB(98, 153, 191),
  MKRGB(97, 153, 191),
  MKRGB(136, 150, 183),
  MKRGB(92, 147, 187),
  MKRGB(108, 145, 183),
  MKRGB(80, 133, 225),
  MKRGB(120, 129, 231),
  MKRGB(79, 125, 203),
  MKRGB(70, 114, 197),
  MKRGB(94, 100, 179),
  MKRGB(44, 40, 135),
  MKRGB(66, 90, 221),
  MKRGB(64, 84, 147),
  MKRGB(62, 83, 147),
  MKRGB(79, 81, 195),
  MKRGB(70, 79, 227),
  MKRGB(65, 79, 227),
  MKRGB(57, 67, 193),
  MKRGB(69, 65, 227),
  MKRGB(67, 63, 227),
  MKRGB(66, 62, 219),
  MKRGB(60, 61, 137),
  MKRGB(62, 59, 195),
  MKRGB(64, 58, 227),
  MKRGB(58, 51, 217),
  MKRGB(49, 44, 169),
  MKRGB(254, 254, 254),
  MKRGB(253, 253, 254),
  MKRGB(252, 253, 254),
  MKRGB(239, 246, 250),
  MKRGB(239, 245, 250),
  MKRGB(233, 242, 248),
  MKRGB(232, 241, 248),
  MKRGB(223, 236, 246),
  MKRGB(208, 228, 242),
  MKRGB(206, 226, 240),
  MKRGB(201, 223, 238),
  MKRGB(199, 219, 240),
  MKRGB(195, 219, 238),
  MKRGB(198, 218, 240),
  MKRGB(188, 207, 238),
  MKRGB(168, 198, 220),
  MKRGB(52, 46, 186),
  MKRGB(169, 186, 224),
  MKRGB(142, 180, 208),
  MKRGB(141, 180, 208),
  MKRGB(132, 174, 204),
  MKRGB(124, 169, 200),
  MKRGB(153, 167, 234),
  MKRGB(104, 156, 192),
  MKRGB(99, 154, 192),
  MKRGB(92, 151, 190),
  MKRGB(88, 146, 186),
  MKRGB(87, 142, 194),
  MKRGB(86, 140, 196),
  MKRGB(87, 138, 226),
  MKRGB(111, 118, 230),
  MKRGB(69, 107, 162),
  MKRGB(97, 105, 156),
  MKRGB(99, 104, 228),
  MKRGB(95, 101, 190),
  MKRGB(93, 101, 154),
  MKRGB(64, 99, 188),
  MKRGB(64, 89, 208),
  MKRGB(83, 84, 228),
  MKRGB(63, 81, 196),
  MKRGB(65, 75, 204),
  MKRGB(54, 74, 156),
  MKRGB(58, 68, 198),
  MKRGB(57, 67, 192),
  MKRGB(66, 65, 214),
  MKRGB(57, 65, 194),
  MKRGB(67, 63, 226),
  MKRGB(67, 62, 222),
  MKRGB(63, 59, 198),
  MKRGB(59, 57, 178),
  MKRGB(60, 56, 226),
  MKRGB(56, 55, 150),
  MKRGB(60, 53, 226),
  MKRGB(58, 52, 218),
  MKRGB(57, 50, 212),
  MKRGB(56, 49, 206),
  MKRGB(54, 49, 194),
  MKRGB(53, 49, 192),
  MKRGB(55, 48, 202),
  MKRGB(52, 46, 188),
  MKRGB(44, 43, 134),
};
#endif

#if defined(CONFIG_VIDEO_FB_SPLASHSCREEN_GREY) || \
    defined(CONFIG_VIDEO_FB_SPLASHSCREEN_MONO)
static const fb_pixel_t palette[] =
{
};
#endif

#ifdef CONFIG_VIDEO_FB_SPLASHSCREEN_BPP32
static const struct splscr_bitmap_s bitmap[] =
{
  {37, 0},
  {1, 35},
  {1, 107},
  {1, 248},
  {1, 1},
  {1, 79},
  {1, 11},
  {37, 0},                                                /* End of row   1 */
  {36, 0},
  {1, 35},
  {1, 36},
  {1, 50},
  {1, 229},
  {1, 241},
  {1, 12},
  {1, 19},
  {1, 11},
  {36, 0},                                                /* End of row   2 */
  {35, 0},
  {1, 35},
  {1, 36},
  {1, 50},
  {1, 48},
  {1, 49},
  {1, 16},
  {1, 17},
  {1, 12},
  {1, 19},
  {1, 11},
  {35, 0},                                                /* End of row   3 */
  {34, 0},
  {1, 35},
  {1, 36},
  {1, 50},
  {1, 48},
  {1, 49},
  {2, 1},
  {1, 16},
  {1, 17},
  {1, 12},
  {1, 19},
  {1, 11},
  {34, 0},                                                /* End of row   4 */
  {33, 0},
  {1, 35},
  {1, 36},
  {1, 50},
  {1, 48},
  {1, 49},
  {4, 1},
  {1, 16},
  {1, 17},
  {1, 12},
  {1, 19},
  {1, 11},
  {33, 0},                                                /* End of row   5 */
  {32, 0},
  {1, 35},
  {1, 36},
  {1, 50},
  {1, 48},
  {1, 49},
  {6, 1},
  {1, 16},
  {1, 17},
  {1, 12},
  {1, 19},
  {1, 11},
  {32, 0},                                                /* End of row   6 */
  {31, 0},
  {1, 35},
  {1, 36},
  {1, 50},
  {1, 48},
  {1, 49},
  {8, 1},
  {1, 16},
  {1, 17},
  {1, 12},
  {1, 19},
  {1, 11},
  {31, 0},                                                /* End of row   7 */
  {30, 0},
  {1, 35},
  {1, 36},
  {1, 50},
  {1, 48},
  {1, 49},
  {10, 1},
  {1, 16},
  {1, 17},
  {1, 12},
  {1, 19},
  {1, 11},
  {30, 0},                                                /* End of row   8 */
  {29, 0},
  {1, 35},
  {1, 36},
  {1, 50},
  {1, 48},
  {1, 49},
  {12, 1},
  {1, 16},
  {1, 17},
  {1, 12},
  {1, 19},
  {1, 11},
  {13, 0},
  {1, 124},
  {2, 22},
  {13, 0},                                                /* End of row   9 */
  {28, 0},
  {1, 35},
  {1, 36},
  {1, 50},
  {1, 48},
  {1, 49},
  {4, 1},
  {1, 184},
  {1, 20},
  {1, 180},
  {7, 1},
  {1, 16},
  {1, 17},
  {1, 12},
  {1, 19},
  {1, 11},
  {11, 0},
  {1, 109},
  {1, 77},
  {1, 24},
  {1, 94},
  {1, 63},
  {1, 92},
  {11, 0},                                                /* End of row  10 */
  {11, 0},
  {1, 72},
  {1, 230},
  {1, 189},
  {1, 239},
  {1, 78},
  {11, 0},
  {1, 35},
  {1, 36},
  {1, 50},
  {1, 48},
  {1, 49},
  {4, 1},
  {1, 223},
  {1, 73},
  {2, 18},
  {1, 37},
  {1, 233},
  {6, 1},
  {1, 16},
  {1, 17},
  {1, 12},
  {1, 19},
  {1, 11},
  {9, 0},
  {1, 72},
  {1, 64},
  {4, 3},
  {1, 136},
  {1, 92},
  {10, 0},                                                /* End of row  11 */
  {10, 0},
  {1, 109},
  {1, 64},
  {3, 3},
  {1, 137},
  {1, 200},
  {2, 95},
  {7, 0},
  {1, 35},
  {1, 36},
  {1, 50},
  {1, 48},
  {1, 49},
  {4, 1},
  {1, 82},
  {1, 102},
  {4, 3},
  {1, 205},
  {1, 175},
  {1, 43},
  {1, 42},
  {4, 1},
  {1, 16},
  {1, 17},
  {1, 12},
  {1, 19},
  {1, 11},
  {8, 0},
  {1, 63},
  {2, 3},
  {2, 70},
  {2, 3},
  {1, 63},
  {1, 215},
  {9, 0},                                                 /* End of row  12 */
  {9, 0},
  {1, 138},
  {1, 139},
  {5, 3},
  {1, 132},
  {1, 216},
  {1, 169},
  {1, 188},
  {1, 57},
  {4, 0},
  {1, 35},
  {1, 36},
  {1, 50},
  {1, 48},
  {1, 49},
  {5, 1},
  {1, 37},
  {1, 3},
  {1, 70},
  {1, 196},
  {1, 197},
  {2, 3},
  {1, 25},
  {1, 4},
  {1, 99},
  {1, 250},
  {4, 1},
  {1, 16},
  {1, 17},
  {1, 12},
  {1, 19},
  {1, 11},
  {6, 0},
  {1, 72},
  {1, 64},
  {1, 3},
  {1, 84},
  {2, 5},
  {1, 84},
  {1, 3},
  {1, 126},
  {1, 153},
  {1, 168},
  {8, 0},                                                 /* End of row  13 */
  {9, 0},
  {1, 63},
  {1, 3},
  {1, 70},
  {1, 13},
  {1, 118},
  {1, 70},
  {2, 3},
  {1, 55},
  {2, 7},
  {1, 62},
  {3, 0},
  {1, 35},
  {1, 36},
  {1, 50},
  {1, 48},
  {1, 49},
  {5, 1},
  {1, 76},
  {1, 202},
  {1, 3},
  {1, 23},
  {2, 2},
  {1, 84},
  {1, 3},
  {1, 21},
  {1, 31},
  {1, 4},
  {1, 99},
  {1, 42},
  {4, 1},
  {1, 16},
  {1, 17},
  {1, 12},
  {1, 19},
  {1, 11},
  {5, 0},
  {1, 63},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 117},
  {2, 3},
  {1, 211},
  {1, 167},
  {1, 57},
  {7, 0},                                                 /* End of row  14 */
  {8, 0},
  {1, 22},
  {1, 94},
  {1, 3},
  {1, 13},
  {2, 2},
  {1, 119},
  {2, 3},
  {1, 59},
  {1, 58},
  {1, 7},
  {1, 67},
  {1, 57},
  {1, 0},
  {1, 35},
  {1, 36},
  {1, 50},
  {1, 48},
  {1, 49},
  {6, 1},
  {1, 20},
  {1, 18},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 25},
  {2, 4},
  {1, 44},
  {5, 1},
  {1, 16},
  {1, 17},
  {1, 12},
  {1, 19},
  {1, 11},
  {3, 0},
  {1, 72},
  {1, 64},
  {1, 3},
  {1, 10},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 21},
  {1, 154},
  {1, 7},
  {1, 218},
  {7, 0},                                                 /* End of row  15 */
  {8, 0},
  {1, 22},
  {1, 24},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 14},
  {1, 15},
  {2, 3},
  {1, 55},
  {2, 7},
  {1, 62},
  {1, 35},
  {1, 36},
  {1, 50},
  {1, 48},
  {1, 49},
  {7, 1},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 21},
  {1, 31},
  {1, 4},
  {1, 41},
  {1, 42},
  {5, 1},
  {1, 16},
  {1, 17},
  {1, 12},
  {1, 19},
  {1, 11},
  {2, 0},
  {1, 63},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 74},
  {2, 7},
  {1, 165},
  {7, 0},                                                 /* End of row  16 */
  {8, 0},
  {1, 22},
  {1, 24},
  {1, 6},
  {1, 5},
  {3, 2},
  {1, 13},
  {2, 3},
  {1, 59},
  {1, 58},
  {1, 7},
  {1, 219},
  {1, 162},
  {1, 50},
  {1, 48},
  {1, 49},
  {8, 1},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {3, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 25},
  {2, 4},
  {1, 44},
  {6, 1},
  {1, 16},
  {1, 17},
  {1, 12},
  {1, 19},
  {1, 11},
  {1, 72},
  {1, 64},
  {1, 3},
  {1, 10},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 21},
  {1, 75},
  {2, 7},
  {1, 187},
  {7, 0},                                                 /* End of row  17 */
  {8, 0},
  {1, 22},
  {1, 24},
  {1, 6},
  {1, 5},
  {3, 2},
  {1, 14},
  {1, 15},
  {2, 3},
  {1, 55},
  {1, 87},
  {1, 83},
  {1, 253},
  {1, 48},
  {1, 49},
  {9, 1},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {4, 2},
  {1, 10},
  {1, 3},
  {1, 21},
  {1, 31},
  {1, 4},
  {1, 41},
  {1, 42},
  {6, 1},
  {1, 16},
  {1, 17},
  {1, 12},
  {1, 19},
  {1, 204},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 206},
  {2, 7},
  {1, 61},
  {1, 56},
  {7, 0},                                                 /* End of row  18 */
  {8, 0},
  {1, 22},
  {1, 24},
  {1, 6},
  {1, 5},
  {4, 2},
  {1, 13},
  {2, 3},
  {1, 103},
  {1, 174},
  {1, 4},
  {1, 90},
  {1, 172},
  {10, 1},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {4, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 25},
  {2, 4},
  {1, 44},
  {7, 1},
  {1, 16},
  {1, 17},
  {1, 226},
  {1, 38},
  {1, 3},
  {1, 10},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 21},
  {1, 75},
  {2, 7},
  {1, 69},
  {8, 0},                                                 /* End of row  19 */
  {8, 0},
  {1, 22},
  {1, 24},
  {1, 6},
  {1, 5},
  {4, 2},
  {1, 14},
  {1, 15},
  {2, 3},
  {1, 30},
  {2, 4},
  {1, 45},
  {10, 1},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {5, 2},
  {1, 10},
  {1, 3},
  {1, 21},
  {1, 31},
  {1, 4},
  {1, 41},
  {1, 42},
  {7, 1},
  {1, 16},
  {1, 208},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 74},
  {2, 7},
  {1, 61},
  {1, 56},
  {8, 0},                                                 /* End of row  20 */
  {8, 0},
  {1, 22},
  {1, 24},
  {1, 6},
  {1, 5},
  {5, 2},
  {1, 13},
  {2, 3},
  {1, 28},
  {1, 34},
  {1, 4},
  {1, 40},
  {1, 12},
  {9, 1},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {5, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 25},
  {2, 4},
  {1, 44},
  {7, 1},
  {1, 46},
  {1, 38},
  {1, 3},
  {1, 10},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 21},
  {1, 75},
  {2, 7},
  {1, 69},
  {9, 0},                                                 /* End of row  21 */
  {8, 0},
  {1, 22},
  {1, 24},
  {1, 6},
  {1, 5},
  {5, 2},
  {1, 14},
  {1, 15},
  {2, 3},
  {1, 30},
  {2, 4},
  {1, 45},
  {9, 1},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 91},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 21},
  {1, 31},
  {1, 4},
  {1, 41},
  {1, 42},
  {6, 1},
  {1, 37},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 74},
  {2, 7},
  {1, 61},
  {1, 56},
  {9, 0},                                                 /* End of row  22 */
  {8, 0},
  {1, 22},
  {1, 24},
  {1, 6},
  {1, 5},
  {3, 2},
  {1, 114},
  {2, 2},
  {1, 13},
  {2, 3},
  {1, 28},
  {1, 34},
  {1, 4},
  {1, 40},
  {1, 12},
  {8, 1},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 195},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 25},
  {2, 4},
  {1, 44},
  {5, 1},
  {1, 46},
  {1, 38},
  {1, 3},
  {1, 10},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 21},
  {1, 75},
  {2, 7},
  {1, 69},
  {10, 0},                                                /* End of row  23 */
  {8, 0},
  {1, 22},
  {1, 24},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 120},
  {2, 2},
  {1, 14},
  {1, 15},
  {2, 3},
  {1, 30},
  {2, 4},
  {1, 45},
  {8, 1},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 23},
  {1, 10},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 21},
  {1, 31},
  {1, 4},
  {1, 41},
  {1, 42},
  {4, 1},
  {1, 37},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 74},
  {2, 7},
  {1, 61},
  {1, 56},
  {10, 0},                                                /* End of row  24 */
  {8, 0},
  {1, 22},
  {1, 24},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 198},
  {1, 8},
  {2, 2},
  {1, 13},
  {2, 3},
  {1, 28},
  {1, 34},
  {1, 4},
  {1, 40},
  {1, 12},
  {7, 1},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 23},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 25},
  {2, 4},
  {1, 44},
  {3, 1},
  {1, 46},
  {1, 38},
  {1, 3},
  {1, 10},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 21},
  {1, 161},
  {2, 7},
  {1, 69},
  {11, 0},                                                /* End of row  25 */
  {8, 0},
  {1, 22},
  {1, 24},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 10},
  {2, 2},
  {1, 14},
  {1, 15},
  {2, 3},
  {1, 30},
  {2, 4},
  {1, 45},
  {7, 1},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 23},
  {1, 3},
  {1, 10},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 21},
  {1, 31},
  {1, 4},
  {1, 41},
  {1, 42},
  {2, 1},
  {1, 37},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 25},
  {1, 90},
  {1, 88},
  {1, 61},
  {1, 56},
  {11, 0},                                                /* End of row  26 */
  {8, 0},
  {1, 22},
  {1, 24},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 13},
  {2, 3},
  {1, 28},
  {1, 34},
  {1, 4},
  {1, 40},
  {1, 12},
  {6, 1},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 23},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 25},
  {2, 4},
  {1, 44},
  {1, 1},
  {1, 46},
  {1, 38},
  {1, 3},
  {1, 10},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 21},
  {1, 31},
  {1, 4},
  {1, 90},
  {1, 224},
  {12, 0},                                                /* End of row  27 */
  {8, 0},
  {1, 22},
  {1, 24},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 3},
  {1, 10},
  {2, 2},
  {1, 14},
  {1, 15},
  {2, 3},
  {1, 30},
  {2, 4},
  {1, 45},
  {6, 1},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 23},
  {2, 3},
  {1, 10},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 21},
  {1, 31},
  {1, 4},
  {1, 41},
  {1, 185},
  {1, 37},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 25},
  {2, 4},
  {1, 111},
  {1, 251},
  {1, 52},
  {11, 0},                                                /* End of row  28 */
  {8, 0},
  {1, 22},
  {1, 24},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 13},
  {2, 3},
  {1, 28},
  {1, 34},
  {1, 4},
  {1, 40},
  {1, 12},
  {5, 1},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 23},
  {2, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 25},
  {2, 4},
  {1, 170},
  {1, 38},
  {1, 3},
  {1, 10},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 21},
  {1, 31},
  {2, 4},
  {1, 186},
  {1, 17},
  {1, 53},
  {1, 52},
  {10, 0},                                                /* End of row  29 */
  {8, 0},
  {1, 145},
  {1, 64},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {2, 3},
  {1, 10},
  {2, 2},
  {1, 14},
  {1, 15},
  {2, 3},
  {1, 30},
  {2, 4},
  {1, 45},
  {5, 1},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 23},
  {3, 3},
  {1, 10},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 21},
  {1, 31},
  {1, 4},
  {1, 25},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 25},
  {2, 4},
  {1, 41},
  {1, 42},
  {1, 16},
  {1, 17},
  {1, 53},
  {1, 52},
  {9, 0},                                                 /* End of row  30 */
  {7, 0},
  {1, 35},
  {1, 222},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {2, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 13},
  {2, 3},
  {1, 28},
  {1, 34},
  {1, 4},
  {1, 40},
  {1, 12},
  {4, 1},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 23},
  {1, 3},
  {1, 104},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 25},
  {1, 31},
  {1, 21},
  {1, 3},
  {1, 10},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 21},
  {1, 31},
  {2, 4},
  {1, 44},
  {2, 1},
  {1, 16},
  {1, 17},
  {1, 53},
  {1, 52},
  {8, 0},                                                 /* End of row  31 */
  {6, 0},
  {1, 35},
  {1, 36},
  {1, 240},
  {1, 71},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {3, 3},
  {1, 10},
  {2, 2},
  {1, 14},
  {1, 15},
  {2, 3},
  {1, 30},
  {2, 4},
  {1, 45},
  {4, 1},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 23},
  {1, 3},
  {1, 106},
  {1, 28},
  {1, 3},
  {1, 10},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 21},
  {1, 135},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 25},
  {2, 4},
  {1, 41},
  {1, 42},
  {3, 1},
  {1, 16},
  {1, 17},
  {1, 53},
  {1, 52},
  {7, 0},                                                 /* End of row  32 */
  {5, 0},
  {1, 35},
  {1, 36},
  {1, 60},
  {1, 164},
  {1, 127},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 26},
  {1, 146},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 13},
  {2, 3},
  {1, 28},
  {1, 34},
  {1, 4},
  {1, 40},
  {1, 12},
  {3, 1},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 23},
  {1, 3},
  {1, 47},
  {1, 30},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {3, 3},
  {1, 10},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 21},
  {1, 31},
  {2, 4},
  {1, 44},
  {5, 1},
  {1, 16},
  {1, 17},
  {1, 53},
  {1, 52},
  {6, 0},                                                 /* End of row  33 */
  {4, 0},
  {1, 35},
  {1, 36},
  {1, 60},
  {1, 68},
  {1, 176},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 26},
  {1, 225},
  {1, 21},
  {1, 3},
  {1, 10},
  {2, 2},
  {1, 14},
  {1, 15},
  {2, 3},
  {1, 30},
  {2, 4},
  {1, 45},
  {3, 1},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 23},
  {1, 3},
  {1, 47},
  {1, 34},
  {1, 28},
  {1, 3},
  {1, 10},
  {3, 2},
  {1, 10},
  {2, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 25},
  {2, 4},
  {1, 41},
  {1, 42},
  {6, 1},
  {1, 16},
  {1, 17},
  {1, 53},
  {1, 52},
  {5, 0},                                                 /* End of row  34 */
  {3, 0},
  {1, 35},
  {1, 36},
  {1, 60},
  {1, 68},
  {1, 65},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 26},
  {1, 33},
  {1, 25},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 13},
  {2, 3},
  {1, 28},
  {1, 34},
  {1, 4},
  {1, 40},
  {1, 12},
  {2, 1},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 23},
  {1, 3},
  {1, 47},
  {1, 4},
  {1, 30},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 10},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 21},
  {1, 31},
  {2, 4},
  {1, 44},
  {8, 1},
  {1, 16},
  {1, 17},
  {1, 53},
  {1, 52},
  {4, 0},                                                 /* End of row  35 */
  {2, 0},
  {1, 35},
  {1, 36},
  {1, 60},
  {1, 68},
  {1, 65},
  {1, 1},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 26},
  {1, 33},
  {1, 31},
  {1, 21},
  {1, 3},
  {1, 10},
  {2, 2},
  {1, 14},
  {1, 15},
  {2, 3},
  {1, 30},
  {2, 4},
  {1, 45},
  {2, 1},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 23},
  {1, 3},
  {1, 47},
  {1, 4},
  {1, 34},
  {1, 28},
  {1, 3},
  {1, 10},
  {3, 2},
  {1, 10},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 25},
  {2, 4},
  {1, 41},
  {1, 42},
  {9, 1},
  {1, 16},
  {1, 17},
  {1, 53},
  {1, 52},
  {3, 0},                                                 /* End of row  36 */
  {1, 0},
  {1, 35},
  {1, 36},
  {1, 60},
  {1, 68},
  {1, 65},
  {2, 1},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 26},
  {1, 33},
  {1, 4},
  {1, 25},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 13},
  {2, 3},
  {1, 28},
  {1, 34},
  {1, 4},
  {1, 40},
  {1, 12},
  {1, 1},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 23},
  {1, 3},
  {1, 47},
  {2, 4},
  {1, 30},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 121},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 21},
  {1, 31},
  {2, 4},
  {1, 44},
  {11, 1},
  {1, 16},
  {1, 17},
  {1, 53},
  {1, 52},
  {2, 0},                                                 /* End of row  37 */
  {1, 35},
  {1, 36},
  {1, 60},
  {1, 68},
  {1, 65},
  {3, 1},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 26},
  {1, 33},
  {1, 4},
  {1, 31},
  {1, 21},
  {1, 3},
  {1, 10},
  {2, 2},
  {1, 14},
  {1, 15},
  {2, 3},
  {1, 30},
  {2, 4},
  {1, 45},
  {1, 1},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 23},
  {1, 3},
  {1, 47},
  {2, 4},
  {1, 97},
  {1, 105},
  {1, 3},
  {1, 10},
  {6, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 25},
  {2, 4},
  {1, 41},
  {1, 42},
  {12, 1},
  {1, 16},
  {1, 17},
  {1, 53},
  {1, 52},
  {1, 0},                                                 /* End of row  38 */
  {1, 107},
  {1, 60},
  {1, 68},
  {1, 65},
  {4, 1},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 26},
  {1, 33},
  {2, 4},
  {1, 25},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 13},
  {2, 3},
  {1, 28},
  {1, 34},
  {1, 4},
  {1, 40},
  {1, 12},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 23},
  {1, 3},
  {1, 47},
  {2, 4},
  {1, 66},
  {1, 81},
  {1, 3},
  {1, 9},
  {1, 8},
  {5, 2},
  {1, 10},
  {1, 3},
  {1, 21},
  {1, 31},
  {2, 4},
  {1, 44},
  {14, 1},
  {1, 16},
  {1, 17},
  {1, 53},
  {1, 52},                                                /* End of row  39 */
  {1, 249},
  {1, 166},
  {1, 65},
  {5, 1},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 26},
  {1, 33},
  {2, 4},
  {1, 227},
  {1, 38},
  {1, 3},
  {1, 10},
  {2, 2},
  {1, 14},
  {1, 15},
  {2, 3},
  {1, 30},
  {2, 4},
  {1, 45},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 23},
  {1, 3},
  {1, 47},
  {2, 4},
  {1, 66},
  {1, 110},
  {1, 93},
  {1, 3},
  {1, 10},
  {4, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 25},
  {2, 4},
  {1, 41},
  {1, 42},
  {15, 1},
  {1, 16},
  {1, 17},
  {1, 201},                                               /* End of row  40 */
  {1, 12},
  {1, 252},
  {1, 16},
  {5, 1},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 26},
  {1, 33},
  {2, 4},
  {1, 43},
  {1, 37},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 13},
  {2, 3},
  {1, 28},
  {1, 34},
  {1, 4},
  {1, 40},
  {1, 242},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 23},
  {1, 3},
  {1, 47},
  {2, 4},
  {1, 66},
  {1, 110},
  {1, 93},
  {1, 3},
  {1, 15},
  {4, 2},
  {1, 23},
  {1, 3},
  {1, 21},
  {1, 228},
  {2, 4},
  {1, 44},
  {17, 1},
  {1, 237},
  {1, 232},                                               /* End of row  41 */
  {1, 79},
  {1, 12},
  {1, 17},
  {1, 16},
  {4, 1},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 26},
  {1, 33},
  {2, 4},
  {1, 43},
  {1, 46},
  {1, 38},
  {1, 3},
  {1, 10},
  {2, 2},
  {1, 14},
  {1, 15},
  {2, 3},
  {1, 30},
  {2, 4},
  {1, 244},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 23},
  {1, 3},
  {1, 47},
  {2, 4},
  {1, 66},
  {1, 81},
  {2, 3},
  {1, 13},
  {4, 2},
  {1, 13},
  {2, 3},
  {1, 30},
  {2, 4},
  {1, 44},
  {16, 1},
  {1, 32},
  {1, 27},
  {1, 96},                                                /* End of row  42 */
  {1, 11},
  {1, 19},
  {1, 12},
  {1, 17},
  {1, 16},
  {3, 1},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 26},
  {1, 33},
  {2, 4},
  {1, 43},
  {1, 1},
  {1, 37},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 13},
  {2, 3},
  {1, 28},
  {1, 34},
  {1, 4},
  {1, 247},
  {1, 71},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 23},
  {1, 3},
  {1, 47},
  {2, 4},
  {1, 97},
  {1, 105},
  {1, 3},
  {1, 15},
  {1, 14},
  {4, 2},
  {1, 14},
  {1, 15},
  {1, 3},
  {1, 28},
  {1, 34},
  {1, 4},
  {1, 41},
  {1, 42},
  {14, 1},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 11},                                                /* End of row  43 */
  {1, 0},
  {1, 11},
  {1, 19},
  {1, 12},
  {1, 17},
  {1, 16},
  {2, 1},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 26},
  {1, 33},
  {2, 4},
  {1, 43},
  {1, 1},
  {1, 46},
  {1, 38},
  {1, 3},
  {1, 10},
  {2, 2},
  {1, 14},
  {1, 15},
  {2, 3},
  {1, 30},
  {1, 4},
  {1, 33},
  {1, 26},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 23},
  {1, 3},
  {1, 47},
  {2, 4},
  {1, 30},
  {2, 3},
  {1, 13},
  {6, 2},
  {1, 13},
  {2, 3},
  {1, 30},
  {2, 4},
  {1, 44},
  {13, 1},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 11},
  {1, 0},                                                 /* End of row  44 */
  {2, 0},
  {1, 11},
  {1, 19},
  {1, 12},
  {1, 17},
  {1, 16},
  {1, 1},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 26},
  {1, 33},
  {2, 4},
  {1, 43},
  {2, 1},
  {1, 37},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 13},
  {2, 3},
  {1, 28},
  {1, 34},
  {1, 33},
  {1, 26},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 23},
  {1, 3},
  {1, 47},
  {1, 4},
  {1, 34},
  {1, 28},
  {1, 3},
  {1, 15},
  {1, 14},
  {2, 2},
  {1, 91},
  {1, 100},
  {2, 2},
  {1, 14},
  {1, 15},
  {1, 3},
  {1, 28},
  {1, 34},
  {1, 4},
  {1, 41},
  {1, 42},
  {11, 1},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 11},
  {2, 0},                                                 /* End of row  45 */
  {3, 0},
  {1, 11},
  {1, 19},
  {1, 12},
  {1, 17},
  {1, 16},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 26},
  {1, 33},
  {2, 4},
  {1, 43},
  {2, 1},
  {1, 46},
  {1, 38},
  {1, 3},
  {1, 10},
  {2, 2},
  {1, 14},
  {1, 15},
  {2, 3},
  {1, 30},
  {1, 33},
  {1, 26},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 23},
  {1, 3},
  {1, 47},
  {1, 4},
  {1, 30},
  {2, 3},
  {1, 13},
  {3, 2},
  {1, 10},
  {1, 15},
  {1, 14},
  {2, 2},
  {1, 13},
  {2, 3},
  {1, 30},
  {2, 4},
  {1, 44},
  {10, 1},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 11},
  {3, 0},                                                 /* End of row  46 */
  {4, 0},
  {1, 11},
  {1, 19},
  {1, 12},
  {1, 17},
  {1, 243},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 26},
  {1, 33},
  {2, 4},
  {1, 43},
  {3, 1},
  {1, 37},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 13},
  {2, 3},
  {1, 28},
  {1, 182},
  {1, 26},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 23},
  {1, 3},
  {1, 47},
  {1, 34},
  {1, 28},
  {1, 3},
  {1, 15},
  {1, 14},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 13},
  {2, 2},
  {1, 14},
  {1, 15},
  {1, 3},
  {1, 28},
  {1, 34},
  {1, 4},
  {1, 41},
  {1, 42},
  {8, 1},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 11},
  {4, 0},                                                 /* End of row  47 */
  {5, 0},
  {1, 11},
  {1, 19},
  {1, 12},
  {1, 183},
  {1, 71},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 26},
  {1, 33},
  {2, 4},
  {1, 43},
  {3, 1},
  {1, 46},
  {1, 38},
  {1, 3},
  {1, 10},
  {2, 2},
  {1, 14},
  {1, 15},
  {2, 3},
  {1, 156},
  {1, 26},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 23},
  {1, 3},
  {1, 47},
  {1, 30},
  {2, 3},
  {1, 13},
  {3, 2},
  {1, 10},
  {2, 3},
  {1, 15},
  {1, 14},
  {2, 2},
  {1, 13},
  {2, 3},
  {1, 30},
  {2, 4},
  {1, 44},
  {7, 1},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 11},
  {5, 0},                                                 /* End of row  48 */
  {6, 0},
  {1, 11},
  {1, 19},
  {1, 20},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 26},
  {1, 33},
  {2, 4},
  {1, 43},
  {4, 1},
  {1, 37},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 13},
  {2, 3},
  {1, 134},
  {1, 21},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 23},
  {1, 3},
  {1, 106},
  {1, 28},
  {1, 3},
  {1, 15},
  {1, 14},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 125},
  {1, 3},
  {1, 13},
  {2, 2},
  {1, 14},
  {1, 15},
  {1, 3},
  {1, 28},
  {1, 34},
  {1, 4},
  {1, 41},
  {1, 42},
  {5, 1},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 11},
  {6, 0},                                                 /* End of row  49 */
  {7, 0},
  {1, 11},
  {1, 179},
  {1, 18},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 26},
  {1, 33},
  {2, 4},
  {1, 43},
  {4, 1},
  {1, 46},
  {1, 38},
  {1, 3},
  {1, 10},
  {2, 2},
  {1, 14},
  {1, 15},
  {3, 3},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 23},
  {1, 3},
  {1, 104},
  {2, 3},
  {1, 13},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 21},
  {1, 152},
  {1, 3},
  {1, 15},
  {1, 14},
  {2, 2},
  {1, 13},
  {2, 3},
  {1, 30},
  {2, 4},
  {1, 44},
  {4, 1},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 11},
  {7, 0},                                                 /* End of row  50 */
  {8, 0},
  {1, 163},
  {1, 64},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 26},
  {1, 33},
  {2, 4},
  {1, 43},
  {5, 1},
  {1, 37},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 13},
  {3, 3},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 23},
  {3, 3},
  {1, 15},
  {1, 14},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 25},
  {1, 34},
  {1, 28},
  {1, 3},
  {1, 13},
  {2, 2},
  {1, 14},
  {1, 15},
  {1, 3},
  {1, 28},
  {1, 34},
  {1, 4},
  {1, 41},
  {1, 42},
  {2, 1},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 11},
  {8, 0},                                                 /* End of row  51 */
  {8, 0},
  {1, 22},
  {1, 24},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 26},
  {1, 33},
  {2, 4},
  {1, 43},
  {5, 1},
  {1, 46},
  {1, 38},
  {1, 3},
  {1, 10},
  {2, 2},
  {1, 14},
  {1, 15},
  {2, 3},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 23},
  {3, 3},
  {1, 13},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 21},
  {1, 31},
  {1, 4},
  {1, 30},
  {1, 3},
  {1, 15},
  {1, 14},
  {2, 2},
  {1, 13},
  {2, 3},
  {1, 30},
  {2, 4},
  {1, 44},
  {1, 1},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 11},
  {9, 0},                                                 /* End of row  52 */
  {8, 0},
  {1, 22},
  {1, 24},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 26},
  {1, 33},
  {2, 4},
  {1, 43},
  {6, 1},
  {1, 37},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 13},
  {2, 3},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 23},
  {2, 3},
  {1, 15},
  {1, 14},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 25},
  {2, 4},
  {1, 34},
  {1, 28},
  {1, 3},
  {1, 13},
  {2, 2},
  {1, 14},
  {1, 15},
  {1, 3},
  {1, 28},
  {1, 34},
  {1, 4},
  {1, 41},
  {1, 238},
  {1, 27},
  {1, 29},
  {1, 11},
  {10, 0},                                                /* End of row  53 */
  {8, 0},
  {1, 22},
  {1, 24},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 26},
  {1, 33},
  {2, 4},
  {1, 43},
  {6, 1},
  {1, 46},
  {1, 38},
  {1, 3},
  {1, 10},
  {2, 2},
  {1, 14},
  {1, 15},
  {1, 3},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 23},
  {2, 3},
  {1, 13},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 21},
  {1, 31},
  {2, 4},
  {1, 40},
  {1, 81},
  {1, 3},
  {1, 15},
  {1, 14},
  {2, 2},
  {1, 13},
  {2, 3},
  {1, 30},
  {2, 4},
  {1, 236},
  {1, 246},
  {1, 11},
  {11, 0},                                                /* End of row  54 */
  {8, 0},
  {1, 22},
  {1, 24},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 26},
  {1, 33},
  {2, 4},
  {1, 43},
  {7, 1},
  {1, 37},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 13},
  {1, 3},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 23},
  {1, 3},
  {1, 15},
  {1, 14},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 25},
  {3, 4},
  {1, 45},
  {1, 76},
  {1, 73},
  {1, 3},
  {1, 13},
  {2, 2},
  {1, 14},
  {1, 15},
  {1, 3},
  {1, 28},
  {1, 34},
  {1, 90},
  {1, 88},
  {1, 221},
  {12, 0},                                                /* End of row  55 */
  {8, 0},
  {1, 22},
  {1, 24},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 26},
  {1, 33},
  {2, 4},
  {1, 43},
  {7, 1},
  {1, 46},
  {1, 38},
  {1, 3},
  {1, 10},
  {2, 2},
  {1, 14},
  {1, 15},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 23},
  {1, 3},
  {1, 13},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 21},
  {1, 31},
  {2, 4},
  {1, 40},
  {1, 12},
  {1, 1},
  {1, 86},
  {1, 3},
  {1, 15},
  {1, 14},
  {2, 2},
  {1, 13},
  {2, 3},
  {1, 159},
  {1, 88},
  {1, 7},
  {1, 67},
  {1, 57},
  {11, 0},                                                /* End of row  56 */
  {8, 0},
  {1, 22},
  {1, 24},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 26},
  {1, 33},
  {2, 4},
  {1, 43},
  {8, 1},
  {1, 37},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 13},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 23},
  {1, 15},
  {1, 14},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 25},
  {3, 4},
  {1, 45},
  {2, 1},
  {1, 76},
  {1, 73},
  {1, 3},
  {1, 13},
  {2, 2},
  {1, 14},
  {1, 15},
  {1, 3},
  {1, 103},
  {1, 58},
  {2, 7},
  {1, 62},
  {11, 0},                                                /* End of row  57 */
  {8, 0},
  {1, 22},
  {1, 24},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 26},
  {1, 33},
  {2, 4},
  {1, 43},
  {8, 1},
  {1, 46},
  {1, 38},
  {1, 3},
  {1, 10},
  {2, 2},
  {1, 14},
  {1, 123},
  {1, 5},
  {2, 2},
  {1, 23},
  {1, 13},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 21},
  {1, 31},
  {2, 4},
  {1, 40},
  {1, 12},
  {3, 1},
  {1, 86},
  {1, 3},
  {1, 15},
  {1, 14},
  {2, 2},
  {1, 13},
  {2, 3},
  {1, 55},
  {2, 7},
  {1, 67},
  {1, 57},
  {10, 0},                                                /* End of row  58 */
  {8, 0},
  {1, 22},
  {1, 24},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 71},
  {1, 173},
  {2, 4},
  {1, 43},
  {9, 1},
  {1, 37},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 193},
  {1, 5},
  {2, 2},
  {1, 194},
  {1, 14},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 25},
  {3, 4},
  {1, 45},
  {4, 1},
  {1, 76},
  {1, 73},
  {1, 3},
  {1, 13},
  {2, 2},
  {1, 14},
  {1, 15},
  {1, 3},
  {1, 59},
  {1, 58},
  {2, 7},
  {1, 62},
  {10, 0},                                                /* End of row  59 */
  {8, 0},
  {1, 22},
  {1, 24},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 54},
  {1, 160},
  {1, 83},
  {1, 4},
  {1, 98},
  {1, 16},
  {8, 1},
  {1, 46},
  {1, 38},
  {1, 3},
  {1, 10},
  {10, 2},
  {1, 10},
  {1, 3},
  {1, 21},
  {1, 31},
  {2, 4},
  {1, 40},
  {1, 12},
  {5, 1},
  {1, 86},
  {1, 3},
  {1, 15},
  {1, 14},
  {2, 2},
  {1, 13},
  {2, 3},
  {1, 55},
  {2, 7},
  {1, 67},
  {1, 57},
  {9, 0},                                                 /* End of row  60 */
  {8, 0},
  {1, 22},
  {1, 24},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 54},
  {1, 51},
  {1, 87},
  {1, 83},
  {1, 207},
  {1, 17},
  {1, 16},
  {8, 1},
  {1, 37},
  {1, 3},
  {1, 9},
  {1, 8},
  {8, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 25},
  {3, 4},
  {1, 45},
  {6, 1},
  {1, 235},
  {1, 203},
  {1, 3},
  {1, 13},
  {2, 2},
  {1, 14},
  {1, 15},
  {1, 3},
  {1, 59},
  {1, 58},
  {2, 7},
  {1, 62},
  {9, 0},                                                 /* End of row  61 */
  {8, 0},
  {1, 22},
  {1, 24},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 54},
  {1, 51},
  {1, 7},
  {1, 87},
  {1, 234},
  {1, 12},
  {1, 17},
  {1, 16},
  {7, 1},
  {1, 46},
  {1, 38},
  {1, 3},
  {1, 10},
  {8, 2},
  {1, 10},
  {1, 3},
  {1, 21},
  {1, 31},
  {2, 4},
  {1, 40},
  {1, 12},
  {5, 1},
  {1, 32},
  {1, 27},
  {1, 155},
  {1, 3},
  {1, 15},
  {1, 14},
  {2, 2},
  {1, 13},
  {2, 3},
  {1, 55},
  {2, 7},
  {1, 67},
  {1, 57},
  {8, 0},                                                 /* End of row  62 */
  {8, 0},
  {1, 22},
  {1, 24},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 54},
  {1, 51},
  {2, 7},
  {1, 220},
  {1, 19},
  {1, 12},
  {1, 17},
  {1, 16},
  {7, 1},
  {1, 37},
  {1, 3},
  {1, 9},
  {1, 8},
  {6, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 25},
  {3, 4},
  {1, 45},
  {5, 1},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 213},
  {1, 140},
  {1, 3},
  {1, 13},
  {2, 2},
  {1, 14},
  {1, 15},
  {1, 3},
  {1, 59},
  {1, 58},
  {2, 7},
  {1, 62},
  {8, 0},                                                 /* End of row  63 */
  {8, 0},
  {1, 22},
  {1, 24},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 54},
  {1, 51},
  {2, 7},
  {1, 39},
  {1, 11},
  {1, 19},
  {1, 12},
  {1, 17},
  {1, 16},
  {6, 1},
  {1, 46},
  {1, 38},
  {1, 3},
  {1, 10},
  {6, 2},
  {1, 10},
  {1, 3},
  {1, 21},
  {1, 31},
  {2, 4},
  {1, 40},
  {1, 12},
  {4, 1},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 11},
  {1, 0},
  {1, 80},
  {1, 3},
  {1, 15},
  {1, 14},
  {2, 2},
  {1, 13},
  {2, 3},
  {1, 55},
  {2, 7},
  {1, 67},
  {1, 57},
  {7, 0},                                                 /* End of row  64 */
  {8, 0},
  {1, 22},
  {1, 24},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 54},
  {1, 51},
  {2, 7},
  {1, 39},
  {1, 0},
  {1, 11},
  {1, 19},
  {1, 12},
  {1, 17},
  {1, 16},
  {6, 1},
  {1, 37},
  {1, 3},
  {1, 9},
  {1, 8},
  {4, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 25},
  {3, 4},
  {1, 45},
  {4, 1},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 11},
  {2, 0},
  {1, 78},
  {1, 77},
  {1, 3},
  {1, 13},
  {2, 2},
  {1, 14},
  {1, 15},
  {1, 3},
  {1, 59},
  {1, 58},
  {2, 7},
  {1, 62},
  {7, 0},                                                 /* End of row  65 */
  {8, 0},
  {1, 22},
  {1, 24},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 54},
  {1, 51},
  {2, 7},
  {1, 39},
  {2, 0},
  {1, 11},
  {1, 19},
  {1, 12},
  {1, 17},
  {1, 16},
  {5, 1},
  {1, 46},
  {1, 38},
  {1, 3},
  {1, 10},
  {4, 2},
  {1, 10},
  {1, 3},
  {1, 21},
  {1, 31},
  {2, 4},
  {1, 40},
  {1, 12},
  {3, 1},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 11},
  {4, 0},
  {1, 80},
  {1, 3},
  {1, 15},
  {1, 14},
  {2, 2},
  {1, 13},
  {2, 3},
  {1, 151},
  {2, 7},
  {1, 133},
  {7, 0},                                                 /* End of row  66 */
  {8, 0},
  {1, 22},
  {1, 24},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 54},
  {1, 51},
  {2, 7},
  {1, 39},
  {3, 0},
  {1, 11},
  {1, 19},
  {1, 12},
  {1, 17},
  {1, 16},
  {5, 1},
  {1, 37},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 25},
  {3, 4},
  {1, 45},
  {3, 1},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 11},
  {5, 0},
  {1, 78},
  {1, 77},
  {1, 3},
  {1, 13},
  {2, 2},
  {1, 100},
  {2, 3},
  {1, 212},
  {2, 7},
  {1, 61},
  {1, 115},
  {6, 0},                                                 /* End of row  67 */
  {8, 0},
  {1, 22},
  {1, 24},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 54},
  {1, 51},
  {2, 7},
  {1, 39},
  {4, 0},
  {1, 11},
  {1, 19},
  {1, 12},
  {1, 17},
  {1, 16},
  {4, 1},
  {1, 46},
  {1, 38},
  {1, 3},
  {1, 101},
  {2, 8},
  {1, 101},
  {1, 3},
  {1, 21},
  {1, 31},
  {2, 4},
  {1, 40},
  {1, 12},
  {2, 1},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 11},
  {7, 0},
  {1, 80},
  {1, 3},
  {1, 15},
  {2, 8},
  {1, 122},
  {1, 3},
  {1, 59},
  {1, 217},
  {3, 7},
  {1, 89},
  {6, 0},                                                 /* End of row  68 */
  {8, 0},
  {1, 22},
  {1, 24},
  {1, 6},
  {1, 5},
  {2, 2},
  {1, 5},
  {1, 6},
  {1, 54},
  {1, 51},
  {2, 7},
  {1, 39},
  {5, 0},
  {1, 11},
  {1, 19},
  {1, 12},
  {1, 17},
  {1, 16},
  {4, 1},
  {1, 37},
  {2, 3},
  {2, 9},
  {2, 3},
  {1, 25},
  {3, 4},
  {1, 45},
  {2, 1},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 11},
  {8, 0},
  {1, 78},
  {1, 77},
  {1, 3},
  {2, 9},
  {1, 3},
  {1, 38},
  {1, 210},
  {3, 7},
  {1, 85},
  {1, 147},
  {6, 0},                                                 /* End of row  69 */
  {8, 0},
  {1, 22},
  {1, 141},
  {1, 24},
  {1, 113},
  {1, 190},
  {1, 191},
  {1, 192},
  {1, 199},
  {1, 129},
  {1, 51},
  {2, 7},
  {1, 39},
  {6, 0},
  {1, 11},
  {1, 19},
  {1, 12},
  {1, 17},
  {1, 16},
  {3, 1},
  {1, 82},
  {1, 102},
  {4, 3},
  {1, 131},
  {1, 108},
  {2, 4},
  {1, 40},
  {1, 12},
  {1, 1},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 11},
  {10, 0},
  {1, 142},
  {1, 143},
  {2, 3},
  {1, 130},
  {1, 55},
  {4, 7},
  {1, 69},
  {7, 0},                                                 /* End of row  70 */
  {9, 0},
  {1, 22},
  {1, 231},
  {1, 112},
  {1, 214},
  {1, 157},
  {1, 158},
  {2, 51},
  {3, 7},
  {1, 39},
  {7, 0},
  {1, 11},
  {1, 19},
  {1, 12},
  {1, 17},
  {1, 16},
  {3, 1},
  {1, 82},
  {1, 37},
  {1, 71},
  {1, 128},
  {1, 25},
  {1, 108},
  {2, 4},
  {1, 111},
  {1, 254},
  {1, 1},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 11},
  {12, 0},
  {1, 22},
  {1, 144},
  {1, 209},
  {1, 51},
  {4, 7},
  {1, 85},
  {1, 56},
  {7, 0},                                                 /* End of row  71 */
  {12, 0},
  {1, 39},
  {7, 7},
  {1, 39},
  {8, 0},
  {1, 11},
  {1, 19},
  {1, 12},
  {1, 17},
  {1, 16},
  {4, 1},
  {1, 181},
  {1, 245},
  {1, 171},
  {2, 66},
  {1, 98},
  {1, 116},
  {1, 1},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 11},
  {15, 0},
  {1, 56},
  {1, 61},
  {3, 7},
  {1, 85},
  {1, 148},
  {8, 0},                                                 /* End of row  72 */
  {12, 0},
  {1, 39},
  {7, 7},
  {1, 39},
  {9, 0},
  {1, 11},
  {1, 19},
  {1, 12},
  {1, 17},
  {1, 16},
  {5, 1},
  {3, 12},
  {2, 1},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 11},
  {17, 0},
  {1, 149},
  {2, 39},
  {1, 150},
  {1, 56},
  {9, 0},                                                 /* End of row  73 */
  {12, 0},
  {1, 89},
  {7, 39},
  {1, 89},
  {10, 0},
  {1, 11},
  {1, 19},
  {1, 12},
  {1, 17},
  {1, 16},
  {8, 1},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 11},
  {32, 0},                                                /* End of row  74 */
  {32, 0},
  {1, 11},
  {1, 19},
  {1, 12},
  {1, 17},
  {1, 16},
  {6, 1},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 11},
  {33, 0},                                                /* End of row  75 */
  {33, 0},
  {1, 11},
  {1, 19},
  {1, 12},
  {1, 17},
  {1, 16},
  {4, 1},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 11},
  {34, 0},                                                /* End of row  76 */
  {34, 0},
  {1, 11},
  {1, 19},
  {1, 12},
  {1, 17},
  {1, 16},
  {2, 1},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 11},
  {35, 0},                                                /* End of row  77 */
  {35, 0},
  {1, 11},
  {1, 19},
  {1, 12},
  {1, 17},
  {1, 16},
  {1, 32},
  {1, 27},
  {1, 29},
  {1, 11},
  {36, 0},                                                /* End of row  78 */
  {36, 0},
  {1, 11},
  {1, 19},
  {1, 12},
  {1, 178},
  {1, 27},
  {1, 29},
  {1, 11},
  {37, 0},                                                /* End of row  79 */
  {37, 0},
  {1, 11},
  {1, 79},
  {1, 177},
  {1, 96},
  {1, 11},
  {38, 0},                                                /* End of row  80 */
};
#endif /* CONFIG_VIDEO_FB_SPLASHSCREEN_BPP32 */

#if defined(CONFIG_VIDEO_FB_SPLASHSCREEN_BPP24) || \
    defined(CONFIG_VIDEO_FB_SPLASHSCREEN_BPP16)
static const struct splscr_bitmap_s bitmap[] =
{
  {37, 0},
  {1, 31},
  {1, 32},
  {1, 187},
  {3, 1},
  {37, 0},                                                /* End of row   1 */
  {36, 0},
  {1, 31},
  {1, 32},
  {1, 45},
  {1, 171},
  {1, 180},
  {1, 11},
  {2, 1},
  {36, 0},                                                /* End of row   2 */
  {35, 0},
  {1, 31},
  {1, 32},
  {1, 45},
  {1, 43},
  {1, 44},
  {1, 15},
  {1, 16},
  {1, 11},
  {2, 1},
  {35, 0},                                                /* End of row   3 */
  {34, 0},
  {1, 31},
  {1, 32},
  {1, 45},
  {1, 43},
  {1, 44},
  {2, 1},
  {1, 15},
  {1, 16},
  {1, 11},
  {2, 1},
  {34, 0},                                                /* End of row   4 */
  {33, 0},
  {1, 31},
  {1, 32},
  {1, 45},
  {1, 43},
  {1, 44},
  {4, 1},
  {1, 15},
  {1, 16},
  {1, 11},
  {2, 1},
  {33, 0},                                                /* End of row   5 */
  {32, 0},
  {1, 31},
  {1, 32},
  {1, 45},
  {1, 43},
  {1, 44},
  {6, 1},
  {1, 15},
  {1, 16},
  {1, 11},
  {2, 1},
  {32, 0},                                                /* End of row   6 */
  {31, 0},
  {1, 31},
  {1, 32},
  {1, 45},
  {1, 43},
  {1, 44},
  {8, 1},
  {1, 15},
  {1, 16},
  {1, 11},
  {2, 1},
  {31, 0},                                                /* End of row   7 */
  {30, 0},
  {1, 31},
  {1, 32},
  {1, 45},
  {1, 43},
  {1, 44},
  {10, 1},
  {1, 15},
  {1, 16},
  {1, 11},
  {2, 1},
  {30, 0},                                                /* End of row   8 */
  {29, 0},
  {1, 31},
  {1, 32},
  {1, 45},
  {1, 43},
  {1, 44},
  {12, 1},
  {1, 15},
  {1, 16},
  {1, 11},
  {2, 1},
  {13, 0},
  {3, 3},
  {13, 0},                                                /* End of row   9 */
  {28, 0},
  {1, 31},
  {1, 32},
  {1, 45},
  {1, 43},
  {1, 44},
  {4, 1},
  {1, 132},
  {1, 18},
  {1, 128},
  {7, 1},
  {1, 15},
  {1, 16},
  {1, 11},
  {2, 1},
  {11, 0},
  {6, 3},
  {11, 0},                                                /* End of row  10 */
  {11, 0},
  {5, 3},
  {11, 0},
  {1, 31},
  {1, 32},
  {1, 45},
  {1, 43},
  {1, 44},
  {4, 1},
  {1, 165},
  {1, 57},
  {2, 17},
  {1, 34},
  {1, 173},
  {6, 1},
  {1, 15},
  {1, 16},
  {1, 11},
  {2, 1},
  {9, 0},
  {8, 3},
  {10, 0},                                                /* End of row  11 */
  {10, 0},
  {6, 3},
  {1, 145},
  {2, 5},
  {7, 0},
  {1, 31},
  {1, 32},
  {1, 45},
  {1, 43},
  {1, 44},
  {4, 1},
  {1, 62},
  {1, 77},
  {4, 3},
  {1, 149},
  {1, 123},
  {1, 194},
  {1, 37},
  {4, 1},
  {1, 15},
  {1, 16},
  {1, 11},
  {2, 1},
  {8, 0},
  {3, 3},
  {2, 55},
  {3, 3},
  {1, 159},
  {9, 0},                                                 /* End of row  12 */
  {9, 0},
  {7, 3},
  {1, 48},
  {1, 50},
  {3, 5},
  {4, 0},
  {1, 31},
  {1, 32},
  {1, 45},
  {1, 43},
  {1, 44},
  {5, 1},
  {1, 34},
  {1, 3},
  {1, 55},
  {1, 141},
  {1, 142},
  {2, 3},
  {1, 21},
  {1, 4},
  {1, 74},
  {1, 189},
  {4, 1},
  {1, 15},
  {1, 16},
  {1, 11},
  {2, 1},
  {6, 0},
  {3, 3},
  {1, 64},
  {2, 6},
  {1, 64},
  {1, 3},
  {1, 33},
  {1, 105},
  {1, 5},
  {8, 0},                                                 /* End of row  13 */
  {9, 0},
  {2, 3},
  {1, 55},
  {1, 12},
  {1, 88},
  {1, 55},
  {2, 3},
  {1, 49},
  {3, 5},
  {3, 0},
  {1, 31},
  {1, 32},
  {1, 45},
  {1, 43},
  {1, 44},
  {5, 1},
  {1, 60},
  {1, 146},
  {1, 3},
  {1, 20},
  {2, 2},
  {1, 64},
  {1, 3},
  {1, 19},
  {1, 27},
  {1, 4},
  {1, 74},
  {1, 37},
  {4, 1},
  {1, 15},
  {1, 16},
  {1, 11},
  {2, 1},
  {5, 0},
  {2, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 87},
  {2, 3},
  {1, 155},
  {2, 5},
  {7, 0},                                                 /* End of row  14 */
  {8, 0},
  {3, 3},
  {1, 12},
  {2, 2},
  {1, 89},
  {2, 3},
  {1, 48},
  {1, 50},
  {3, 5},
  {1, 0},
  {1, 31},
  {1, 32},
  {1, 45},
  {1, 43},
  {1, 44},
  {6, 1},
  {1, 18},
  {1, 17},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 21},
  {2, 4},
  {1, 39},
  {5, 1},
  {1, 15},
  {1, 16},
  {1, 11},
  {2, 1},
  {3, 0},
  {3, 3},
  {1, 10},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 19},
  {1, 106},
  {2, 5},
  {7, 0},                                                 /* End of row  15 */
  {8, 0},
  {2, 3},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 13},
  {1, 14},
  {2, 3},
  {1, 49},
  {3, 5},
  {1, 31},
  {1, 32},
  {1, 45},
  {1, 43},
  {1, 44},
  {7, 1},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 19},
  {1, 27},
  {1, 4},
  {1, 36},
  {1, 37},
  {5, 1},
  {1, 15},
  {1, 16},
  {1, 11},
  {2, 1},
  {2, 0},
  {2, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 58},
  {3, 5},
  {7, 0},                                                 /* End of row  16 */
  {8, 0},
  {2, 3},
  {1, 7},
  {1, 6},
  {3, 2},
  {1, 12},
  {2, 3},
  {1, 48},
  {1, 50},
  {1, 5},
  {1, 161},
  {1, 114},
  {1, 45},
  {1, 43},
  {1, 44},
  {8, 1},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {3, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 21},
  {2, 4},
  {1, 39},
  {6, 1},
  {1, 15},
  {1, 16},
  {1, 11},
  {2, 1},
  {3, 3},
  {1, 10},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 19},
  {1, 59},
  {3, 5},
  {7, 0},                                                 /* End of row  17 */
  {8, 0},
  {2, 3},
  {1, 7},
  {1, 6},
  {3, 2},
  {1, 13},
  {1, 14},
  {2, 3},
  {1, 49},
  {1, 66},
  {1, 63},
  {1, 192},
  {1, 43},
  {1, 44},
  {9, 1},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {4, 2},
  {1, 10},
  {1, 3},
  {1, 19},
  {1, 27},
  {1, 4},
  {1, 36},
  {1, 37},
  {6, 1},
  {1, 15},
  {1, 16},
  {1, 11},
  {1, 1},
  {1, 148},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 150},
  {4, 5},
  {7, 0},                                                 /* End of row  18 */
  {8, 0},
  {2, 3},
  {1, 7},
  {1, 6},
  {4, 2},
  {1, 12},
  {2, 3},
  {1, 78},
  {1, 122},
  {1, 4},
  {1, 195},
  {1, 120},
  {10, 1},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {4, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 21},
  {2, 4},
  {1, 39},
  {7, 1},
  {1, 15},
  {1, 16},
  {1, 168},
  {1, 33},
  {1, 3},
  {1, 10},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 19},
  {1, 59},
  {3, 5},
  {8, 0},                                                 /* End of row  19 */
  {8, 0},
  {2, 3},
  {1, 7},
  {1, 6},
  {4, 2},
  {1, 13},
  {1, 14},
  {2, 3},
  {1, 26},
  {2, 4},
  {1, 40},
  {10, 1},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {5, 2},
  {1, 10},
  {1, 3},
  {1, 19},
  {1, 27},
  {1, 4},
  {1, 36},
  {1, 37},
  {7, 1},
  {1, 15},
  {1, 152},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 58},
  {4, 5},
  {8, 0},                                                 /* End of row  20 */
  {8, 0},
  {2, 3},
  {1, 7},
  {1, 6},
  {5, 2},
  {1, 12},
  {2, 3},
  {1, 25},
  {1, 30},
  {1, 4},
  {1, 35},
  {1, 11},
  {9, 1},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {5, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 21},
  {2, 4},
  {1, 39},
  {7, 1},
  {1, 41},
  {1, 33},
  {1, 3},
  {1, 10},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 19},
  {1, 59},
  {3, 5},
  {9, 0},                                                 /* End of row  21 */
  {8, 0},
  {2, 3},
  {1, 7},
  {1, 6},
  {5, 2},
  {1, 13},
  {1, 14},
  {2, 3},
  {1, 26},
  {2, 4},
  {1, 40},
  {9, 1},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 69},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 19},
  {1, 27},
  {1, 4},
  {1, 36},
  {1, 37},
  {6, 1},
  {1, 34},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 58},
  {4, 5},
  {9, 0},                                                 /* End of row  22 */
  {8, 0},
  {2, 3},
  {1, 7},
  {1, 6},
  {3, 2},
  {1, 85},
  {2, 2},
  {1, 12},
  {2, 3},
  {1, 25},
  {1, 30},
  {1, 4},
  {1, 35},
  {1, 11},
  {8, 1},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 140},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 21},
  {2, 4},
  {1, 39},
  {5, 1},
  {1, 41},
  {1, 33},
  {1, 3},
  {1, 10},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 19},
  {1, 59},
  {3, 5},
  {10, 0},                                                /* End of row  23 */
  {8, 0},
  {2, 3},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 90},
  {2, 2},
  {1, 13},
  {1, 14},
  {2, 3},
  {1, 26},
  {2, 4},
  {1, 40},
  {8, 1},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 20},
  {1, 10},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 19},
  {1, 27},
  {1, 4},
  {1, 36},
  {1, 37},
  {4, 1},
  {1, 34},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 58},
  {4, 5},
  {10, 0},                                                /* End of row  24 */
  {8, 0},
  {2, 3},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 143},
  {1, 8},
  {2, 2},
  {1, 12},
  {2, 3},
  {1, 25},
  {1, 30},
  {1, 4},
  {1, 35},
  {1, 11},
  {7, 1},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 20},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 21},
  {2, 4},
  {1, 39},
  {3, 1},
  {1, 41},
  {1, 33},
  {1, 3},
  {1, 10},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 19},
  {1, 113},
  {3, 5},
  {11, 0},                                                /* End of row  25 */
  {8, 0},
  {2, 3},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 10},
  {2, 2},
  {1, 13},
  {1, 14},
  {2, 3},
  {1, 26},
  {2, 4},
  {1, 40},
  {7, 1},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 20},
  {1, 3},
  {1, 10},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 19},
  {1, 27},
  {1, 4},
  {1, 36},
  {1, 37},
  {2, 1},
  {1, 34},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 21},
  {1, 68},
  {1, 67},
  {2, 5},
  {11, 0},                                                /* End of row  26 */
  {8, 0},
  {2, 3},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 12},
  {2, 3},
  {1, 25},
  {1, 30},
  {1, 4},
  {1, 35},
  {1, 11},
  {6, 1},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 20},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 21},
  {2, 4},
  {1, 39},
  {1, 1},
  {1, 41},
  {1, 33},
  {1, 3},
  {1, 10},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 19},
  {1, 27},
  {1, 4},
  {1, 68},
  {1, 166},
  {12, 0},                                                /* End of row  27 */
  {8, 0},
  {2, 3},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 3},
  {1, 10},
  {2, 2},
  {1, 13},
  {1, 14},
  {2, 3},
  {1, 26},
  {2, 4},
  {1, 40},
  {6, 1},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 20},
  {2, 3},
  {1, 10},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 19},
  {1, 27},
  {1, 4},
  {1, 36},
  {1, 133},
  {1, 34},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 21},
  {2, 4},
  {1, 84},
  {1, 190},
  {1, 1},
  {11, 0},                                                /* End of row  28 */
  {8, 0},
  {2, 3},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 12},
  {2, 3},
  {1, 25},
  {1, 30},
  {1, 4},
  {1, 35},
  {1, 11},
  {5, 1},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 20},
  {2, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 21},
  {2, 4},
  {1, 118},
  {1, 33},
  {1, 3},
  {1, 10},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 19},
  {1, 27},
  {2, 4},
  {1, 134},
  {1, 16},
  {1, 11},
  {1, 1},
  {10, 0},                                                /* End of row  29 */
  {8, 0},
  {1, 101},
  {1, 3},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {2, 3},
  {1, 10},
  {2, 2},
  {1, 13},
  {1, 14},
  {2, 3},
  {1, 26},
  {2, 4},
  {1, 40},
  {5, 1},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 20},
  {3, 3},
  {1, 10},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 19},
  {1, 27},
  {1, 4},
  {1, 21},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 21},
  {2, 4},
  {1, 36},
  {1, 37},
  {1, 15},
  {1, 16},
  {1, 11},
  {1, 1},
  {9, 0},                                                 /* End of row  30 */
  {7, 0},
  {1, 31},
  {1, 164},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {2, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 12},
  {2, 3},
  {1, 25},
  {1, 30},
  {1, 4},
  {1, 35},
  {1, 11},
  {4, 1},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 20},
  {1, 3},
  {1, 79},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 21},
  {1, 27},
  {1, 19},
  {1, 3},
  {1, 10},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 19},
  {1, 27},
  {2, 4},
  {1, 39},
  {2, 1},
  {1, 15},
  {1, 16},
  {1, 11},
  {1, 1},
  {8, 0},                                                 /* End of row  31 */
  {6, 0},
  {1, 31},
  {1, 32},
  {1, 179},
  {1, 56},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {3, 3},
  {1, 10},
  {2, 2},
  {1, 13},
  {1, 14},
  {2, 3},
  {1, 26},
  {2, 4},
  {1, 40},
  {4, 1},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 20},
  {1, 3},
  {1, 81},
  {1, 25},
  {1, 3},
  {1, 10},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 19},
  {1, 100},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 21},
  {2, 4},
  {1, 36},
  {1, 37},
  {3, 1},
  {1, 15},
  {1, 16},
  {1, 11},
  {1, 1},
  {7, 0},                                                 /* End of row  32 */
  {5, 0},
  {1, 31},
  {1, 32},
  {1, 51},
  {1, 116},
  {1, 94},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 22},
  {1, 102},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 12},
  {2, 3},
  {1, 25},
  {1, 30},
  {1, 4},
  {1, 35},
  {1, 11},
  {3, 1},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 20},
  {1, 3},
  {1, 42},
  {1, 26},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {3, 3},
  {1, 10},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 19},
  {1, 27},
  {2, 4},
  {1, 39},
  {5, 1},
  {1, 15},
  {1, 16},
  {1, 11},
  {1, 1},
  {6, 0},                                                 /* End of row  33 */
  {4, 0},
  {1, 31},
  {1, 32},
  {1, 51},
  {1, 54},
  {1, 124},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 22},
  {1, 167},
  {1, 19},
  {1, 3},
  {1, 10},
  {2, 2},
  {1, 13},
  {1, 14},
  {2, 3},
  {1, 26},
  {2, 4},
  {1, 40},
  {3, 1},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 20},
  {1, 3},
  {1, 42},
  {1, 30},
  {1, 25},
  {1, 3},
  {1, 10},
  {3, 2},
  {1, 10},
  {2, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 21},
  {2, 4},
  {1, 36},
  {1, 37},
  {6, 1},
  {1, 15},
  {1, 16},
  {1, 11},
  {1, 1},
  {5, 0},                                                 /* End of row  34 */
  {3, 0},
  {1, 31},
  {1, 32},
  {1, 51},
  {1, 54},
  {1, 52},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 22},
  {1, 29},
  {1, 21},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 12},
  {2, 3},
  {1, 25},
  {1, 30},
  {1, 4},
  {1, 35},
  {1, 11},
  {2, 1},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 20},
  {1, 3},
  {1, 42},
  {1, 4},
  {1, 26},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 10},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 19},
  {1, 27},
  {2, 4},
  {1, 39},
  {8, 1},
  {1, 15},
  {1, 16},
  {1, 11},
  {1, 1},
  {4, 0},                                                 /* End of row  35 */
  {2, 0},
  {1, 31},
  {1, 32},
  {1, 51},
  {1, 54},
  {1, 52},
  {1, 1},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 22},
  {1, 29},
  {1, 27},
  {1, 19},
  {1, 3},
  {1, 10},
  {2, 2},
  {1, 13},
  {1, 14},
  {2, 3},
  {1, 26},
  {2, 4},
  {1, 40},
  {2, 1},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 20},
  {1, 3},
  {1, 42},
  {1, 4},
  {1, 30},
  {1, 25},
  {1, 3},
  {1, 10},
  {3, 2},
  {1, 10},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 21},
  {2, 4},
  {1, 36},
  {1, 37},
  {9, 1},
  {1, 15},
  {1, 16},
  {1, 11},
  {1, 1},
  {3, 0},                                                 /* End of row  36 */
  {1, 0},
  {1, 31},
  {1, 32},
  {1, 51},
  {1, 54},
  {1, 52},
  {2, 1},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 22},
  {1, 29},
  {1, 4},
  {1, 21},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 12},
  {2, 3},
  {1, 25},
  {1, 30},
  {1, 4},
  {1, 35},
  {1, 11},
  {1, 1},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 20},
  {1, 3},
  {1, 42},
  {2, 4},
  {1, 26},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 91},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 19},
  {1, 27},
  {2, 4},
  {1, 39},
  {11, 1},
  {1, 15},
  {1, 16},
  {1, 11},
  {1, 1},
  {2, 0},                                                 /* End of row  37 */
  {1, 31},
  {1, 32},
  {1, 51},
  {1, 54},
  {1, 52},
  {3, 1},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 22},
  {1, 29},
  {1, 4},
  {1, 27},
  {1, 19},
  {1, 3},
  {1, 10},
  {2, 2},
  {1, 13},
  {1, 14},
  {2, 3},
  {1, 26},
  {2, 4},
  {1, 40},
  {1, 1},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 20},
  {1, 3},
  {1, 42},
  {2, 4},
  {1, 72},
  {1, 80},
  {1, 3},
  {1, 10},
  {6, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 21},
  {2, 4},
  {1, 36},
  {1, 37},
  {12, 1},
  {1, 15},
  {1, 16},
  {1, 11},
  {1, 1},
  {1, 0},                                                 /* End of row  38 */
  {1, 32},
  {1, 51},
  {1, 54},
  {1, 52},
  {4, 1},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 22},
  {1, 29},
  {2, 4},
  {1, 21},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 12},
  {2, 3},
  {1, 25},
  {1, 30},
  {1, 4},
  {1, 35},
  {1, 11},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 20},
  {1, 3},
  {1, 42},
  {2, 4},
  {1, 53},
  {1, 61},
  {1, 3},
  {1, 9},
  {1, 8},
  {5, 2},
  {1, 10},
  {1, 3},
  {1, 19},
  {1, 27},
  {2, 4},
  {1, 39},
  {14, 1},
  {1, 15},
  {1, 16},
  {1, 11},
  {1, 1},                                                 /* End of row  39 */
  {1, 188},
  {1, 117},
  {1, 52},
  {5, 1},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 22},
  {1, 29},
  {2, 4},
  {1, 169},
  {1, 33},
  {1, 3},
  {1, 10},
  {2, 2},
  {1, 13},
  {1, 14},
  {2, 3},
  {1, 26},
  {2, 4},
  {1, 40},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 20},
  {1, 3},
  {1, 42},
  {2, 4},
  {1, 53},
  {1, 83},
  {1, 71},
  {1, 3},
  {1, 10},
  {4, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 21},
  {2, 4},
  {1, 36},
  {1, 37},
  {15, 1},
  {1, 15},
  {1, 16},
  {1, 11},                                                /* End of row  40 */
  {1, 11},
  {1, 191},
  {1, 15},
  {5, 1},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 22},
  {1, 29},
  {2, 4},
  {1, 38},
  {1, 34},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 12},
  {2, 3},
  {1, 25},
  {1, 30},
  {1, 4},
  {1, 35},
  {1, 181},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 20},
  {1, 3},
  {1, 42},
  {2, 4},
  {1, 53},
  {1, 83},
  {1, 71},
  {1, 3},
  {1, 14},
  {4, 2},
  {1, 20},
  {1, 3},
  {1, 19},
  {1, 170},
  {2, 4},
  {1, 39},
  {17, 1},
  {1, 177},
  {1, 172},                                               /* End of row  41 */
  {1, 1},
  {1, 11},
  {1, 16},
  {1, 15},
  {4, 1},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 22},
  {1, 29},
  {2, 4},
  {1, 38},
  {1, 41},
  {1, 33},
  {1, 3},
  {1, 10},
  {2, 2},
  {1, 13},
  {1, 14},
  {2, 3},
  {1, 26},
  {2, 4},
  {1, 183},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 20},
  {1, 3},
  {1, 42},
  {2, 4},
  {1, 53},
  {1, 61},
  {2, 3},
  {1, 12},
  {4, 2},
  {1, 12},
  {2, 3},
  {1, 26},
  {2, 4},
  {1, 39},
  {16, 1},
  {1, 28},
  {1, 24},
  {1, 23},                                                /* End of row  42 */
  {2, 1},
  {1, 11},
  {1, 16},
  {1, 15},
  {3, 1},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 22},
  {1, 29},
  {2, 4},
  {1, 38},
  {1, 1},
  {1, 34},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 12},
  {2, 3},
  {1, 25},
  {1, 30},
  {1, 4},
  {1, 186},
  {1, 56},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 20},
  {1, 3},
  {1, 42},
  {2, 4},
  {1, 72},
  {1, 80},
  {1, 3},
  {1, 14},
  {1, 13},
  {4, 2},
  {1, 13},
  {1, 14},
  {1, 3},
  {1, 25},
  {1, 30},
  {1, 4},
  {1, 36},
  {1, 37},
  {14, 1},
  {1, 28},
  {1, 24},
  {1, 23},
  {1, 1},                                                 /* End of row  43 */
  {1, 0},
  {2, 1},
  {1, 11},
  {1, 16},
  {1, 15},
  {2, 1},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 22},
  {1, 29},
  {2, 4},
  {1, 38},
  {1, 1},
  {1, 41},
  {1, 33},
  {1, 3},
  {1, 10},
  {2, 2},
  {1, 13},
  {1, 14},
  {2, 3},
  {1, 26},
  {1, 4},
  {1, 29},
  {1, 22},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 20},
  {1, 3},
  {1, 42},
  {2, 4},
  {1, 26},
  {2, 3},
  {1, 12},
  {6, 2},
  {1, 12},
  {2, 3},
  {1, 26},
  {2, 4},
  {1, 39},
  {13, 1},
  {1, 28},
  {1, 24},
  {1, 23},
  {1, 1},
  {1, 0},                                                 /* End of row  44 */
  {2, 0},
  {2, 1},
  {1, 11},
  {1, 16},
  {1, 15},
  {1, 1},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 22},
  {1, 29},
  {2, 4},
  {1, 38},
  {2, 1},
  {1, 34},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 12},
  {2, 3},
  {1, 25},
  {1, 30},
  {1, 29},
  {1, 22},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 20},
  {1, 3},
  {1, 42},
  {1, 4},
  {1, 30},
  {1, 25},
  {1, 3},
  {1, 14},
  {1, 13},
  {2, 2},
  {1, 69},
  {1, 75},
  {2, 2},
  {1, 13},
  {1, 14},
  {1, 3},
  {1, 25},
  {1, 30},
  {1, 4},
  {1, 36},
  {1, 37},
  {11, 1},
  {1, 28},
  {1, 24},
  {1, 23},
  {1, 1},
  {2, 0},                                                 /* End of row  45 */
  {3, 0},
  {2, 1},
  {1, 11},
  {1, 16},
  {1, 15},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 22},
  {1, 29},
  {2, 4},
  {1, 38},
  {2, 1},
  {1, 41},
  {1, 33},
  {1, 3},
  {1, 10},
  {2, 2},
  {1, 13},
  {1, 14},
  {2, 3},
  {1, 26},
  {1, 29},
  {1, 22},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 20},
  {1, 3},
  {1, 42},
  {1, 4},
  {1, 26},
  {2, 3},
  {1, 12},
  {3, 2},
  {1, 10},
  {1, 14},
  {1, 13},
  {2, 2},
  {1, 12},
  {2, 3},
  {1, 26},
  {2, 4},
  {1, 39},
  {10, 1},
  {1, 28},
  {1, 24},
  {1, 23},
  {1, 1},
  {3, 0},                                                 /* End of row  46 */
  {4, 0},
  {2, 1},
  {1, 11},
  {1, 16},
  {1, 182},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 22},
  {1, 29},
  {2, 4},
  {1, 38},
  {3, 1},
  {1, 34},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 12},
  {2, 3},
  {1, 25},
  {1, 130},
  {1, 22},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 20},
  {1, 3},
  {1, 42},
  {1, 30},
  {1, 25},
  {1, 3},
  {1, 14},
  {1, 13},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 12},
  {2, 2},
  {1, 13},
  {1, 14},
  {1, 3},
  {1, 25},
  {1, 30},
  {1, 4},
  {1, 36},
  {1, 37},
  {8, 1},
  {1, 28},
  {1, 24},
  {1, 23},
  {1, 1},
  {4, 0},                                                 /* End of row  47 */
  {5, 0},
  {2, 1},
  {1, 11},
  {1, 131},
  {1, 56},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 22},
  {1, 29},
  {2, 4},
  {1, 38},
  {3, 1},
  {1, 41},
  {1, 33},
  {1, 3},
  {1, 10},
  {2, 2},
  {1, 13},
  {1, 14},
  {2, 3},
  {1, 108},
  {1, 22},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 20},
  {1, 3},
  {1, 42},
  {1, 26},
  {2, 3},
  {1, 12},
  {3, 2},
  {1, 10},
  {2, 3},
  {1, 14},
  {1, 13},
  {2, 2},
  {1, 12},
  {2, 3},
  {1, 26},
  {2, 4},
  {1, 39},
  {7, 1},
  {1, 28},
  {1, 24},
  {1, 23},
  {1, 1},
  {5, 0},                                                 /* End of row  48 */
  {6, 0},
  {2, 1},
  {1, 18},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 22},
  {1, 29},
  {2, 4},
  {1, 38},
  {4, 1},
  {1, 34},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 12},
  {2, 3},
  {1, 99},
  {1, 19},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 20},
  {1, 3},
  {1, 81},
  {1, 25},
  {1, 3},
  {1, 14},
  {1, 13},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 70},
  {1, 3},
  {1, 12},
  {2, 2},
  {1, 13},
  {1, 14},
  {1, 3},
  {1, 25},
  {1, 30},
  {1, 4},
  {1, 36},
  {1, 37},
  {5, 1},
  {1, 28},
  {1, 24},
  {1, 23},
  {1, 1},
  {6, 0},                                                 /* End of row  49 */
  {7, 0},
  {1, 1},
  {1, 127},
  {1, 17},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 22},
  {1, 29},
  {2, 4},
  {1, 38},
  {4, 1},
  {1, 41},
  {1, 33},
  {1, 3},
  {1, 10},
  {2, 2},
  {1, 13},
  {1, 14},
  {3, 3},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 20},
  {1, 3},
  {1, 79},
  {2, 3},
  {1, 12},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 19},
  {1, 104},
  {1, 3},
  {1, 14},
  {1, 13},
  {2, 2},
  {1, 12},
  {2, 3},
  {1, 26},
  {2, 4},
  {1, 39},
  {4, 1},
  {1, 28},
  {1, 24},
  {1, 23},
  {1, 1},
  {7, 0},                                                 /* End of row  50 */
  {8, 0},
  {1, 115},
  {1, 70},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 22},
  {1, 29},
  {2, 4},
  {1, 38},
  {5, 1},
  {1, 34},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 12},
  {3, 3},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 20},
  {3, 3},
  {1, 14},
  {1, 13},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 21},
  {1, 30},
  {1, 25},
  {1, 3},
  {1, 12},
  {2, 2},
  {1, 13},
  {1, 14},
  {1, 3},
  {1, 25},
  {1, 30},
  {1, 4},
  {1, 36},
  {1, 37},
  {2, 1},
  {1, 28},
  {1, 24},
  {1, 23},
  {1, 1},
  {8, 0},                                                 /* End of row  51 */
  {8, 0},
  {2, 3},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 22},
  {1, 29},
  {2, 4},
  {1, 38},
  {5, 1},
  {1, 41},
  {1, 33},
  {1, 3},
  {1, 10},
  {2, 2},
  {1, 13},
  {1, 14},
  {2, 3},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 20},
  {3, 3},
  {1, 12},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 19},
  {1, 27},
  {1, 4},
  {1, 26},
  {1, 3},
  {1, 14},
  {1, 13},
  {2, 2},
  {1, 12},
  {2, 3},
  {1, 26},
  {2, 4},
  {1, 39},
  {1, 1},
  {1, 28},
  {1, 24},
  {1, 23},
  {1, 1},
  {9, 0},                                                 /* End of row  52 */
  {8, 0},
  {2, 3},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 22},
  {1, 29},
  {2, 4},
  {1, 38},
  {6, 1},
  {1, 34},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 12},
  {2, 3},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 20},
  {2, 3},
  {1, 14},
  {1, 13},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 21},
  {2, 4},
  {1, 30},
  {1, 25},
  {1, 3},
  {1, 12},
  {2, 2},
  {1, 13},
  {1, 14},
  {1, 3},
  {1, 25},
  {1, 30},
  {1, 4},
  {1, 36},
  {1, 178},
  {1, 24},
  {1, 23},
  {1, 1},
  {10, 0},                                                /* End of row  53 */
  {8, 0},
  {2, 3},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 22},
  {1, 29},
  {2, 4},
  {1, 38},
  {6, 1},
  {1, 41},
  {1, 33},
  {1, 3},
  {1, 10},
  {2, 2},
  {1, 13},
  {1, 14},
  {1, 3},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 20},
  {2, 3},
  {1, 12},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 19},
  {1, 27},
  {2, 4},
  {1, 35},
  {1, 61},
  {1, 3},
  {1, 14},
  {1, 13},
  {2, 2},
  {1, 12},
  {2, 3},
  {1, 26},
  {2, 4},
  {1, 176},
  {1, 185},
  {1, 1},
  {11, 0},                                                /* End of row  54 */
  {8, 0},
  {2, 3},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 22},
  {1, 29},
  {2, 4},
  {1, 38},
  {7, 1},
  {1, 34},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 12},
  {1, 3},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 20},
  {1, 3},
  {1, 14},
  {1, 13},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 21},
  {3, 4},
  {1, 40},
  {1, 60},
  {1, 57},
  {1, 3},
  {1, 12},
  {2, 2},
  {1, 13},
  {1, 14},
  {1, 3},
  {1, 25},
  {1, 30},
  {1, 68},
  {1, 67},
  {1, 163},
  {12, 0},                                                /* End of row  55 */
  {8, 0},
  {2, 3},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 22},
  {1, 29},
  {2, 4},
  {1, 38},
  {7, 1},
  {1, 41},
  {1, 33},
  {1, 3},
  {1, 10},
  {2, 2},
  {1, 13},
  {1, 14},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 20},
  {1, 3},
  {1, 12},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 19},
  {1, 27},
  {2, 4},
  {1, 35},
  {1, 11},
  {1, 1},
  {1, 65},
  {1, 3},
  {1, 14},
  {1, 13},
  {2, 2},
  {1, 12},
  {2, 3},
  {1, 111},
  {1, 67},
  {3, 5},
  {11, 0},                                                /* End of row  56 */
  {8, 0},
  {2, 3},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 22},
  {1, 29},
  {2, 4},
  {1, 38},
  {8, 1},
  {1, 34},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 12},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 20},
  {1, 14},
  {1, 13},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 21},
  {3, 4},
  {1, 40},
  {2, 1},
  {1, 60},
  {1, 57},
  {1, 3},
  {1, 12},
  {2, 2},
  {1, 13},
  {1, 14},
  {1, 3},
  {1, 78},
  {1, 50},
  {3, 5},
  {11, 0},                                                /* End of row  57 */
  {8, 0},
  {2, 3},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 22},
  {1, 29},
  {2, 4},
  {1, 38},
  {8, 1},
  {1, 41},
  {1, 33},
  {1, 3},
  {1, 10},
  {2, 2},
  {1, 13},
  {1, 93},
  {1, 6},
  {2, 2},
  {1, 20},
  {1, 12},
  {3, 2},
  {1, 10},
  {1, 3},
  {1, 19},
  {1, 27},
  {2, 4},
  {1, 35},
  {1, 11},
  {3, 1},
  {1, 65},
  {1, 3},
  {1, 14},
  {1, 13},
  {2, 2},
  {1, 12},
  {2, 3},
  {1, 49},
  {4, 5},
  {10, 0},                                                /* End of row  58 */
  {8, 0},
  {2, 3},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 56},
  {1, 121},
  {2, 4},
  {1, 38},
  {9, 1},
  {1, 34},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 138},
  {1, 6},
  {2, 2},
  {1, 139},
  {1, 13},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 21},
  {3, 4},
  {1, 40},
  {4, 1},
  {1, 60},
  {1, 57},
  {1, 3},
  {1, 12},
  {2, 2},
  {1, 13},
  {1, 14},
  {1, 3},
  {1, 48},
  {1, 50},
  {3, 5},
  {10, 0},                                                /* End of row  59 */
  {8, 0},
  {2, 3},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 47},
  {1, 112},
  {1, 63},
  {1, 4},
  {1, 73},
  {1, 15},
  {8, 1},
  {1, 41},
  {1, 33},
  {1, 3},
  {1, 10},
  {10, 2},
  {1, 10},
  {1, 3},
  {1, 19},
  {1, 27},
  {2, 4},
  {1, 35},
  {1, 11},
  {5, 1},
  {1, 65},
  {1, 3},
  {1, 14},
  {1, 13},
  {2, 2},
  {1, 12},
  {2, 3},
  {1, 49},
  {4, 5},
  {9, 0},                                                 /* End of row  60 */
  {8, 0},
  {2, 3},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 47},
  {1, 46},
  {1, 66},
  {1, 63},
  {1, 151},
  {1, 16},
  {1, 15},
  {8, 1},
  {1, 34},
  {1, 3},
  {1, 9},
  {1, 8},
  {8, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 21},
  {3, 4},
  {1, 40},
  {6, 1},
  {1, 175},
  {1, 147},
  {1, 3},
  {1, 12},
  {2, 2},
  {1, 13},
  {1, 14},
  {1, 3},
  {1, 48},
  {1, 50},
  {3, 5},
  {9, 0},                                                 /* End of row  61 */
  {8, 0},
  {2, 3},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 47},
  {1, 46},
  {1, 5},
  {1, 66},
  {1, 174},
  {1, 11},
  {1, 16},
  {1, 15},
  {7, 1},
  {1, 41},
  {1, 33},
  {1, 3},
  {1, 10},
  {8, 2},
  {1, 10},
  {1, 3},
  {1, 19},
  {1, 27},
  {2, 4},
  {1, 35},
  {1, 11},
  {5, 1},
  {1, 28},
  {1, 24},
  {1, 107},
  {1, 3},
  {1, 14},
  {1, 13},
  {2, 2},
  {1, 12},
  {2, 3},
  {1, 49},
  {4, 5},
  {8, 0},                                                 /* End of row  62 */
  {8, 0},
  {2, 3},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 47},
  {1, 46},
  {2, 5},
  {1, 162},
  {1, 1},
  {1, 11},
  {1, 16},
  {1, 15},
  {7, 1},
  {1, 34},
  {1, 3},
  {1, 9},
  {1, 8},
  {6, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 21},
  {3, 4},
  {1, 40},
  {5, 1},
  {1, 28},
  {1, 24},
  {1, 23},
  {1, 157},
  {2, 3},
  {1, 12},
  {2, 2},
  {1, 13},
  {1, 14},
  {1, 3},
  {1, 48},
  {1, 50},
  {3, 5},
  {8, 0},                                                 /* End of row  63 */
  {8, 0},
  {2, 3},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 47},
  {1, 46},
  {3, 5},
  {2, 1},
  {1, 11},
  {1, 16},
  {1, 15},
  {6, 1},
  {1, 41},
  {1, 33},
  {1, 3},
  {1, 10},
  {6, 2},
  {1, 10},
  {1, 3},
  {1, 19},
  {1, 27},
  {2, 4},
  {1, 35},
  {1, 11},
  {4, 1},
  {1, 28},
  {1, 24},
  {1, 23},
  {1, 1},
  {1, 0},
  {2, 3},
  {1, 14},
  {1, 13},
  {2, 2},
  {1, 12},
  {2, 3},
  {1, 49},
  {4, 5},
  {7, 0},                                                 /* End of row  64 */
  {8, 0},
  {2, 3},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 47},
  {1, 46},
  {3, 5},
  {1, 0},
  {2, 1},
  {1, 11},
  {1, 16},
  {1, 15},
  {6, 1},
  {1, 34},
  {1, 3},
  {1, 9},
  {1, 8},
  {4, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 21},
  {3, 4},
  {1, 40},
  {4, 1},
  {1, 28},
  {1, 24},
  {1, 23},
  {1, 1},
  {2, 0},
  {3, 3},
  {1, 12},
  {2, 2},
  {1, 13},
  {1, 14},
  {1, 3},
  {1, 48},
  {1, 50},
  {3, 5},
  {7, 0},                                                 /* End of row  65 */
  {8, 0},
  {2, 3},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 47},
  {1, 46},
  {3, 5},
  {2, 0},
  {2, 1},
  {1, 11},
  {1, 16},
  {1, 15},
  {5, 1},
  {1, 41},
  {1, 33},
  {1, 3},
  {1, 10},
  {4, 2},
  {1, 10},
  {1, 3},
  {1, 19},
  {1, 27},
  {2, 4},
  {1, 35},
  {1, 11},
  {3, 1},
  {1, 28},
  {1, 24},
  {1, 23},
  {1, 1},
  {4, 0},
  {2, 3},
  {1, 14},
  {1, 13},
  {2, 2},
  {1, 12},
  {2, 3},
  {1, 103},
  {3, 5},
  {7, 0},                                                 /* End of row  66 */
  {8, 0},
  {2, 3},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 47},
  {1, 46},
  {3, 5},
  {3, 0},
  {2, 1},
  {1, 11},
  {1, 16},
  {1, 15},
  {5, 1},
  {1, 34},
  {1, 3},
  {1, 9},
  {1, 8},
  {2, 2},
  {1, 8},
  {1, 9},
  {1, 3},
  {1, 21},
  {3, 4},
  {1, 40},
  {3, 1},
  {1, 28},
  {1, 24},
  {1, 23},
  {1, 1},
  {5, 0},
  {3, 3},
  {1, 12},
  {2, 2},
  {1, 75},
  {2, 3},
  {1, 156},
  {4, 5},
  {6, 0},                                                 /* End of row  67 */
  {8, 0},
  {2, 3},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 47},
  {1, 46},
  {3, 5},
  {4, 0},
  {2, 1},
  {1, 11},
  {1, 16},
  {1, 15},
  {4, 1},
  {1, 41},
  {1, 33},
  {1, 3},
  {1, 76},
  {2, 8},
  {1, 76},
  {1, 3},
  {1, 19},
  {1, 27},
  {2, 4},
  {1, 35},
  {1, 11},
  {2, 1},
  {1, 28},
  {1, 24},
  {1, 23},
  {1, 1},
  {7, 0},
  {2, 3},
  {1, 14},
  {2, 8},
  {1, 92},
  {1, 3},
  {1, 48},
  {1, 160},
  {4, 5},
  {6, 0},                                                 /* End of row  68 */
  {8, 0},
  {2, 3},
  {1, 7},
  {1, 6},
  {2, 2},
  {1, 6},
  {1, 7},
  {1, 47},
  {1, 46},
  {3, 5},
  {5, 0},
  {2, 1},
  {1, 11},
  {1, 16},
  {1, 15},
  {4, 1},
  {1, 34},
  {2, 3},
  {2, 9},
  {2, 3},
  {1, 21},
  {3, 4},
  {1, 40},
  {2, 1},
  {1, 28},
  {1, 24},
  {1, 23},
  {1, 1},
  {8, 0},
  {3, 3},
  {2, 9},
  {1, 3},
  {1, 33},
  {1, 154},
  {5, 5},
  {6, 0},                                                 /* End of row  69 */
  {8, 0},
  {2, 3},
  {1, 7},
  {1, 6},
  {1, 135},
  {1, 136},
  {1, 137},
  {1, 144},
  {1, 96},
  {1, 46},
  {3, 5},
  {6, 0},
  {2, 1},
  {1, 11},
  {1, 16},
  {1, 15},
  {3, 1},
  {1, 62},
  {1, 77},
  {4, 3},
  {1, 98},
  {1, 82},
  {2, 4},
  {1, 35},
  {1, 11},
  {1, 1},
  {1, 28},
  {1, 24},
  {1, 23},
  {1, 1},
  {10, 0},
  {4, 3},
  {1, 97},
  {1, 49},
  {5, 5},
  {7, 0},                                                 /* End of row  70 */
  {9, 0},
  {1, 3},
  {1, 7},
  {1, 13},
  {1, 158},
  {1, 109},
  {1, 110},
  {2, 46},
  {4, 5},
  {7, 0},
  {2, 1},
  {1, 11},
  {1, 16},
  {1, 15},
  {3, 1},
  {1, 62},
  {1, 34},
  {1, 56},
  {1, 95},
  {1, 21},
  {1, 82},
  {2, 4},
  {1, 84},
  {1, 193},
  {1, 1},
  {1, 28},
  {1, 24},
  {1, 23},
  {1, 1},
  {12, 0},
  {2, 3},
  {1, 153},
  {1, 46},
  {6, 5},
  {7, 0},                                                 /* End of row  71 */
  {12, 0},
  {9, 5},
  {8, 0},
  {2, 1},
  {1, 11},
  {1, 16},
  {1, 15},
  {4, 1},
  {1, 129},
  {1, 184},
  {1, 119},
  {2, 53},
  {1, 73},
  {1, 86},
  {1, 1},
  {1, 28},
  {1, 24},
  {1, 23},
  {1, 1},
  {15, 0},
  {7, 5},
  {8, 0},                                                 /* End of row  72 */
  {12, 0},
  {9, 5},
  {9, 0},
  {2, 1},
  {1, 11},
  {1, 16},
  {1, 15},
  {5, 1},
  {3, 11},
  {2, 1},
  {1, 28},
  {1, 24},
  {1, 23},
  {1, 1},
  {17, 0},
  {5, 5},
  {9, 0},                                                 /* End of row  73 */
  {12, 0},
  {9, 5},
  {10, 0},
  {2, 1},
  {1, 11},
  {1, 16},
  {1, 15},
  {8, 1},
  {1, 28},
  {1, 24},
  {1, 23},
  {1, 1},
  {32, 0},                                                /* End of row  74 */
  {32, 0},
  {2, 1},
  {1, 11},
  {1, 16},
  {1, 15},
  {6, 1},
  {1, 28},
  {1, 24},
  {1, 23},
  {1, 1},
  {33, 0},                                                /* End of row  75 */
  {33, 0},
  {2, 1},
  {1, 11},
  {1, 16},
  {1, 15},
  {4, 1},
  {1, 28},
  {1, 24},
  {1, 23},
  {1, 1},
  {34, 0},                                                /* End of row  76 */
  {34, 0},
  {2, 1},
  {1, 11},
  {1, 16},
  {1, 15},
  {2, 1},
  {1, 28},
  {1, 24},
  {1, 23},
  {1, 1},
  {35, 0},                                                /* End of row  77 */
  {35, 0},
  {2, 1},
  {1, 11},
  {1, 16},
  {1, 15},
  {1, 28},
  {1, 24},
  {1, 23},
  {1, 1},
  {36, 0},                                                /* End of row  78 */
  {36, 0},
  {2, 1},
  {1, 11},
  {1, 126},
  {1, 24},
  {1, 23},
  {1, 1},
  {37, 0},                                                /* End of row  79 */
  {37, 0},
  {2, 1},
  {1, 125},
  {1, 23},
  {1, 1},
  {38, 0},                                                /* End of row  80 */
};
#endif /* CONFIG_VIDEO_FB_SPLASHSCREEN_BPP24 */

#ifdef CONFIG_VIDEO_FB_SPLASHSCREEN_GREY
static const struct splscr_bitmap_s bitmap[] =
{
  {37, 0},
  {1, 156},
  {1, 128},
  {1, 75},
  {3, 74},
  {37, 0},                                                /* End of row   1 */
  {36, 0},
  {1, 156},
  {1, 128},
  {1, 75},
  {1, 99},
  {1, 77},
  {3, 74},
  {36, 0},                                                /* End of row   2 */
  {35, 0},
  {1, 156},
  {1, 128},
  {1, 75},
  {1, 106},
  {1, 100},
  {1, 73},
  {1, 66},
  {3, 74},
  {35, 0},                                                /* End of row   3 */
  {34, 0},
  {1, 156},
  {1, 128},
  {1, 75},
  {1, 106},
  {1, 100},
  {2, 74},
  {1, 73},
  {1, 66},
  {3, 74},
  {34, 0},                                                /* End of row   4 */
  {33, 0},
  {1, 156},
  {1, 128},
  {1, 75},
  {1, 106},
  {1, 100},
  {4, 74},
  {1, 73},
  {1, 66},
  {3, 74},
  {33, 0},                                                /* End of row   5 */
  {32, 0},
  {1, 156},
  {1, 128},
  {1, 75},
  {1, 106},
  {1, 100},
  {6, 74},
  {1, 73},
  {1, 66},
  {3, 74},
  {32, 0},                                                /* End of row   6 */
  {31, 0},
  {1, 156},
  {1, 128},
  {1, 75},
  {1, 106},
  {1, 100},
  {8, 74},
  {1, 73},
  {1, 66},
  {3, 74},
  {31, 0},                                                /* End of row   7 */
  {30, 0},
  {1, 156},
  {1, 128},
  {1, 75},
  {1, 106},
  {1, 100},
  {10, 74},
  {1, 73},
  {1, 66},
  {3, 74},
  {30, 0},                                                /* End of row   8 */
  {29, 0},
  {1, 156},
  {1, 128},
  {1, 75},
  {1, 106},
  {1, 100},
  {12, 74},
  {1, 73},
  {1, 66},
  {3, 74},
  {13, 0},
  {3, 222},
  {13, 0},                                                /* End of row   9 */
  {28, 0},
  {1, 156},
  {1, 128},
  {1, 75},
  {1, 106},
  {1, 100},
  {4, 74},
  {1, 79},
  {2, 83},
  {7, 74},
  {1, 73},
  {1, 66},
  {3, 74},
  {11, 0},
  {6, 222},
  {11, 0},                                                /* End of row  10 */
  {11, 0},
  {5, 222},
  {11, 0},
  {1, 156},
  {1, 128},
  {1, 75},
  {1, 106},
  {1, 100},
  {4, 74},
  {1, 129},
  {1, 210},
  {2, 221},
  {1, 187},
  {1, 100},
  {6, 74},
  {1, 73},
  {1, 66},
  {3, 74},
  {9, 0},
  {8, 222},
  {10, 0},                                                /* End of row  11 */
  {10, 0},
  {6, 222},
  {1, 218},
  {2, 137},
  {7, 0},
  {1, 156},
  {1, 128},
  {1, 75},
  {1, 106},
  {1, 100},
  {4, 74},
  {1, 115},
  {1, 216},
  {4, 222},
  {1, 205},
  {1, 93},
  {1, 64},
  {1, 71},
  {4, 74},
  {1, 73},
  {1, 66},
  {3, 74},
  {8, 0},
  {3, 222},
  {2, 225},
  {3, 222},
  {1, 142},
  {9, 0},                                                 /* End of row  12 */
  {9, 0},
  {7, 222},
  {1, 213},
  {1, 139},
  {3, 137},
  {4, 0},
  {1, 156},
  {1, 128},
  {1, 75},
  {1, 106},
  {1, 100},
  {5, 74},
  {1, 187},
  {1, 222},
  {1, 225},
  {1, 239},
  {1, 233},
  {2, 222},
  {1, 183},
  {1, 51},
  {1, 53},
  {1, 71},
  {4, 74},
  {1, 73},
  {1, 66},
  {3, 74},
  {6, 0},
  {3, 222},
  {1, 234},
  {2, 254},
  {1, 234},
  {1, 222},
  {1, 221},
  {1, 156},
  {1, 137},
  {8, 0},                                                 /* End of row  13 */
  {9, 0},
  {2, 222},
  {1, 225},
  {1, 243},
  {1, 246},
  {1, 225},
  {2, 222},
  {1, 176},
  {3, 137},
  {3, 0},
  {1, 156},
  {1, 128},
  {1, 75},
  {1, 106},
  {1, 100},
  {5, 74},
  {1, 81},
  {1, 215},
  {1, 222},
  {1, 240},
  {2, 255},
  {1, 234},
  {1, 222},
  {1, 221},
  {1, 103},
  {1, 51},
  {1, 53},
  {1, 71},
  {4, 74},
  {1, 73},
  {1, 66},
  {3, 74},
  {5, 0},
  {2, 222},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 247},
  {2, 222},
  {1, 165},
  {2, 137},
  {7, 0},                                                 /* End of row  14 */
  {8, 0},
  {3, 222},
  {1, 243},
  {2, 255},
  {1, 241},
  {2, 222},
  {1, 213},
  {1, 139},
  {3, 137},
  {1, 0},
  {1, 156},
  {1, 128},
  {1, 75},
  {1, 106},
  {1, 100},
  {6, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 251},
  {1, 223},
  {1, 222},
  {1, 183},
  {2, 51},
  {1, 61},
  {5, 74},
  {1, 73},
  {1, 66},
  {3, 74},
  {3, 0},
  {3, 222},
  {1, 235},
  {3, 255},
  {1, 235},
  {1, 222},
  {1, 221},
  {1, 153},
  {2, 137},
  {7, 0},                                                 /* End of row  15 */
  {8, 0},
  {2, 222},
  {1, 223},
  {1, 254},
  {3, 255},
  {1, 227},
  {2, 222},
  {1, 176},
  {3, 137},
  {1, 156},
  {1, 128},
  {1, 75},
  {1, 106},
  {1, 100},
  {7, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {3, 255},
  {1, 235},
  {1, 222},
  {1, 221},
  {1, 103},
  {2, 51},
  {1, 71},
  {5, 74},
  {1, 73},
  {1, 66},
  {3, 74},
  {2, 0},
  {2, 222},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 251},
  {1, 223},
  {1, 222},
  {1, 197},
  {3, 137},
  {7, 0},                                                 /* End of row  16 */
  {8, 0},
  {2, 222},
  {1, 223},
  {1, 254},
  {3, 255},
  {1, 243},
  {2, 222},
  {1, 213},
  {1, 139},
  {1, 137},
  {1, 133},
  {1, 128},
  {1, 75},
  {1, 106},
  {1, 100},
  {8, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {3, 255},
  {1, 251},
  {1, 223},
  {1, 222},
  {1, 183},
  {2, 51},
  {1, 61},
  {6, 74},
  {1, 73},
  {1, 66},
  {3, 74},
  {3, 222},
  {1, 235},
  {3, 255},
  {1, 235},
  {1, 222},
  {1, 221},
  {1, 153},
  {3, 137},
  {7, 0},                                                 /* End of row  17 */
  {8, 0},
  {2, 222},
  {1, 223},
  {1, 254},
  {4, 255},
  {1, 227},
  {2, 222},
  {1, 176},
  {1, 133},
  {1, 79},
  {1, 66},
  {1, 106},
  {1, 100},
  {9, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {4, 255},
  {1, 235},
  {1, 222},
  {1, 221},
  {1, 103},
  {2, 51},
  {1, 71},
  {6, 74},
  {1, 73},
  {1, 66},
  {2, 74},
  {1, 215},
  {1, 222},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 251},
  {1, 223},
  {1, 222},
  {1, 192},
  {4, 137},
  {7, 0},                                                 /* End of row  18 */
  {8, 0},
  {2, 222},
  {1, 223},
  {1, 254},
  {4, 255},
  {1, 243},
  {2, 222},
  {1, 213},
  {1, 84},
  {1, 51},
  {1, 54},
  {1, 98},
  {10, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {4, 255},
  {1, 251},
  {1, 223},
  {1, 222},
  {1, 183},
  {2, 51},
  {1, 61},
  {7, 74},
  {1, 73},
  {1, 66},
  {1, 117},
  {1, 221},
  {1, 222},
  {1, 235},
  {3, 255},
  {1, 235},
  {1, 222},
  {1, 221},
  {1, 153},
  {3, 137},
  {8, 0},                                                 /* End of row  19 */
  {8, 0},
  {2, 222},
  {1, 223},
  {1, 254},
  {5, 255},
  {1, 227},
  {2, 222},
  {1, 149},
  {2, 51},
  {1, 67},
  {10, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {5, 255},
  {1, 235},
  {1, 222},
  {1, 221},
  {1, 103},
  {2, 51},
  {1, 71},
  {7, 74},
  {1, 73},
  {1, 185},
  {1, 222},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 251},
  {1, 223},
  {1, 222},
  {1, 197},
  {4, 137},
  {8, 0},                                                 /* End of row  20 */
  {8, 0},
  {2, 222},
  {1, 223},
  {1, 254},
  {5, 255},
  {1, 243},
  {2, 222},
  {1, 209},
  {1, 60},
  {1, 51},
  {1, 55},
  {10, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {5, 255},
  {1, 251},
  {1, 223},
  {1, 222},
  {1, 183},
  {2, 51},
  {1, 61},
  {7, 74},
  {1, 117},
  {1, 221},
  {1, 222},
  {1, 235},
  {3, 255},
  {1, 235},
  {1, 222},
  {1, 221},
  {1, 153},
  {3, 137},
  {9, 0},                                                 /* End of row  21 */
  {8, 0},
  {2, 222},
  {1, 223},
  {1, 254},
  {6, 255},
  {1, 227},
  {2, 222},
  {1, 149},
  {2, 51},
  {1, 67},
  {9, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 251},
  {3, 255},
  {1, 235},
  {1, 222},
  {1, 221},
  {1, 103},
  {2, 51},
  {1, 71},
  {6, 74},
  {1, 187},
  {1, 222},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 251},
  {1, 223},
  {1, 222},
  {1, 197},
  {4, 137},
  {9, 0},                                                 /* End of row  22 */
  {8, 0},
  {2, 222},
  {1, 223},
  {1, 254},
  {3, 255},
  {1, 252},
  {2, 255},
  {1, 243},
  {2, 222},
  {1, 209},
  {1, 60},
  {1, 51},
  {1, 55},
  {9, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {1, 251},
  {2, 255},
  {1, 251},
  {1, 223},
  {1, 222},
  {1, 183},
  {2, 51},
  {1, 61},
  {5, 74},
  {1, 117},
  {1, 221},
  {1, 222},
  {1, 235},
  {3, 255},
  {1, 235},
  {1, 222},
  {1, 221},
  {1, 153},
  {3, 137},
  {10, 0},                                                /* End of row  23 */
  {8, 0},
  {2, 222},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 236},
  {3, 255},
  {1, 227},
  {2, 222},
  {1, 149},
  {2, 51},
  {1, 67},
  {8, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {1, 235},
  {3, 255},
  {1, 235},
  {1, 222},
  {1, 221},
  {1, 103},
  {2, 51},
  {1, 71},
  {4, 74},
  {1, 187},
  {1, 222},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 251},
  {1, 223},
  {1, 222},
  {1, 197},
  {4, 137},
  {10, 0},                                                /* End of row  24 */
  {8, 0},
  {2, 222},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 224},
  {1, 251},
  {2, 255},
  {1, 243},
  {2, 222},
  {1, 209},
  {1, 60},
  {1, 51},
  {1, 55},
  {8, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 251},
  {1, 223},
  {1, 222},
  {1, 183},
  {2, 51},
  {1, 61},
  {3, 74},
  {1, 117},
  {1, 221},
  {1, 222},
  {1, 235},
  {3, 255},
  {1, 235},
  {1, 222},
  {1, 221},
  {1, 138},
  {3, 137},
  {11, 0},                                                /* End of row  25 */
  {8, 0},
  {2, 222},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 235},
  {3, 255},
  {1, 227},
  {2, 222},
  {1, 149},
  {2, 51},
  {1, 67},
  {7, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {1, 222},
  {1, 235},
  {3, 255},
  {1, 235},
  {1, 222},
  {1, 221},
  {1, 103},
  {2, 51},
  {1, 71},
  {2, 74},
  {1, 187},
  {1, 222},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 251},
  {1, 223},
  {1, 222},
  {1, 183},
  {1, 53},
  {1, 114},
  {2, 137},
  {11, 0},                                                /* End of row  26 */
  {8, 0},
  {2, 222},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {2, 223},
  {1, 251},
  {2, 255},
  {1, 243},
  {2, 222},
  {1, 209},
  {1, 60},
  {1, 51},
  {1, 55},
  {7, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {1, 222},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 251},
  {1, 223},
  {1, 222},
  {1, 183},
  {2, 51},
  {1, 61},
  {1, 74},
  {1, 117},
  {1, 221},
  {1, 222},
  {1, 235},
  {3, 255},
  {1, 235},
  {1, 222},
  {1, 221},
  {1, 103},
  {1, 51},
  {1, 53},
  {1, 102},
  {12, 0},                                                /* End of row  27 */
  {8, 0},
  {2, 222},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 222},
  {1, 235},
  {3, 255},
  {1, 227},
  {2, 222},
  {1, 149},
  {2, 51},
  {1, 67},
  {6, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {2, 222},
  {1, 235},
  {3, 255},
  {1, 235},
  {1, 222},
  {1, 221},
  {1, 103},
  {2, 51},
  {1, 72},
  {1, 187},
  {1, 222},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 251},
  {1, 223},
  {1, 222},
  {1, 183},
  {3, 51},
  {1, 69},
  {1, 74},
  {11, 0},                                                /* End of row  28 */
  {8, 0},
  {2, 222},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 222},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 243},
  {2, 222},
  {1, 209},
  {1, 60},
  {1, 51},
  {1, 55},
  {6, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {2, 222},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 251},
  {1, 223},
  {1, 222},
  {1, 183},
  {2, 51},
  {1, 107},
  {1, 221},
  {1, 222},
  {1, 235},
  {3, 255},
  {1, 235},
  {1, 222},
  {1, 221},
  {1, 103},
  {2, 51},
  {1, 60},
  {1, 66},
  {2, 74},
  {10, 0},                                                /* End of row  29 */
  {8, 0},
  {1, 177},
  {1, 222},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {2, 222},
  {1, 235},
  {3, 255},
  {1, 227},
  {2, 222},
  {1, 149},
  {2, 51},
  {1, 67},
  {5, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {3, 222},
  {1, 235},
  {3, 255},
  {1, 235},
  {1, 222},
  {1, 221},
  {1, 103},
  {1, 51},
  {1, 183},
  {1, 222},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 251},
  {1, 223},
  {1, 222},
  {1, 183},
  {3, 51},
  {1, 71},
  {1, 73},
  {1, 66},
  {2, 74},
  {9, 0},                                                 /* End of row  30 */
  {7, 0},
  {1, 156},
  {1, 133},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {2, 222},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 243},
  {2, 222},
  {1, 209},
  {1, 60},
  {1, 51},
  {1, 55},
  {5, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {1, 222},
  {1, 210},
  {1, 222},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 251},
  {1, 223},
  {1, 222},
  {1, 183},
  {1, 103},
  {1, 221},
  {1, 222},
  {1, 235},
  {3, 255},
  {1, 235},
  {1, 222},
  {1, 221},
  {1, 103},
  {2, 51},
  {1, 61},
  {2, 74},
  {1, 73},
  {1, 66},
  {2, 74},
  {8, 0},                                                 /* End of row  31 */
  {6, 0},
  {1, 156},
  {1, 128},
  {1, 82},
  {1, 220},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {3, 222},
  {1, 235},
  {3, 255},
  {1, 227},
  {2, 222},
  {1, 149},
  {2, 51},
  {1, 67},
  {4, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {1, 222},
  {1, 169},
  {1, 209},
  {1, 222},
  {1, 235},
  {3, 255},
  {1, 235},
  {1, 222},
  {1, 221},
  {1, 198},
  {1, 222},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 251},
  {1, 223},
  {1, 222},
  {1, 183},
  {3, 51},
  {1, 71},
  {3, 74},
  {1, 73},
  {1, 66},
  {2, 74},
  {7, 0},                                                 /* End of row  32 */
  {5, 0},
  {1, 156},
  {1, 128},
  {1, 74},
  {1, 120},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 220},
  {1, 186},
  {1, 222},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 243},
  {2, 222},
  {1, 209},
  {1, 60},
  {1, 51},
  {1, 55},
  {4, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {1, 222},
  {1, 167},
  {1, 149},
  {1, 222},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 251},
  {1, 223},
  {3, 222},
  {1, 235},
  {3, 255},
  {1, 235},
  {1, 222},
  {1, 221},
  {1, 103},
  {2, 51},
  {1, 61},
  {5, 74},
  {1, 73},
  {1, 66},
  {2, 74},
  {6, 0},                                                 /* End of row  33 */
  {4, 0},
  {1, 156},
  {1, 128},
  {1, 74},
  {1, 116},
  {1, 93},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 220},
  {1, 108},
  {1, 221},
  {1, 222},
  {1, 235},
  {3, 255},
  {1, 227},
  {2, 222},
  {1, 149},
  {2, 51},
  {1, 67},
  {3, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {1, 222},
  {1, 167},
  {1, 60},
  {1, 209},
  {1, 222},
  {1, 235},
  {3, 255},
  {1, 235},
  {2, 222},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 251},
  {1, 223},
  {1, 222},
  {1, 183},
  {3, 51},
  {1, 71},
  {6, 74},
  {1, 73},
  {1, 66},
  {2, 74},
  {5, 0},                                                 /* End of row  34 */
  {3, 0},
  {1, 156},
  {1, 128},
  {1, 74},
  {1, 116},
  {1, 86},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 220},
  {1, 63},
  {1, 183},
  {1, 222},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 243},
  {2, 222},
  {1, 209},
  {1, 60},
  {1, 51},
  {1, 55},
  {3, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {1, 222},
  {1, 167},
  {1, 51},
  {1, 149},
  {1, 222},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 251},
  {1, 223},
  {1, 222},
  {1, 235},
  {3, 255},
  {1, 235},
  {1, 222},
  {1, 221},
  {1, 103},
  {2, 51},
  {1, 61},
  {8, 74},
  {1, 73},
  {1, 66},
  {2, 74},
  {4, 0},                                                 /* End of row  35 */
  {2, 0},
  {1, 156},
  {1, 128},
  {1, 74},
  {1, 116},
  {1, 86},
  {1, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 220},
  {1, 63},
  {1, 103},
  {1, 221},
  {1, 222},
  {1, 235},
  {3, 255},
  {1, 227},
  {2, 222},
  {1, 149},
  {2, 51},
  {1, 67},
  {2, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {1, 222},
  {1, 167},
  {1, 51},
  {1, 60},
  {1, 209},
  {1, 222},
  {1, 235},
  {3, 255},
  {1, 235},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 251},
  {1, 223},
  {1, 222},
  {1, 183},
  {3, 51},
  {1, 71},
  {9, 74},
  {1, 73},
  {1, 66},
  {2, 74},
  {3, 0},                                                 /* End of row  36 */
  {1, 0},
  {1, 156},
  {1, 128},
  {1, 74},
  {1, 116},
  {1, 86},
  {2, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 220},
  {1, 63},
  {1, 51},
  {1, 183},
  {1, 222},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 243},
  {2, 222},
  {1, 209},
  {1, 60},
  {1, 51},
  {1, 55},
  {2, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {1, 222},
  {1, 167},
  {2, 51},
  {1, 149},
  {1, 222},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 251},
  {1, 236},
  {3, 255},
  {1, 235},
  {1, 222},
  {1, 221},
  {1, 103},
  {2, 51},
  {1, 61},
  {11, 74},
  {1, 73},
  {1, 66},
  {2, 74},
  {2, 0},                                                 /* End of row  37 */
  {1, 156},
  {1, 128},
  {1, 74},
  {1, 116},
  {1, 86},
  {3, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 220},
  {1, 63},
  {1, 51},
  {1, 103},
  {1, 221},
  {1, 222},
  {1, 235},
  {3, 255},
  {1, 227},
  {2, 222},
  {1, 149},
  {2, 51},
  {1, 67},
  {1, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {1, 222},
  {1, 167},
  {2, 51},
  {1, 60},
  {1, 210},
  {1, 222},
  {1, 235},
  {6, 255},
  {1, 251},
  {1, 223},
  {1, 222},
  {1, 183},
  {3, 51},
  {1, 71},
  {12, 74},
  {1, 73},
  {1, 66},
  {2, 74},
  {1, 0},                                                 /* End of row  38 */
  {1, 128},
  {1, 74},
  {1, 116},
  {1, 86},
  {4, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 220},
  {1, 63},
  {2, 51},
  {1, 183},
  {1, 222},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 243},
  {2, 222},
  {1, 209},
  {1, 60},
  {1, 51},
  {1, 55},
  {1, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {1, 222},
  {1, 167},
  {3, 51},
  {1, 157},
  {1, 222},
  {1, 223},
  {1, 251},
  {5, 255},
  {1, 235},
  {1, 222},
  {1, 221},
  {1, 103},
  {2, 51},
  {1, 61},
  {14, 74},
  {1, 73},
  {1, 66},
  {2, 74},                                                /* End of row  39 */
  {1, 73},
  {1, 110},
  {1, 86},
  {5, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 220},
  {1, 63},
  {2, 51},
  {1, 109},
  {1, 221},
  {1, 222},
  {1, 235},
  {3, 255},
  {1, 227},
  {2, 222},
  {1, 149},
  {2, 51},
  {1, 67},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {1, 222},
  {1, 167},
  {3, 51},
  {1, 80},
  {1, 211},
  {1, 222},
  {1, 235},
  {4, 255},
  {1, 251},
  {1, 223},
  {1, 222},
  {1, 183},
  {3, 51},
  {1, 71},
  {15, 74},
  {1, 73},
  {1, 66},
  {1, 74},                                                /* End of row  40 */
  {1, 74},
  {1, 67},
  {1, 73},
  {5, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 220},
  {1, 63},
  {2, 51},
  {1, 64},
  {1, 187},
  {1, 222},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 243},
  {2, 222},
  {1, 209},
  {1, 60},
  {1, 51},
  {1, 55},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {1, 222},
  {1, 167},
  {3, 51},
  {1, 80},
  {1, 211},
  {1, 222},
  {1, 227},
  {4, 255},
  {1, 240},
  {1, 222},
  {1, 221},
  {1, 105},
  {2, 51},
  {1, 61},
  {17, 74},
  {1, 80},
  {1, 95},                                                /* End of row  41 */
  {2, 74},
  {1, 66},
  {1, 73},
  {4, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 220},
  {1, 63},
  {2, 51},
  {1, 64},
  {1, 117},
  {1, 221},
  {1, 222},
  {1, 235},
  {3, 255},
  {1, 227},
  {2, 222},
  {1, 149},
  {2, 51},
  {1, 76},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {1, 222},
  {1, 167},
  {3, 51},
  {1, 157},
  {2, 222},
  {1, 243},
  {4, 255},
  {1, 243},
  {2, 222},
  {1, 149},
  {2, 51},
  {1, 61},
  {16, 74},
  {1, 81},
  {1, 118},
  {1, 77},                                                /* End of row  42 */
  {3, 74},
  {1, 66},
  {1, 73},
  {3, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 220},
  {1, 63},
  {2, 51},
  {1, 64},
  {1, 74},
  {1, 187},
  {1, 222},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 243},
  {2, 222},
  {1, 209},
  {1, 60},
  {1, 51},
  {1, 66},
  {1, 220},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {1, 222},
  {1, 167},
  {2, 51},
  {1, 60},
  {1, 210},
  {1, 222},
  {1, 227},
  {6, 255},
  {1, 227},
  {1, 222},
  {1, 209},
  {1, 60},
  {2, 51},
  {1, 71},
  {14, 74},
  {1, 81},
  {1, 118},
  {1, 77},
  {1, 74},                                                /* End of row  43 */
  {1, 0},
  {3, 74},
  {1, 66},
  {1, 73},
  {2, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 220},
  {1, 63},
  {2, 51},
  {1, 64},
  {1, 74},
  {1, 117},
  {1, 221},
  {1, 222},
  {1, 235},
  {3, 255},
  {1, 227},
  {2, 222},
  {1, 149},
  {1, 51},
  {1, 63},
  {1, 220},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {1, 222},
  {1, 167},
  {2, 51},
  {1, 149},
  {2, 222},
  {1, 243},
  {6, 255},
  {1, 243},
  {2, 222},
  {1, 149},
  {2, 51},
  {1, 61},
  {13, 74},
  {1, 81},
  {1, 118},
  {1, 77},
  {1, 74},
  {1, 0},                                                 /* End of row  44 */
  {2, 0},
  {3, 74},
  {1, 66},
  {1, 73},
  {1, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 220},
  {1, 63},
  {2, 51},
  {1, 64},
  {2, 74},
  {1, 187},
  {1, 222},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 243},
  {2, 222},
  {1, 209},
  {1, 60},
  {1, 63},
  {1, 220},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {1, 222},
  {1, 167},
  {1, 51},
  {1, 60},
  {1, 209},
  {1, 222},
  {1, 227},
  {3, 255},
  {1, 251},
  {1, 247},
  {3, 255},
  {1, 227},
  {1, 222},
  {1, 209},
  {1, 60},
  {2, 51},
  {1, 71},
  {11, 74},
  {1, 81},
  {1, 118},
  {1, 77},
  {1, 74},
  {2, 0},                                                 /* End of row  45 */
  {3, 0},
  {3, 74},
  {1, 66},
  {1, 73},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 220},
  {1, 63},
  {2, 51},
  {1, 64},
  {2, 74},
  {1, 117},
  {1, 221},
  {1, 222},
  {1, 235},
  {3, 255},
  {1, 227},
  {2, 222},
  {1, 149},
  {1, 63},
  {1, 220},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {1, 222},
  {1, 167},
  {1, 51},
  {1, 149},
  {2, 222},
  {1, 243},
  {3, 255},
  {1, 235},
  {1, 227},
  {3, 255},
  {1, 243},
  {2, 222},
  {1, 149},
  {2, 51},
  {1, 61},
  {10, 74},
  {1, 81},
  {1, 118},
  {1, 77},
  {1, 74},
  {3, 0},                                                 /* End of row  46 */
  {4, 0},
  {3, 74},
  {1, 66},
  {1, 82},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 220},
  {1, 63},
  {2, 51},
  {1, 64},
  {3, 74},
  {1, 187},
  {1, 222},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 243},
  {2, 222},
  {1, 209},
  {1, 69},
  {1, 220},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {1, 222},
  {1, 167},
  {1, 60},
  {1, 209},
  {1, 222},
  {1, 227},
  {3, 255},
  {1, 251},
  {1, 223},
  {1, 222},
  {1, 243},
  {3, 255},
  {1, 227},
  {1, 222},
  {1, 209},
  {1, 60},
  {2, 51},
  {1, 71},
  {8, 74},
  {1, 81},
  {1, 118},
  {1, 77},
  {1, 74},
  {4, 0},                                                 /* End of row  47 */
  {5, 0},
  {3, 74},
  {1, 75},
  {1, 220},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 220},
  {1, 63},
  {2, 51},
  {1, 64},
  {3, 74},
  {1, 117},
  {1, 221},
  {1, 222},
  {1, 235},
  {3, 255},
  {1, 227},
  {2, 222},
  {1, 152},
  {1, 220},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {1, 222},
  {1, 167},
  {1, 149},
  {2, 222},
  {1, 243},
  {3, 255},
  {1, 235},
  {2, 222},
  {1, 227},
  {3, 255},
  {1, 243},
  {2, 222},
  {1, 149},
  {2, 51},
  {1, 61},
  {7, 74},
  {1, 81},
  {1, 118},
  {1, 77},
  {1, 74},
  {5, 0},                                                 /* End of row  48 */
  {6, 0},
  {2, 74},
  {1, 83},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 220},
  {1, 63},
  {2, 51},
  {1, 64},
  {4, 74},
  {1, 187},
  {1, 222},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 243},
  {2, 222},
  {1, 211},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {1, 222},
  {1, 169},
  {1, 209},
  {1, 222},
  {1, 227},
  {3, 255},
  {1, 251},
  {1, 223},
  {3, 222},
  {1, 243},
  {3, 255},
  {1, 227},
  {1, 222},
  {1, 209},
  {1, 60},
  {2, 51},
  {1, 71},
  {5, 74},
  {1, 81},
  {1, 118},
  {1, 77},
  {1, 74},
  {6, 0},                                                 /* End of row  49 */
  {7, 0},
  {1, 74},
  {1, 85},
  {1, 221},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 220},
  {1, 63},
  {2, 51},
  {1, 64},
  {4, 74},
  {1, 117},
  {1, 221},
  {1, 222},
  {1, 235},
  {3, 255},
  {1, 227},
  {3, 222},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {1, 222},
  {1, 210},
  {2, 222},
  {1, 243},
  {3, 255},
  {1, 235},
  {1, 222},
  {1, 221},
  {1, 169},
  {1, 222},
  {1, 227},
  {3, 255},
  {1, 243},
  {2, 222},
  {1, 149},
  {2, 51},
  {1, 61},
  {4, 74},
  {1, 81},
  {1, 118},
  {1, 77},
  {1, 74},
  {7, 0},                                                 /* End of row  50 */
  {8, 0},
  {1, 138},
  {1, 222},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 220},
  {1, 63},
  {2, 51},
  {1, 64},
  {5, 74},
  {1, 187},
  {1, 222},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 243},
  {3, 222},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {3, 222},
  {1, 227},
  {3, 255},
  {1, 251},
  {1, 223},
  {1, 222},
  {1, 183},
  {1, 60},
  {1, 209},
  {1, 222},
  {1, 243},
  {3, 255},
  {1, 227},
  {1, 222},
  {1, 209},
  {1, 60},
  {2, 51},
  {1, 71},
  {2, 74},
  {1, 81},
  {1, 118},
  {1, 77},
  {1, 74},
  {8, 0},                                                 /* End of row  51 */
  {8, 0},
  {2, 222},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 220},
  {1, 63},
  {2, 51},
  {1, 64},
  {5, 74},
  {1, 117},
  {1, 221},
  {1, 222},
  {1, 235},
  {3, 255},
  {1, 227},
  {2, 222},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {3, 222},
  {1, 243},
  {3, 255},
  {1, 235},
  {1, 222},
  {1, 221},
  {1, 103},
  {1, 51},
  {1, 149},
  {1, 222},
  {1, 227},
  {3, 255},
  {1, 243},
  {2, 222},
  {1, 149},
  {2, 51},
  {1, 61},
  {1, 74},
  {1, 81},
  {1, 118},
  {1, 77},
  {1, 74},
  {9, 0},                                                 /* End of row  52 */
  {8, 0},
  {2, 222},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 220},
  {1, 63},
  {2, 51},
  {1, 64},
  {6, 74},
  {1, 187},
  {1, 222},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 243},
  {2, 222},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {2, 222},
  {1, 227},
  {3, 255},
  {1, 251},
  {1, 223},
  {1, 222},
  {1, 183},
  {2, 51},
  {1, 60},
  {1, 209},
  {1, 222},
  {1, 243},
  {3, 255},
  {1, 227},
  {1, 222},
  {1, 209},
  {1, 60},
  {2, 51},
  {1, 78},
  {1, 118},
  {1, 77},
  {1, 74},
  {10, 0},                                                /* End of row  53 */
  {8, 0},
  {2, 222},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 220},
  {1, 63},
  {2, 51},
  {1, 64},
  {6, 74},
  {1, 117},
  {1, 221},
  {1, 222},
  {1, 235},
  {3, 255},
  {1, 227},
  {1, 222},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {2, 222},
  {1, 243},
  {3, 255},
  {1, 235},
  {1, 222},
  {1, 221},
  {1, 103},
  {2, 51},
  {1, 55},
  {1, 157},
  {1, 222},
  {1, 227},
  {3, 255},
  {1, 243},
  {2, 222},
  {1, 149},
  {2, 51},
  {2, 77},
  {1, 74},
  {11, 0},                                                /* End of row  54 */
  {8, 0},
  {2, 222},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 220},
  {1, 63},
  {2, 51},
  {1, 64},
  {7, 74},
  {1, 187},
  {1, 222},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 243},
  {1, 222},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {1, 222},
  {1, 227},
  {3, 255},
  {1, 251},
  {1, 223},
  {1, 222},
  {1, 183},
  {3, 51},
  {1, 67},
  {1, 81},
  {1, 210},
  {1, 222},
  {1, 243},
  {3, 255},
  {1, 227},
  {1, 222},
  {1, 209},
  {1, 60},
  {1, 53},
  {1, 114},
  {1, 130},
  {12, 0},                                                /* End of row  55 */
  {8, 0},
  {2, 222},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 220},
  {1, 63},
  {2, 51},
  {1, 64},
  {7, 74},
  {1, 117},
  {1, 221},
  {1, 222},
  {1, 235},
  {3, 255},
  {1, 227},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {1, 222},
  {1, 243},
  {3, 255},
  {1, 235},
  {1, 222},
  {1, 221},
  {1, 103},
  {2, 51},
  {1, 55},
  {2, 74},
  {1, 157},
  {1, 222},
  {1, 227},
  {3, 255},
  {1, 243},
  {2, 222},
  {1, 150},
  {1, 114},
  {3, 137},
  {11, 0},                                                /* End of row  56 */
  {8, 0},
  {2, 222},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 220},
  {1, 63},
  {2, 51},
  {1, 64},
  {8, 74},
  {1, 187},
  {1, 222},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 243},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 240},
  {1, 227},
  {3, 255},
  {1, 251},
  {1, 223},
  {1, 222},
  {1, 183},
  {3, 51},
  {1, 67},
  {2, 74},
  {1, 81},
  {1, 210},
  {1, 222},
  {1, 243},
  {3, 255},
  {1, 227},
  {1, 222},
  {1, 213},
  {1, 139},
  {3, 137},
  {11, 0},                                                /* End of row  57 */
  {8, 0},
  {2, 222},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 220},
  {1, 63},
  {2, 51},
  {1, 64},
  {8, 74},
  {1, 117},
  {1, 221},
  {1, 222},
  {1, 235},
  {3, 255},
  {1, 228},
  {1, 254},
  {2, 255},
  {1, 240},
  {1, 243},
  {3, 255},
  {1, 235},
  {1, 222},
  {1, 221},
  {1, 103},
  {2, 51},
  {1, 55},
  {4, 74},
  {1, 157},
  {1, 222},
  {1, 227},
  {3, 255},
  {1, 243},
  {2, 222},
  {1, 176},
  {4, 137},
  {10, 0},                                                /* End of row  58 */
  {8, 0},
  {2, 222},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 220},
  {1, 85},
  {2, 51},
  {1, 64},
  {9, 74},
  {1, 187},
  {1, 222},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 244},
  {1, 254},
  {2, 255},
  {1, 244},
  {3, 255},
  {1, 251},
  {1, 223},
  {1, 222},
  {1, 183},
  {3, 51},
  {1, 67},
  {4, 74},
  {1, 81},
  {1, 210},
  {1, 222},
  {1, 243},
  {3, 255},
  {1, 227},
  {1, 222},
  {1, 213},
  {1, 139},
  {3, 137},
  {10, 0},                                                /* End of row  59 */
  {8, 0},
  {2, 222},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 221},
  {1, 135},
  {1, 79},
  {1, 51},
  {1, 58},
  {1, 73},
  {8, 74},
  {1, 117},
  {1, 221},
  {1, 222},
  {1, 235},
  {10, 255},
  {1, 235},
  {1, 222},
  {1, 221},
  {1, 103},
  {2, 51},
  {1, 55},
  {6, 74},
  {1, 157},
  {1, 222},
  {1, 227},
  {3, 255},
  {1, 243},
  {2, 222},
  {1, 176},
  {4, 137},
  {9, 0},                                                 /* End of row  60 */
  {8, 0},
  {2, 222},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 221},
  {1, 139},
  {1, 133},
  {1, 79},
  {1, 64},
  {1, 66},
  {1, 73},
  {8, 74},
  {1, 187},
  {1, 222},
  {1, 223},
  {1, 251},
  {8, 255},
  {1, 251},
  {1, 223},
  {1, 222},
  {1, 183},
  {3, 51},
  {1, 67},
  {6, 74},
  {1, 87},
  {1, 214},
  {1, 222},
  {1, 243},
  {3, 255},
  {1, 227},
  {1, 222},
  {1, 213},
  {1, 139},
  {3, 137},
  {9, 0},                                                 /* End of row  61 */
  {8, 0},
  {2, 222},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 221},
  {1, 139},
  {1, 137},
  {1, 133},
  {1, 89},
  {1, 74},
  {1, 66},
  {1, 73},
  {7, 74},
  {1, 117},
  {1, 221},
  {1, 222},
  {1, 235},
  {8, 255},
  {1, 235},
  {1, 222},
  {1, 221},
  {1, 103},
  {2, 51},
  {1, 55},
  {6, 74},
  {1, 81},
  {1, 118},
  {1, 162},
  {1, 222},
  {1, 227},
  {3, 255},
  {1, 243},
  {2, 222},
  {1, 176},
  {4, 137},
  {8, 0},                                                 /* End of row  62 */
  {8, 0},
  {2, 222},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 221},
  {1, 139},
  {2, 137},
  {1, 131},
  {2, 74},
  {1, 66},
  {1, 73},
  {7, 74},
  {1, 187},
  {1, 222},
  {1, 223},
  {1, 251},
  {6, 255},
  {1, 251},
  {1, 223},
  {1, 222},
  {1, 183},
  {3, 51},
  {1, 67},
  {5, 74},
  {1, 81},
  {1, 118},
  {1, 77},
  {1, 170},
  {2, 222},
  {1, 243},
  {3, 255},
  {1, 227},
  {1, 222},
  {1, 213},
  {1, 139},
  {3, 137},
  {8, 0},                                                 /* End of row  63 */
  {8, 0},
  {2, 222},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 221},
  {1, 139},
  {3, 137},
  {3, 74},
  {1, 66},
  {1, 73},
  {6, 74},
  {1, 117},
  {1, 221},
  {1, 222},
  {1, 235},
  {6, 255},
  {1, 235},
  {1, 222},
  {1, 221},
  {1, 103},
  {2, 51},
  {1, 55},
  {5, 74},
  {1, 81},
  {1, 118},
  {1, 77},
  {1, 74},
  {1, 0},
  {2, 222},
  {1, 227},
  {3, 255},
  {1, 243},
  {2, 222},
  {1, 176},
  {4, 137},
  {7, 0},                                                 /* End of row  64 */
  {8, 0},
  {2, 222},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 221},
  {1, 139},
  {3, 137},
  {1, 0},
  {3, 74},
  {1, 66},
  {1, 73},
  {6, 74},
  {1, 187},
  {1, 222},
  {1, 223},
  {1, 251},
  {4, 255},
  {1, 251},
  {1, 223},
  {1, 222},
  {1, 183},
  {3, 51},
  {1, 67},
  {4, 74},
  {1, 81},
  {1, 118},
  {1, 77},
  {1, 74},
  {2, 0},
  {3, 222},
  {1, 243},
  {3, 255},
  {1, 227},
  {1, 222},
  {1, 213},
  {1, 139},
  {3, 137},
  {7, 0},                                                 /* End of row  65 */
  {8, 0},
  {2, 222},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 221},
  {1, 139},
  {3, 137},
  {2, 0},
  {3, 74},
  {1, 66},
  {1, 73},
  {5, 74},
  {1, 117},
  {1, 221},
  {1, 222},
  {1, 235},
  {4, 255},
  {1, 235},
  {1, 222},
  {1, 221},
  {1, 103},
  {2, 51},
  {1, 55},
  {4, 74},
  {1, 81},
  {1, 118},
  {1, 77},
  {1, 74},
  {4, 0},
  {2, 222},
  {1, 227},
  {3, 255},
  {1, 243},
  {2, 222},
  {1, 164},
  {3, 137},
  {7, 0},                                                 /* End of row  66 */
  {8, 0},
  {2, 222},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 221},
  {1, 139},
  {3, 137},
  {3, 0},
  {3, 74},
  {1, 66},
  {1, 73},
  {5, 74},
  {1, 187},
  {1, 222},
  {1, 223},
  {1, 251},
  {2, 255},
  {1, 251},
  {1, 223},
  {1, 222},
  {1, 183},
  {3, 51},
  {1, 67},
  {3, 74},
  {1, 81},
  {1, 118},
  {1, 77},
  {1, 74},
  {5, 0},
  {3, 222},
  {1, 243},
  {2, 255},
  {1, 247},
  {2, 222},
  {1, 159},
  {4, 137},
  {6, 0},                                                 /* End of row  67 */
  {8, 0},
  {2, 222},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 221},
  {1, 139},
  {3, 137},
  {4, 0},
  {3, 74},
  {1, 66},
  {1, 73},
  {4, 74},
  {1, 117},
  {1, 221},
  {1, 222},
  {1, 229},
  {2, 251},
  {1, 229},
  {1, 222},
  {1, 221},
  {1, 103},
  {2, 51},
  {1, 55},
  {3, 74},
  {1, 81},
  {1, 118},
  {1, 77},
  {1, 74},
  {7, 0},
  {2, 222},
  {1, 227},
  {2, 251},
  {1, 232},
  {1, 222},
  {1, 213},
  {1, 138},
  {4, 137},
  {6, 0},                                                 /* End of row  68 */
  {8, 0},
  {2, 222},
  {1, 223},
  {1, 254},
  {2, 255},
  {1, 254},
  {1, 223},
  {1, 221},
  {1, 139},
  {3, 137},
  {5, 0},
  {3, 74},
  {1, 66},
  {1, 73},
  {4, 74},
  {1, 187},
  {2, 222},
  {2, 223},
  {2, 222},
  {1, 183},
  {3, 51},
  {1, 67},
  {2, 74},
  {1, 81},
  {1, 118},
  {1, 77},
  {1, 74},
  {8, 0},
  {3, 222},
  {2, 223},
  {1, 222},
  {1, 221},
  {1, 172},
  {5, 137},
  {6, 0},                                                 /* End of row  69 */
  {8, 0},
  {2, 222},
  {1, 223},
  {2, 254},
  {2, 253},
  {1, 222},
  {1, 219},
  {1, 139},
  {3, 137},
  {6, 0},
  {3, 74},
  {1, 66},
  {1, 73},
  {3, 74},
  {1, 115},
  {1, 216},
  {4, 222},
  {1, 215},
  {1, 102},
  {2, 51},
  {1, 55},
  {2, 74},
  {1, 81},
  {1, 118},
  {1, 77},
  {1, 74},
  {10, 0},
  {4, 222},
  {1, 217},
  {1, 176},
  {5, 137},
  {7, 0},                                                 /* End of row  70 */
  {9, 0},
  {1, 222},
  {1, 223},
  {1, 255},
  {1, 145},
  {2, 141},
  {2, 139},
  {4, 137},
  {7, 0},
  {3, 74},
  {1, 66},
  {1, 73},
  {3, 74},
  {1, 115},
  {1, 187},
  {2, 220},
  {1, 183},
  {1, 102},
  {3, 51},
  {1, 68},
  {1, 74},
  {1, 81},
  {1, 118},
  {1, 77},
  {1, 74},
  {12, 0},
  {2, 222},
  {1, 172},
  {1, 139},
  {6, 137},
  {7, 0},                                                 /* End of row  71 */
  {12, 0},
  {9, 137},
  {8, 0},
  {3, 74},
  {1, 66},
  {1, 73},
  {4, 74},
  {1, 81},
  {1, 71},
  {1, 52},
  {2, 51},
  {1, 58},
  {1, 69},
  {1, 74},
  {1, 81},
  {1, 118},
  {1, 77},
  {1, 74},
  {15, 0},
  {7, 137},
  {8, 0},                                                 /* End of row  72 */
  {12, 0},
  {9, 137},
  {9, 0},
  {3, 74},
  {1, 66},
  {1, 73},
  {10, 74},
  {1, 81},
  {1, 118},
  {1, 77},
  {1, 74},
  {17, 0},
  {5, 137},
  {9, 0},                                                 /* End of row  73 */
  {12, 0},
  {9, 137},
  {10, 0},
  {3, 74},
  {1, 66},
  {1, 73},
  {8, 74},
  {1, 81},
  {1, 118},
  {1, 77},
  {1, 74},
  {32, 0},                                                /* End of row  74 */
  {32, 0},
  {3, 74},
  {1, 66},
  {1, 73},
  {6, 74},
  {1, 81},
  {1, 118},
  {1, 77},
  {1, 74},
  {33, 0},                                                /* End of row  75 */
  {33, 0},
  {3, 74},
  {1, 66},
  {1, 73},
  {4, 74},
  {1, 81},
  {1, 118},
  {1, 77},
  {1, 74},
  {34, 0},                                                /* End of row  76 */
  {34, 0},
  {3, 74},
  {1, 66},
  {1, 73},
  {2, 74},
  {1, 81},
  {1, 118},
  {1, 77},
  {1, 74},
  {35, 0},                                                /* End of row  77 */
  {35, 0},
  {3, 74},
  {1, 66},
  {1, 73},
  {1, 81},
  {1, 118},
  {1, 77},
  {1, 74},
  {36, 0},                                                /* End of row  78 */
  {36, 0},
  {3, 74},
  {1, 78},
  {1, 118},
  {1, 77},
  {1, 74},
  {37, 0},                                                /* End of row  79 */
  {37, 0},
  {2, 74},
  {1, 92},
  {1, 77},
  {1, 74},
  {38, 0},                                                /* End of row  80 */
};
#endif /* CONFIG_VIDEO_FB_SPLASHSCREEN_GREY */

#ifdef CONFIG_VIDEO_FB_SPLASHSCREEN_MONO
static const struct splscr_bitmap_s bitmap[] =
{
  {37, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {37, 0},                                                /* End of row   1 */
  {36, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {39, 0},                                                /* End of row   2 */
  {35, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {36, 0},                                                /* End of row   3 */
  {34, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {34, 0},                                                /* End of row   4 */
  {33, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {37, 0},                                                /* End of row   5 */
  {32, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {32, 0},                                                /* End of row   6 */
  {31, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {37, 0},                                                /* End of row   7 */
  {30, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {31, 0},                                                /* End of row   8 */
  {29, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {14, 0},
  {3, 255},
  {13, 0},                                                /* End of row   9 */
  {28, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {14, 0},
  {6, 255},
  {11, 0},                                                /* End of row  10 */
  {11, 0},
  {5, 255},
  {11, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {9, 0},
  {3, 255},
  {1, 0},
  {4, 255},
  {10, 0},                                                /* End of row  11 */
  {10, 0},
  {7, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {7, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {15, 0},
  {6, 255},
  {1, 0},
  {2, 255},
  {9, 0},                                                 /* End of row  12 */
  {9, 0},
  {3, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {7, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {9, 255},
  {1, 0},
  {1, 255},
  {8, 0},                                                 /* End of row  13 */
  {9, 0},
  {9, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {8, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {9, 0},
  {2, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {1, 255},
  {7, 0},                                                 /* End of row  14 */
  {8, 0},
  {10, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {6, 255},
  {1, 0},
  {2, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {9, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},                                                 /* End of row  15 */
  {8, 0},
  {2, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {7, 0},
  {10, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {10, 255},
  {1, 0},
  {1, 255},
  {8, 0},                                                 /* End of row  16 */
  {8, 0},
  {11, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {10, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {3, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},                                                 /* End of row  17 */
  {8, 0},
  {12, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {8, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {11, 255},
  {1, 0},
  {1, 255},
  {8, 0},                                                 /* End of row  18 */
  {8, 0},
  {2, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {10, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {8, 0},                                                 /* End of row  19 */
  {8, 0},
  {13, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {11, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {8, 0},                                                 /* End of row  20 */
  {8, 0},
  {13, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {1, 0},
  {10, 255},
  {1, 0},
  {1, 255},
  {10, 0},                                                /* End of row  21 */
  {8, 0},
  {2, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {12, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {9, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {9, 0},                                                 /* End of row  22 */
  {8, 0},
  {14, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {14, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {10, 0},                                                /* End of row  23 */
  {8, 0},
  {14, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {11, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {8, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {11, 0},                                                /* End of row  24 */
  {8, 0},
  {2, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {2, 255},
  {7, 0},
  {1, 255},
  {4, 0},
  {6, 255},
  {1, 0},
  {7, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {10, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {11, 0},                                                /* End of row  25 */
  {8, 0},
  {16, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {12, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {11, 0},                                                /* End of row  26 */
  {8, 0},
  {16, 255},
  {6, 0},
  {1, 255},
  {4, 0},
  {15, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {10, 255},
  {3, 0},
  {1, 255},
  {12, 0},                                                /* End of row  27 */
  {8, 0},
  {2, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {7, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {13, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {2, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {15, 0},                                                /* End of row  28 */
  {8, 0},
  {14, 255},
  {1, 0},
  {2, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {7, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {9, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {11, 0},                                                /* End of row  29 */
  {8, 0},
  {18, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {16, 255},
  {2, 0},
  {8, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {9, 0},                                                 /* End of row  30 */
  {7, 0},
  {1, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {9, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {7, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {9, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {11, 0},                                                /* End of row  31 */
  {6, 0},
  {1, 255},
  {2, 0},
  {15, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {11, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},                                                 /* End of row  32 */
  {5, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {9, 255},
  {8, 0},
  {7, 255},
  {1, 0},
  {17, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {10, 0},                                                /* End of row  33 */
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {10, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {8, 255},
  {2, 0},
  {9, 255},
  {1, 0},
  {7, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},                                                 /* End of row  34 */
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {8, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {8, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {4, 0},                                                 /* End of row  35 */
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {8, 255},
  {2, 0},
  {10, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {7, 255},
  {3, 0},
  {7, 255},
  {1, 0},
  {7, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},                                                 /* End of row  36 */
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {8, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {9, 255},
  {2, 0},
  {14, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {3, 0},                                                 /* End of row  37 */
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {8, 255},
  {2, 0},
  {11, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {4, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {12, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},                                                 /* End of row  38 */
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {6, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {8, 255},
  {5, 0},
  {8, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {10, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},                                               /* End of row  39 */
  {1, 0},
  {1, 255},
  {7, 0},
  {8, 255},
  {3, 0},
  {8, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {8, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {9, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},                                                 /* End of row  40 */
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {7, 255},
  {4, 0},
  {8, 255},
  {3, 0},
  {11, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},                                                 /* End of row  41 */
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {9, 255},
  {5, 0},
  {9, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {7, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {11, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},                                                 /* End of row  42 */
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {7, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {2, 255},
  {3, 0},
  {8, 255},
  {3, 0},
  {10, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},                                                 /* End of row  43 */
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {8, 255},
  {6, 0},
  {10, 255},
  {2, 0},
  {7, 255},
  {3, 0},
  {14, 255},
  {3, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},                                                 /* End of row  44 */
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {8, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {2, 255},
  {1, 0},
  {7, 255},
  {2, 0},
  {8, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {10, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {8, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},                                                 /* End of row  45 */
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {8, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {10, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {15, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},                                                 /* End of row  46 */
  {6, 0},
  {1, 255},
  {2, 0},
  {8, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {7, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {6, 0},                                                 /* End of row  47 */
  {7, 0},
  {1, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {10, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {15, 255},
  {1, 0},
  {2, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},                                                 /* End of row  48 */
  {8, 0},
  {9, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {17, 255},
  {1, 0},
  {17, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},                                                 /* End of row  49 */
  {7, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {8, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {9, 0},                                                 /* End of row  50 */
  {9, 0},
  {8, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {18, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {11, 0},                                                /* End of row  51 */
  {8, 0},
  {9, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {25, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {9, 0},                                                 /* End of row  52 */
  {8, 0},
  {9, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {9, 255},
  {3, 0},
  {1, 255},
  {13, 0},                                                /* End of row  53 */
  {8, 0},
  {8, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {7, 255},
  {1, 0},
  {15, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {9, 255},
  {4, 0},
  {1, 255},
  {12, 0},                                                /* End of row  54 */
  {8, 0},
  {2, 255},
  {1, 0},
  {6, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {21, 255},
  {6, 0},
  {9, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {12, 0},                                                /* End of row  55 */
  {8, 0},
  {9, 255},
  {6, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {11, 255},
  {1, 0},
  {5, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {12, 0},                                                /* End of row  56 */
  {8, 0},
  {9, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {7, 255},
  {1, 0},
  {12, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {6, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {11, 0},                                                /* End of row  57 */
  {8, 0},
  {2, 255},
  {1, 0},
  {6, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {15, 255},
  {3, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {10, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {10, 0},                                                /* End of row  58 */
  {8, 0},
  {9, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {18, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {10, 255},
  {1, 0},
  {1, 255},
  {11, 0},                                                /* End of row  59 */
  {8, 0},
  {9, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {14, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {10, 0},                                                /* End of row  60 */
  {8, 0},
  {2, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {16, 255},
  {5, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {2, 255},
  {9, 0},                                                 /* End of row  61 */
  {8, 0},
  {9, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {13, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {9, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {8, 0},                                                 /* End of row  62 */
  {8, 0},
  {9, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {12, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {2, 255},
  {9, 0},                                                 /* End of row  63 */
  {8, 0},
  {2, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {11, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {4, 0},
  {7, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},                                                 /* End of row  64 */
  {8, 0},
  {9, 255},
  {1, 0},
  {2, 255},
  {6, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {3, 0},
  {11, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {10, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},                                                 /* End of row  65 */
  {8, 0},
  {9, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {8, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {10, 255},
  {1, 0},
  {1, 255},
  {8, 0},                                                 /* End of row  66 */
  {8, 0},
  {2, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {2, 255},
  {1, 0},
  {7, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {7, 0},                                                 /* End of row  67 */
  {8, 0},
  {9, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {8, 255},
  {4, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {9, 0},
  {8, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},                                                 /* End of row  68 */
  {8, 0},
  {9, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {5, 0},
  {5, 255},
  {1, 0},
  {2, 255},
  {2, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {10, 0},
  {3, 255},
  {1, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {6, 0},                                                 /* End of row  69 */
  {8, 0},
  {2, 255},
  {1, 0},
  {6, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {9, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {3, 255},
  {5, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {10, 0},
  {4, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},                                                 /* End of row  70 */
  {9, 0},
  {3, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {7, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {3, 0},
  {4, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {14, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {8, 0},                                                 /* End of row  71 */
  {12, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {10, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {10, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {15, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {8, 0},                                                 /* End of row  72 */
  {13, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {2, 255},
  {13, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {19, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {9, 0},                                                 /* End of row  73 */
  {12, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {10, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {5, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {32, 0},                                                /* End of row  74 */
  {37, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {34, 0},                                                /* End of row  75 */
  {33, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {4, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {36, 0},                                                /* End of row  76 */
  {36, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {35, 0},                                                /* End of row  77 */
  {39, 0},
  {1, 255},
  {1, 0},
  {1, 255},
  {38, 0},                                                /* End of row  78 */
  {36, 0},
  {1, 255},
  {3, 0},
  {1, 255},
  {39, 0},                                                /* End of row  79 */
  {38, 0},
  {1, 255},
  {2, 0},
  {1, 255},
  {38, 0},                                                /* End of row  80 */
};
#endif /* CONFIG_VIDEO_FB_SPLASHSCREEN_MONO */

const struct palette_bitmap_s g_splscr =
{
  80,                  /* width in pixels                                   */
  80,                  /* height in pixels                                  */
  palette,             /* Colour palette                                    */
  bitmap,              /* Pointer to the start of the RLE data              */
};

/****************************************************************************
 * Private Functions
 ****************************************************************************/
