/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.io.http;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.remote.Transaction;
import org.apache.nifi.remote.io.http.HttpCommunicationsSession;
import org.apache.nifi.remote.protocol.HandshakeProperty;
import org.apache.nifi.remote.protocol.ResponseCode;

public class HttpServerCommunicationsSession
extends HttpCommunicationsSession {
    private final Map<String, String> handshakeParams = new HashMap<String, String>();
    private final String transactionId;
    private Transaction.TransactionState status = Transaction.TransactionState.TRANSACTION_STARTED;
    private ResponseCode responseCode;

    public HttpServerCommunicationsSession(InputStream inputStream, OutputStream outputStream, String transactionId, String userDn) {
        this.input.setInputStream(inputStream);
        this.output.setOutputStream(outputStream);
        this.transactionId = transactionId;
        this.setUserDn(userDn);
    }

    public Transaction.TransactionState getStatus() {
        return this.status;
    }

    public void setStatus(Transaction.TransactionState status) {
        this.status = status;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public ResponseCode getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(ResponseCode responseCode) {
        this.responseCode = responseCode;
    }

    public void putHandshakeParam(HandshakeProperty key, String value) {
        this.handshakeParams.put(key.name(), value);
    }

    public Map<String, String> getHandshakeParams() {
        return this.handshakeParams;
    }
}

