"use strict";
/*! Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Request test, testing on the 2.3 namespace fallback code
 *
 */
const mocha_1 = require("mocha");
const sinon = __importStar(require("sinon"));
const chai_1 = require("chai");
const StandardInits_1 = require("../frameworkBase/_ext/shared/StandardInits");
const mona_dish_1 = require("mona-dish");
const Const_1 = require("../../impl/core/Const");
;
/**
 * wherever we reference the namespaces they must be mapped to javax instead of jakarta
 */
function remapNamespacesFor23() {
    const P_PARTIAL_SOURCE = "javax.faces.source";
    const P_VIEWSTATE = "javax.faces.ViewState";
    const P_VIEWROOT = "javax.faces.ViewRoot";
    const P_VIEWHEAD = "javax.faces.ViewHead";
    const P_VIEWBODY = "javax.faces.ViewBody";
    const P_AJAX = "javax.faces.partial.ajax";
    const P_EXECUTE = "javax.faces.partial.execute";
    const P_RENDER = "javax.faces.partial.render";
    const P_EVT = "javax.faces.partial.event";
    const P_CLIENT_WINDOW = "javax.faces.ClientWindow";
    const P_RESET_VALUES = "javax.faces.partial.resetValues";
    const P_WINDOW_ID = "javax.faces.windowId";
    const ENCODED_URL = "javax.faces.encodedURL";
    return {
        P_PARTIAL_SOURCE, P_VIEWSTATE, P_VIEWROOT, P_VIEWHEAD, P_VIEWBODY,
        P_AJAX, P_EXECUTE, P_RENDER, P_EVT, P_CLIENT_WINDOW, P_RESET_VALUES,
        P_WINDOW_ID, ENCODED_URL
    };
}
let { P_PARTIAL_SOURCE, P_VIEWSTATE, P_AJAX, P_EXECUTE, P_RENDER, P_WINDOW_ID } = remapNamespacesFor23();
var STD_XML = StandardInits_1.StandardInits.STD_XML;
var defaultMyFaces23 = StandardInits_1.StandardInits.defaultMyFaces23;
var HTML_PREFIX_EMBEDDED_BODY = StandardInits_1.StandardInits.HTML_PREFIX_EMBEDDED_BODY;
let issueStdReq = function (element) {
    jsf.ajax.request(element, null, {
        execute: "input_1",
        render: "@form",
        pass1: "pass1",
        pass2: "pass2"
    });
};
/**
 * specialized tests testing the xhr core behavior when it hits the xmlHttpRequest object
 */
(0, mocha_1.describe)('Tests on the xhr core when it starts to call the request', function () {
    beforeEach(function () {
        return __awaiter(this, void 0, void 0, function* () {
            let waitForResult = defaultMyFaces23();
            return waitForResult.then((close) => {
                this.xhr = sinon.useFakeXMLHttpRequest();
                this.requests = [];
                this.xhr.onCreate = (xhr) => {
                    this.requests.push(xhr);
                };
                global.XMLHttpRequest = this.xhr;
                window.XMLHttpRequest = this.xhr;
                this.jsfAjaxResponse = sinon.spy(global.jsf.ajax, "response");
                this.closeIt = () => {
                    global.XMLHttpRequest = window.XMLHttpRequest = this.xhr.restore();
                    this.jsfAjaxResponse.restore();
                    Implementation.reset();
                    close();
                };
            });
        });
    });
    afterEach(function () {
        this.closeIt();
    });
    (0, mocha_1.it)('must have the standard parameters all in', function (done) {
        //issue a standard jsf.ajax.request upon the standard simple form case and check the passed parameters
        //and whether send was called
        let send = sinon.spy(XMLHttpRequest.prototype, "send");
        try {
            let element = mona_dish_1.DomQuery.byId("input_2").getAsElem(0).value;
            issueStdReq(element);
            (0, chai_1.expect)(this.requests.length).to.eq(1);
            (0, chai_1.expect)(this.requests[0].method).to.eq("POST");
            (0, chai_1.expect)(this.requests[0].async).to.be.true;
            (0, chai_1.expect)(send.called).to.be.true;
            (0, chai_1.expect)(send.callCount).to.eq(1);
            //sent params jakarta.jsf.ViewState=null&execute=input_1&render=%40form&pass1=pass1&pass2=pass2&jakarta.jsf.windowId=null&jakarta.jsf.source=input_2&jakarta.jsf.partial.ajax=input_2&blarg=blarg&jakarta.jsf.partial.execute=input_1%20input_2&jakarta.jsf.partial.render=blarg
        }
        finally {
            send.restore();
        }
        done();
    });
    (0, mocha_1.it)('it must have the pass through values properly passed', function (done) {
        let send = sinon.spy(XMLHttpRequest.prototype, "send");
        try {
            let element = mona_dish_1.DomQuery.byId("input_2").getAsElem(0).value;
            issueStdReq(element);
            (0, chai_1.expect)(send.called).to.be.true;
            let argsVal = send.args[0][0];
            let arsArr = argsVal.split("&");
            let resultsMap = {};
            for (let val of arsArr) {
                let keyVal = val.split("=");
                resultsMap[keyVal[0]] = keyVal[1];
            }
            (0, chai_1.expect)(resultsMap["pass1"]).to.eq("pass1");
            (0, chai_1.expect)(resultsMap["pass2"]).to.eq("pass2");
            (0, chai_1.expect)(!!resultsMap["render"]).to.be.false;
            (0, chai_1.expect)(!!resultsMap["execute"]).to.be.false;
            (0, chai_1.expect)(P_WINDOW_ID in resultsMap).to.be.false;
            (0, chai_1.expect)(P_VIEWSTATE in resultsMap).to.be.true;
            (0, chai_1.expect)(resultsMap[P_PARTIAL_SOURCE]).to.eq("input_2");
            (0, chai_1.expect)(resultsMap[P_AJAX]).to.eq("true");
            (0, chai_1.expect)(resultsMap[P_RENDER]).to.eq("blarg");
            (0, chai_1.expect)(resultsMap[P_EXECUTE]).to.eq("input_1%20input_2");
        }
        finally {
            send.restore();
        }
        done();
    });
    (0, mocha_1.it)('it must have the proper target type', function (done) {
        let send = sinon.spy(XMLHttpRequest.prototype, "send");
        try {
            let element = mona_dish_1.DomQuery.byId("input_2").getAsElem(0).value;
            issueStdReq(element);
            (0, chai_1.expect)(this.requests[0].requestHeaders.Accept.indexOf("application/xml") != -1).to.be.true;
        }
        finally {
            send.restore();
        }
        done();
    });
});
(0, mocha_1.describe)('Tests after core when it hits response', function () {
    beforeEach(function () {
        return __awaiter(this, void 0, void 0, function* () {
            let waitForResult = defaultMyFaces23();
            return waitForResult.then((close) => {
                this.xhr = sinon.useFakeXMLHttpRequest();
                this.requests = [];
                this.xhr.onCreate = (xhr) => {
                    this.requests.push(xhr);
                };
                global.XMLHttpRequest = this.xhr = sinon.useFakeXMLHttpRequest();
                // @ts-ignore
                window.XMLHttpRequest = this.xhr = sinon.useFakeXMLHttpRequest();
                this.jsfAjaxResponse = sinon.spy(global.jsf.ajax, "response");
                this.closeIt = () => {
                    global.XMLHttpRequest = window.XMLHttpRequest = this.xhr.restore();
                    this.jsfAjaxResponse.restore();
                    Implementation.reset();
                    close();
                };
            });
        });
    });
    afterEach(function () {
        this.closeIt();
    });
    (0, mocha_1.it)('must have passed all ajax request phase events', function (done) {
        let send = sinon.spy(XMLHttpRequest.prototype, "send");
        let globalCnt = 0;
        let localCnt = 0;
        try {
            let element = mona_dish_1.DomQuery.byId("input_2").getAsElem(0).value;
            jsf.ajax.addOnEvent(() => {
                globalCnt++;
            });
            jsf.ajax.request(element, null, {
                execute: "input_1",
                render: "@form",
                pass1: "pass1",
                pass2: "pass2",
                onevent: () => {
                    localCnt++;
                }
            });
            let xhrReq = this.requests[0];
            xhrReq.respond(200, { 'Content-Type': 'text/xml' }, STD_XML);
            (0, chai_1.expect)(this.jsfAjaxResponse.callCount).to.eq(1);
            //success ommitted due to fake response
            (0, chai_1.expect)(globalCnt == 3).to.eq(true);
            (0, chai_1.expect)(localCnt == 3).to.eq(true);
            done();
        }
        catch (e) {
            console.error(e);
        }
        finally {
            send.restore();
        }
    });
    (0, mocha_1.it)('it must have called request and the pass through values must be properly transferred into the context', function (done) {
        let send = sinon.spy(XMLHttpRequest.prototype, "send");
        let globalCnt = 0;
        let localCnt = 0;
        let xhrReq = null;
        try {
            let element = mona_dish_1.DomQuery.byId("input_2").getAsElem(0).value;
            jsf.ajax.addOnEvent(() => {
                globalCnt++;
            });
            jsf.ajax.request(element, null, {
                execute: "input_1",
                render: "@form",
                pass1: "pass1",
                pass2: "pass2",
                onevent: (evt) => {
                    localCnt++;
                    if (evt.status == Const_1.COMPLETE) {
                        (0, chai_1.expect)(!!xhrReq.responseXML).to.be.true;
                    }
                    if (evt.status == Const_1.SUCCESS) {
                        (0, chai_1.expect)(this.jsfAjaxResponse.callCount).to.eq(1);
                        (0, chai_1.expect)(this.jsfAjaxResponse.firstCall.args[0] instanceof XMLHttpRequest).to.be.true;
                        let lastArg = this.jsfAjaxResponse.firstCall.args[1];
                        (0, chai_1.expect)(lastArg.onevent != null).to.be.true;
                        (0, chai_1.expect)(lastArg.onevent instanceof Function).to.be.true;
                        (0, chai_1.expect)(!!lastArg.onError).to.be.false;
                        (0, chai_1.expect)(lastArg.pass1 == "pass1").to.be.true;
                        (0, chai_1.expect)(lastArg.pass2 == "pass2").to.be.true;
                        (0, chai_1.expect)(!!lastArg[P_PARTIAL_SOURCE]).to.be.true;
                        (0, chai_1.expect)(!!lastArg[P_AJAX]).to.be.true;
                        (0, chai_1.expect)(!!lastArg[P_EXECUTE]).to.be.true;
                        (0, chai_1.expect)(!!lastArg[P_RENDER]).to.be.true;
                        (0, chai_1.expect)(this.jsfAjaxResponse.firstCall.args.length).to.eq(2);
                        (0, chai_1.expect)(globalCnt == 2).to.eq(true); //local before global
                        (0, chai_1.expect)(localCnt == 3).to.eq(true);
                        done();
                    }
                }
            });
            xhrReq = this.requests[0];
            xhrReq.responsetype = "text/xml";
            xhrReq.respond(200, { 'Content-Type': 'text/xml' }, STD_XML);
        }
        catch (e) {
            console.error(e);
        }
        finally {
            send.restore();
        }
    });
    (0, mocha_1.it)('it must have called onError in the error case', function (done) {
        //on hold until it is clear why sinon is not giving me the response XML as expected
        let send = sinon.spy(XMLHttpRequest.prototype, "send");
        let xhrReq = null;
        let oldErr = console.error;
        try {
            let element = mona_dish_1.DomQuery.byId("input_2").getAsElem(0).value;
            jsf.ajax.request(element, null, {
                execute: "input_1",
                render: "@form",
                pass1: "pass1",
                pass2: "pass2",
                onerror: (error) => {
                    (0, chai_1.expect)(error.type).to.eq("error");
                    (0, chai_1.expect)(error.status).to.eq(null);
                    (0, chai_1.expect)(!!error.errorMessage).to.eq(true);
                    (0, chai_1.expect)(!!error.source).to.eq(true);
                    (0, chai_1.expect)(!!error.responseCode).to.eq(true);
                    (0, chai_1.expect)(typeof error.responseCode).to.eq("number");
                    (0, chai_1.expect)(!!error.responseText).to.eq(true);
                    (0, chai_1.expect)(!error.responseXML).to.eq(true);
                    done();
                },
                onevent: (evt) => {
                    if (evt.status == Const_1.COMPLETE) {
                        console.error = () => { };
                        throw Error("This error is wanted, ignore the log");
                    }
                }
            });
            xhrReq = this.requests[0];
            xhrReq.responsetype = "text/xml";
            xhrReq.respond(200, { 'Content-Type': 'text/xml' }, STD_XML);
        }
        catch (e) {
            if (e.message.indexOf("This error is wanted") != -1) {
                return;
            }
            console.error(e);
        }
        finally {
            console.error = oldErr;
            send.restore();
        }
    });
    (0, mocha_1.it)("must handle prefixed inputs properly (prefixes must be present)", function (done) {
        window.document.body.innerHTML = HTML_PREFIX_EMBEDDED_BODY;
        //we now run the tests here
        try {
            let event = {
                isTrusted: true,
                type: 'change',
                target: document.getElementById("page:input::field"),
                currentTarget: document.getElementById("page:input::field")
            };
            jsf.ajax.request(document.getElementById("page:input"), event, {
                render: "page:output",
                execute: "page:input",
                params: {
                    "booga2.xxx": "yyy",
                    "javax.faces.behavior.event": "change",
                    "booga": "bla"
                },
            });
        }
        catch (err) {
            console.error(err);
            (0, chai_1.expect)(false).to.eq(true);
        }
        const requestBody = this.requests[0].requestBody;
        //We check if the base64 encoded string matches the original
        (0, chai_1.expect)(requestBody.indexOf("javax.faces.behavior.event")).to.not.eq(-1);
        (0, chai_1.expect)(requestBody.indexOf("javax.faces.behavior.event=change")).to.not.eq(-1);
        (0, chai_1.expect)(requestBody.indexOf("page%3Ainput=input_value")).to.not.eq(-1);
        done();
    });
});
//# sourceMappingURL=RequestTest_23.spec.js.map