/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package jakarta.faces.event;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;

/**
 * 
 * @since 2.0
 */
public abstract class ComponentSystemEvent extends SystemEvent
{
    public ComponentSystemEvent(UIComponent component)
    {
        super(component);
    }
    
    public ComponentSystemEvent(FacesContext facesContext, UIComponent component)
    {
        super(facesContext, component);
    }

    public UIComponent getComponent()
    {
        return (UIComponent) getSource();
    }
    
    @Override
    public boolean isAppropriateListener(FacesListener listener)
    {
        return listener instanceof ComponentSystemEventListener ||
            super.isAppropriateListener(listener);
    }

    @Override
    public void processListener(FacesListener listener)
    {
        if (listener instanceof SystemEventListener)
        {
            super.processListener(listener);
        }
        else if (listener instanceof ComponentSystemEventListener)
        {
            ((ComponentSystemEventListener)listener).processEvent(this);
        }
    }
}
