/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.ftpserver.command.impl;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.DefaultFtpReply;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpReply;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;

/**
 * <strong>Internal class, do not use directly.</strong>
 * <p>
 * Displays the FTP server timezone in RFC 822 format.
 *
 * @author <a href="http://mina.apache.org">Apache MINA Project</a>
 */
public class SITE_ZONE extends AbstractCommand {
    /** The date formatter for the time zone. We confine it in a thread local to avoid concurrency troubles */
    private final ThreadLocal<SimpleDateFormat> formatter = ThreadLocal.withInitial(() ->
        new SimpleDateFormat("Z"));

    /** SITE_ZONE constructor */
    public SITE_ZONE() {
        super();
    }

    /**
     * Execute command.
     *
     * {@inheritDoc}
     */
    public void execute(final FtpIoSession session,
            final FtpServerContext context, final FtpRequest request)
            throws IOException, FtpException {
        // reset state variables
        session.resetState();

        // send timezone data
        String timezone = formatter.get().format(new Date());

        session.write(new DefaultFtpReply(FtpReply.REPLY_200_COMMAND_OKAY, timezone));
    }
}
