/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.controller.metrics.ControllerMetadataMetrics;
import org.apache.kafka.controller.metrics.ControllerMetricsChanges;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicDelta;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.server.fault.FaultHandler;

public class ControllerMetadataMetricsPublisher
implements MetadataPublisher {
    private final ControllerMetadataMetrics metrics;
    private final FaultHandler faultHandler;
    private MetadataImage prevImage = MetadataImage.EMPTY;

    public ControllerMetadataMetricsPublisher(ControllerMetadataMetrics metrics, FaultHandler faultHandler) {
        this.metrics = metrics;
        this.faultHandler = faultHandler;
    }

    @Override
    public String name() {
        return "ControllerMetadataMetricsPublisher";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        switch (manifest.type()) {
            case LOG_DELTA: {
                try {
                    this.publishDelta(delta);
                    break;
                }
                catch (Throwable e) {
                    this.faultHandler.handleFault("Failed to publish controller metrics from log delta  ending at offset " + manifest.provenance().lastContainedOffset(), e);
                    break;
                }
                finally {
                    this.prevImage = newImage;
                }
            }
            case SNAPSHOT: {
                try {
                    this.publishSnapshot(newImage);
                    break;
                }
                catch (Throwable e) {
                    this.faultHandler.handleFault("Failed to publish controller metrics from " + manifest.provenance().snapshotName(), e);
                    break;
                }
                finally {
                    this.prevImage = newImage;
                }
            }
        }
    }

    private void publishDelta(MetadataDelta delta) {
        ControllerMetricsChanges changes = new ControllerMetricsChanges();
        if (delta.clusterDelta() != null) {
            for (Map.Entry<Integer, Optional<BrokerRegistration>> entry : delta.clusterDelta().changedBrokers().entrySet()) {
                changes.handleBrokerChange(this.prevImage.cluster().brokers().get(entry.getKey()), entry.getValue().orElse(null));
            }
        }
        if (delta.topicsDelta() != null) {
            for (Uuid uuid : delta.topicsDelta().deletedTopicIds()) {
                TopicImage prevTopic = (TopicImage)this.prevImage.topics().topicsById().get((Object)uuid);
                if (prevTopic == null) {
                    throw new RuntimeException("Unable to find deleted topic id " + String.valueOf(uuid) + " in previous topics image.");
                }
                changes.handleDeletedTopic(prevTopic);
            }
            for (Map.Entry<Integer, Object> entry : delta.topicsDelta().changedTopics().entrySet()) {
                changes.handleTopicChange(this.prevImage.topics().getTopic((Uuid)entry.getKey()), (TopicDelta)entry.getValue());
            }
        }
        changes.apply(this.metrics);
    }

    private void publishSnapshot(MetadataImage newImage) {
        this.metrics.setGlobalTopicCount(newImage.topics().topicsById().size());
        int fencedBrokers = 0;
        int activeBrokers = 0;
        for (BrokerRegistration broker : newImage.cluster().brokers().values()) {
            if (broker.fenced()) {
                ++fencedBrokers;
                continue;
            }
            ++activeBrokers;
        }
        this.metrics.setFencedBrokerCount(fencedBrokers);
        this.metrics.setActiveBrokerCount(activeBrokers);
        int totalPartitions = 0;
        int offlinePartitions = 0;
        int partitionsWithoutPreferredLeader = 0;
        for (TopicImage topicImage : newImage.topics().topicsById().values()) {
            for (PartitionRegistration partition : topicImage.partitions().values()) {
                if (!partition.hasLeader()) {
                    ++offlinePartitions;
                }
                if (!partition.hasPreferredLeader()) {
                    ++partitionsWithoutPreferredLeader;
                }
                ++totalPartitions;
            }
        }
        this.metrics.setGlobalPartitionCount(totalPartitions);
        this.metrics.setOfflinePartitionCount(offlinePartitions);
        this.metrics.setPreferredReplicaImbalanceCount(partitionsWithoutPreferredLeader);
    }

    @Override
    public void close() {
        this.metrics.close();
    }
}

