/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.group.share;

import java.util.stream.Collectors;
import org.apache.kafka.common.message.ReadShareGroupStateSummaryRequestData;
import org.apache.kafka.server.group.share.GroupTopicPartitionData;
import org.apache.kafka.server.group.share.PartitionFactory;
import org.apache.kafka.server.group.share.PartitionIdLeaderEpochData;
import org.apache.kafka.server.group.share.PersisterParameters;
import org.apache.kafka.server.group.share.TopicData;

public class ReadShareGroupStateSummaryParameters
implements PersisterParameters {
    private final GroupTopicPartitionData<PartitionIdLeaderEpochData> groupTopicPartitionData;

    private ReadShareGroupStateSummaryParameters(GroupTopicPartitionData<PartitionIdLeaderEpochData> groupTopicPartitionData) {
        this.groupTopicPartitionData = groupTopicPartitionData;
    }

    public GroupTopicPartitionData<PartitionIdLeaderEpochData> groupTopicPartitionData() {
        return this.groupTopicPartitionData;
    }

    public static ReadShareGroupStateSummaryParameters from(ReadShareGroupStateSummaryRequestData data) {
        return new Builder().setGroupTopicPartitionData(new GroupTopicPartitionData<PartitionIdLeaderEpochData>(data.groupId(), data.topics().stream().map(topicData -> new TopicData(topicData.topicId(), topicData.partitions().stream().map(partitionData -> PartitionFactory.newPartitionIdLeaderEpochData(partitionData.partition(), partitionData.leaderEpoch())).collect(Collectors.toList()))).collect(Collectors.toList()))).build();
    }

    public static class Builder {
        private GroupTopicPartitionData<PartitionIdLeaderEpochData> groupTopicPartitionData;

        public Builder setGroupTopicPartitionData(GroupTopicPartitionData<PartitionIdLeaderEpochData> groupTopicPartitionData) {
            this.groupTopicPartitionData = groupTopicPartitionData;
            return this;
        }

        public ReadShareGroupStateSummaryParameters build() {
            return new ReadShareGroupStateSummaryParameters(this.groupTopicPartitionData);
        }
    }
}

