/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Optional;
import java.util.OptionalInt;
import kafka.log.UnifiedLog$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.bootstrap.BootstrapDirectory;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.MetaPropertiesEnsemble;
import org.apache.kafka.server.config.ServerTopicConfigSynonyms;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.slf4j.Logger;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;

public final class KafkaRaftServer$ {
    public static KafkaRaftServer$ MODULE$;
    private final String MetadataTopic;
    private final TopicPartition MetadataPartition;
    private final Uuid MetadataTopicId;
    private final KafkaConfigSchema configSchema;

    static {
        new KafkaRaftServer$();
    }

    public String MetadataTopic() {
        return this.MetadataTopic;
    }

    public TopicPartition MetadataPartition() {
        return this.MetadataPartition;
    }

    public Uuid MetadataTopicId() {
        return this.MetadataTopicId;
    }

    public Tuple2<MetaPropertiesEnsemble, BootstrapMetadata> initializeLogDirs(KafkaConfig config, Logger log, String logPrefix) {
        MetaPropertiesEnsemble.Loader loader = new MetaPropertiesEnsemble.Loader();
        loader.addMetadataLogDir(config.metadataLogDir()).addLogDirs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(config.logDirs()).asJava());
        MetaPropertiesEnsemble initialMetaPropsEnsemble = loader.load();
        EnumSet<MetaPropertiesEnsemble.VerificationFlag> verificationFlags = EnumSet.of(MetaPropertiesEnsemble.VerificationFlag.REQUIRE_AT_LEAST_ONE_VALID, MetaPropertiesEnsemble.VerificationFlag.REQUIRE_METADATA_LOG_DIR);
        initialMetaPropsEnsemble.verify(Optional.empty(), OptionalInt.of(config.nodeId()), verificationFlags);
        String metadataPartitionDirName = UnifiedLog$.MODULE$.logDirName(this.MetadataPartition());
        initialMetaPropsEnsemble.logDirProps().keySet().forEach(logDir -> {
            if (!logDir.equals(config.metadataLogDir())) {
                File clusterMetadataTopic = new File((String)logDir, metadataPartitionDirName);
                if (clusterMetadataTopic.exists()) {
                    throw new KafkaException(new StringBuilder(96).append("Found unexpected metadata location in data directory `").append(clusterMetadataTopic).append("` ").append("(the configured metadata directory is ").append(config.metadataLogDir()).append(").").toString());
                }
                return;
            }
        });
        MetaPropertiesEnsemble.Copier copier = new MetaPropertiesEnsemble.Copier(initialMetaPropsEnsemble);
        initialMetaPropsEnsemble.nonFailedDirectoryProps().forEachRemaining(e -> {
            String logDir2 = (String)e.getKey();
            Optional metaProps = (Optional)e.getValue();
            if (!metaProps.isPresent()) {
                throw new RuntimeException(new StringBuilder(89).append("No `meta.properties` found in ").append(logDir2).append(" (have you run `kafka-storage.sh` ").append("to format the directory?)").toString());
            }
            if (!((MetaProperties)metaProps.get()).nodeId().isPresent()) {
                throw new RuntimeException(new StringBuilder(28).append("Error: node ID not found in ").append(logDir2).toString());
            }
            if (!((MetaProperties)metaProps.get()).clusterId().isPresent()) {
                throw new RuntimeException(new StringBuilder(31).append("Error: cluster ID not found in ").append(logDir2).toString());
            }
            MetaProperties.Builder builder = new MetaProperties.Builder((MetaProperties)metaProps.get());
            if (!builder.directoryId().isPresent()) {
                builder.setDirectoryId(copier.generateValidDirectoryId());
            }
            copier.setLogDirProps(logDir2, builder.build());
            copier.setPreWriteHandler((logDir, x$8, x$9) -> log.info("{}Rewriting {}{}meta.properties", new Object[]{logPrefix, logDir, File.separator}));
        });
        copier.writeLogDirChanges();
        MetaPropertiesEnsemble metaPropsEnsemble = copier.copy();
        BootstrapMetadata bootstrapMetadata = new BootstrapDirectory(config.metadataLogDir(), Optional.ofNullable(config.interBrokerProtocolVersionString())).read();
        return new Tuple2((Object)metaPropsEnsemble, (Object)bootstrapMetadata);
    }

    public KafkaConfigSchema configSchema() {
        return this.configSchema;
    }

    private KafkaRaftServer$() {
        MODULE$ = this;
        this.MetadataTopic = "__cluster_metadata";
        this.MetadataPartition = Topic.CLUSTER_METADATA_TOPIC_PARTITION;
        this.MetadataTopicId = Uuid.METADATA_TOPIC_ID;
        this.configSchema = new KafkaConfigSchema((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigResource.Type.BROKER), (Object)new ConfigDef(KafkaConfig$.MODULE$.configDef())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigResource.Type.TOPIC), (Object)LogConfig.configDefCopy())}))).asJava(), ServerTopicConfigSynonyms.ALL_TOPIC_CONFIG_SYNONYMS);
    }
}

