/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.collections;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.juneau.commons.collections.FilteredList;
import org.apache.juneau.commons.collections.FluentList;
import org.apache.juneau.commons.collections.SortedArrayList;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;

public class Lists<E> {
    private List<E> list;
    private boolean unmodifiable = false;
    private boolean sparse = false;
    private boolean concurrent = false;
    private Comparator<E> comparator;
    private Predicate<E> filter;
    private Class<E> elementType;
    private Function<Object, E> elementFunction;

    public static <E> Lists<E> create(Class<E> elementType) {
        return new Lists<E>(AssertionUtils.assertArgNotNull("elementType", elementType));
    }

    public Lists(Class<E> elementType) {
        this.elementType = AssertionUtils.assertArgNotNull("elementType", elementType);
    }

    public Lists<E> add(E value) {
        if (this.list == null) {
            this.list = CollectionUtils.list(new Object[0]);
        }
        this.list.add(value);
        return this;
    }

    public Lists<E> add(E ... values) {
        AssertionUtils.assertArgNotNull("values", values);
        for (E v : values) {
            this.add(v);
        }
        return this;
    }

    public Lists<E> addAll(Collection<E> value) {
        if (Utils.nn(value)) {
            if (this.list == null) {
                this.list = new LinkedList<E>(value);
            } else {
                this.list.addAll(value);
            }
        }
        return this;
    }

    public Lists<E> addAny(Object ... values) {
        if (Utils.nn(values)) {
            for (Object o : values) {
                if (!Utils.nn(o)) continue;
                if (o instanceof Collection) {
                    Collection o2 = (Collection)o;
                    o2.forEach(x -> this.addAny(x));
                    continue;
                }
                if (Utils.isArray(o)) {
                    for (int i = 0; i < Array.getLength(o); ++i) {
                        this.addAny(Array.get(o, i));
                    }
                    continue;
                }
                if (this.elementType.isInstance(o)) {
                    this.add(this.elementType.cast(o));
                    continue;
                }
                E converted = this.convertElement(o);
                if (converted != null) {
                    this.add(converted);
                    continue;
                }
                throw ThrowableUtils.rex("Object of type {0} could not be converted to type {1}", Utils.cn(o), Utils.cn(this.elementType));
            }
        }
        return this;
    }

    public Lists<E> addIf(boolean flag, E value) {
        if (flag) {
            this.add(value);
        }
        return this;
    }

    public List<E> build() {
        if (this.sparse && Utils.e(this.list)) {
            return null;
        }
        List<E> list2 = null;
        list2 = Utils.nn(this.comparator) ? new SortedArrayList<E>(this.comparator) : new ArrayList();
        if (this.concurrent) {
            list2 = Collections.synchronizedList(list2);
        }
        if (Utils.nn(this.filter) || Utils.nn(this.elementFunction)) {
            FilteredList.Builder list3b = FilteredList.create(this.elementType);
            if (Utils.nn(this.filter)) {
                list3b.filter(this.filter);
            }
            if (Utils.nn(this.elementFunction)) {
                list3b.elementFunction(this.elementFunction);
            }
            list2 = list3b.inner(list2).build();
        }
        if (Utils.nn(this.list)) {
            list2.addAll(this.list);
        }
        if (this.unmodifiable) {
            list2 = Collections.unmodifiableList(list2);
        }
        return list2;
    }

    public FluentList<E> buildFluent() {
        List<E> result = this.build();
        return result == null ? null : new FluentList<E>(result);
    }

    public FilteredList<E> buildFiltered() {
        List<E> l = this.build();
        if (l == null) {
            return null;
        }
        if (l instanceof FilteredList) {
            FilteredList l2 = (FilteredList)l;
            return l2;
        }
        return FilteredList.create(this.elementType).inner(l).build();
    }

    public Lists<E> elementFunction(Function<Object, E> elementFunction) {
        this.elementFunction = AssertionUtils.assertArgNotNull("elementFunction", elementFunction);
        return this;
    }

    public Lists<E> elementType(Class<E> value) {
        this.elementType = AssertionUtils.assertArgNotNull("value", value);
        return this;
    }

    public Lists<E> filtered() {
        return this.filtered(v -> {
            Collection v3;
            Map v2;
            Number v32;
            Boolean v22;
            return !(v == null || v instanceof Boolean && (v22 = (Boolean)v).equals(false) || v instanceof Number && (v32 = (Number)v).intValue() == -1 || Utils.isArray(v) && Array.getLength(v) == 0 || v instanceof Map && (v2 = (Map)v).isEmpty() || v instanceof Collection && (v3 = (Collection)v).isEmpty());
        });
    }

    public Lists<E> filtered(Predicate<E> filter) {
        Predicate<E> newFilter = AssertionUtils.assertArgNotNull("filter", filter);
        this.filter = this.filter == null ? newFilter : this.filter.and(newFilter);
        return this;
    }

    public Lists<E> sorted() {
        return this.sorted(Comparator.naturalOrder());
    }

    public Lists<E> sorted(Comparator<E> comparator) {
        this.comparator = AssertionUtils.assertArgNotNull("comparator", comparator);
        return this;
    }

    public Lists<E> sparse() {
        this.sparse = true;
        return this;
    }

    public Lists<E> unmodifiable() {
        this.unmodifiable = true;
        return this;
    }

    public Lists<E> concurrent() {
        this.concurrent = true;
        return this;
    }

    public Lists<E> concurrent(boolean value) {
        this.concurrent = value;
        return this;
    }

    private E convertElement(Object o) {
        if (this.elementType.isInstance(o)) {
            return (E)o;
        }
        if (Utils.nn(this.elementFunction)) {
            return this.elementFunction.apply(o);
        }
        return null;
    }
}

