/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.Configurable;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.concurrent.Cancellable;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.DetailLevel;
import org.apache.juneau.PropertyNamerDUCS;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ClassInfoTyped;
import org.apache.juneau.commons.reflect.ConstructorInfo;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.IoUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.html.HtmlDocSerializer;
import org.apache.juneau.html.HtmlParser;
import org.apache.juneau.html.HtmlSerializer;
import org.apache.juneau.html.HtmlStrippedDocSerializer;
import org.apache.juneau.http.HttpEntities;
import org.apache.juneau.http.HttpHeaders;
import org.apache.juneau.http.HttpParts;
import org.apache.juneau.http.entity.SerializedEntity;
import org.apache.juneau.http.header.Accept;
import org.apache.juneau.http.header.AcceptCharset;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.http.header.HeaderList;
import org.apache.juneau.http.header.NoTrace;
import org.apache.juneau.http.header.SerializedHeader;
import org.apache.juneau.http.header.Thrown;
import org.apache.juneau.http.part.PartList;
import org.apache.juneau.http.part.SerializedPart;
import org.apache.juneau.http.resource.HttpResource;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartSerializerSession;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.json.Json5Parser;
import org.apache.juneau.json.Json5Serializer;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.msgpack.MsgPackParser;
import org.apache.juneau.msgpack.MsgPackSerializer;
import org.apache.juneau.oapi.OpenApiParser;
import org.apache.juneau.oapi.OpenApiSerializer;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.plaintext.PlainTextParser;
import org.apache.juneau.plaintext.PlainTextSerializer;
import org.apache.juneau.rest.client.BasicHttpEntityRequestBase;
import org.apache.juneau.rest.client.BasicHttpRequestBase;
import org.apache.juneau.rest.client.RestCallException;
import org.apache.juneau.rest.client.RestCallInterceptor;
import org.apache.juneau.rest.client.RestClient;
import org.apache.juneau.rest.client.RestOperation;
import org.apache.juneau.rest.client.RestRequestCreated;
import org.apache.juneau.rest.client.RestResponse;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.uon.UonParser;
import org.apache.juneau.uon.UonSerializer;
import org.apache.juneau.urlencoding.UrlEncodingParser;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;
import org.apache.juneau.xml.XmlParser;
import org.apache.juneau.xml.XmlSerializer;

public class RestRequest
extends BeanSession
implements HttpUriRequest,
Configurable,
AutoCloseable {
    private static final ContentType TEXT_PLAIN = ContentType.TEXT_PLAIN;
    final RestClient client;
    private final HttpRequestBase request;
    private boolean ignoreErrors;
    private boolean suppressLogging;
    private HttpContext context;
    private HttpHost target;
    private HttpPartSchema contentSchema;
    private HttpPartSerializerSession partSerializerSession;
    private HeaderList headerData;
    private List<Class<? extends Throwable>> rethrow;
    List<RestCallInterceptor> interceptors = CollectionUtils.list(new RestCallInterceptor[0]);
    private Object content;
    private Parser parser;
    private PartList formData;
    private PartList pathData;
    private PartList queryData;
    private Predicate<Integer> errorCodes;
    private RestResponse response;
    private Serializer serializer;
    private URIBuilder uriBuilder;
    private final Map<HttpPartSerializer, HttpPartSerializerSession> partSerializerSessions = new IdentityHashMap<HttpPartSerializer, HttpPartSerializerSession>();

    private static boolean isHeaderArray(Object o) {
        if (!Utils.isArray(o)) {
            return false;
        }
        return Header.class.isAssignableFrom(o.getClass().getComponentType());
    }

    private static boolean isNameValuePairArray(Object o) {
        if (!Utils.isArray(o)) {
            return false;
        }
        return NameValuePair.class.isAssignableFrom(o.getClass().getComponentType());
    }

    private static Map<Object, Object> toMap(Object o) {
        return (Map)o;
    }

    protected RestRequest(RestClient client, URI uri, String method, boolean hasBody) throws RestCallException {
        super(AssertionUtils.assertArgNotNull("client", client).getBeanContext().createSession());
        this.client = client;
        this.request = this.createInnerRequest(AssertionUtils.assertArgNotNull("method", method), AssertionUtils.assertArgNotNull("uri", uri), hasBody);
        this.errorCodes = client.errorCodes;
        this.formData = client.createFormData();
        this.headerData = client.createHeaderData();
        this.ignoreErrors = client.ignoreErrors;
        this.pathData = client.createPathData();
        this.queryData = client.createQueryData();
        this.uriBuilder = new URIBuilder(this.request.getURI());
    }

    public void abort() throws UnsupportedOperationException {
        this.request.abort();
    }

    public RestRequest accept(String value) throws RestCallException {
        return this.header(Accept.of(value));
    }

    public RestRequest acceptCharset(String value) throws RestCallException {
        return this.header(AcceptCharset.of(value));
    }

    public void addHeader(Header header) {
        this.headerData.append(header);
    }

    public void addHeader(String name, String value) {
        this.headerData.append((Header)HttpHeaders.stringHeader(name, value));
    }

    public RestRequest cancellable(Cancellable cancellable) {
        this.request.setCancellable(cancellable);
        return this;
    }

    @Override
    public void close() {
        try {
            if (Utils.nn(this.response)) {
                this.response.close();
            }
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.client.log(Level.WARNING, e, "Error closing RestResponse", new Object[0]);
        }
    }

    public RestResponse complete() throws RestCallException {
        return this.run().consume();
    }

    @Deprecated
    public RestRequest completed() {
        this.request.completed();
        return this;
    }

    public Future<RestResponse> completeFuture() throws RestCallException {
        return this.client.getExecutorService().submit(this::complete);
    }

    public RestRequest config(RequestConfig value) {
        this.request.setConfig(value);
        return this;
    }

    public boolean containsHeader(String name) {
        return this.headerData.contains(name);
    }

    public RestRequest content(Object value) {
        this.content = value;
        return this;
    }

    public RestRequest content(Object input, HttpPartSchema schema) {
        this.content = input;
        this.contentSchema = schema;
        return this;
    }

    public RestRequest contentString(Object input) throws RestCallException {
        return this.content(input == null ? null : new StringReader(Utils.s(input)));
    }

    public RestRequest contentType(String value) throws RestCallException {
        return this.header(ContentType.of(value));
    }

    public RestRequest context(HttpContext context) {
        this.context = context;
        return this;
    }

    public RestRequest debug() throws RestCallException {
        this.header("Debug", true);
        return this;
    }

    public RestRequest errorCodes(Predicate<Integer> value) {
        this.errorCodes = AssertionUtils.assertArgNotNull("value", value);
        return this;
    }

    public RestRequest formData(NameValuePair ... parts) {
        this.formData.append(parts);
        return this;
    }

    public RestRequest formData(String name, Object value) {
        this.formData.append(this.createPart(HttpPartType.FORMDATA, name, value));
        return this;
    }

    public RestRequest formDataBean(Object value) {
        AssertionUtils.assertArg(this.isBean(AssertionUtils.assertArgNotNull("value", value)), "Object passed into formDataBean(Object) is not a bean.", new Object[0]);
        PartList b = this.formData;
        this.toBeanMap(value).forEach((k, v) -> b.append(this.createPart(HttpPartType.FORMDATA, (String)k, v)));
        return this;
    }

    public RestRequest formDataCustom(Object value) {
        this.header(ContentType.APPLICATION_FORM_URLENCODED);
        this.content(value instanceof CharSequence ? new StringReader(value.toString()) : value);
        return this;
    }

    public RestRequest formDataPairs(String ... pairs) throws RestCallException {
        AssertionUtils.assertArg(pairs.length % 2 == 0, "Odd number of parameters passed into formDataPairs(String...)", new Object[0]);
        PartList b = this.formData;
        for (int i = 0; i < pairs.length; i += 2) {
            b.append(pairs[i], pairs[i + 1]);
        }
        return this;
    }

    public Header[] getAllHeaders() {
        return this.headerData.getAll();
    }

    public RequestConfig getConfig() {
        return this.request.getConfig();
    }

    public Header getFirstHeader(String name) {
        return this.headerData.getFirst(name).orElse(null);
    }

    public PartList getFormData() {
        return this.formData;
    }

    public HeaderList getHeaders() {
        return this.headerData;
    }

    public Header[] getHeaders(String name) {
        return this.headerData.getAll(name);
    }

    public HttpEntity getHttpEntity() {
        return this.hasHttpEntity() ? ((HttpEntityEnclosingRequestBase)this.request).getEntity() : null;
    }

    public Header getLastHeader(String name) {
        return this.headerData.getLast(name).orElse(null);
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    @Deprecated
    public HttpParams getParams() {
        return this.request.getParams();
    }

    public PartList getPathData() {
        return this.pathData;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.request.getProtocolVersion();
    }

    public PartList getQueryData() {
        return this.queryData;
    }

    public RequestLine getRequestLine() {
        return this.request.getRequestLine();
    }

    public <T> T getResponse(Class<T> type) throws RestCallException {
        return this.run().getContent().as(type);
    }

    public <T> T getResponse(Type type, Type ... args) throws RestCallException {
        return this.run().getContent().as(type, args);
    }

    public String getResponseAsString() throws RestCallException {
        return this.run().getContent().asString();
    }

    public URI getURI() {
        return this.request.getURI();
    }

    public boolean hasHttpEntity() {
        return this.request instanceof HttpEntityEnclosingRequestBase;
    }

    public RestRequest header(Header part) {
        return this.headers(part);
    }

    public RestRequest header(String name, Object value) {
        this.headerData.append(this.createHeader(name, value));
        return this;
    }

    public HeaderIterator headerIterator() {
        return this.headerData.headerIterator();
    }

    public HeaderIterator headerIterator(String name) {
        return this.headerData.headerIterator(name);
    }

    public RestRequest headerPairs(String ... pairs) {
        AssertionUtils.assertArg(pairs.length % 2 == 0, "Odd number of parameters passed into headerPairs(String...)", new Object[0]);
        HeaderList b = this.headerData;
        for (int i = 0; i < pairs.length; i += 2) {
            b.append(pairs[i], pairs[i + 1]);
        }
        return this;
    }

    public RestRequest headers(Header ... parts) {
        this.headerData.append(parts);
        return this;
    }

    public RestRequest headersBean(Object value) {
        AssertionUtils.assertArg(this.isBean(AssertionUtils.assertArgNotNull("value", value)), "Object passed into headersBean(Object) is not a bean.", new Object[0]);
        HeaderList b = this.headerData;
        this.toBeanMap(value, PropertyNamerDUCS.INSTANCE).forEach((k, v) -> b.append(this.createHeader((String)k, v)));
        return this;
    }

    public RestRequest html() {
        return this.serializer(HtmlSerializer.class).parser(HtmlParser.class);
    }

    public RestRequest htmlDoc() {
        return this.serializer(HtmlDocSerializer.class).parser(HtmlParser.class);
    }

    public RestRequest htmlStrippedDoc() {
        return this.serializer(HtmlStrippedDocSerializer.class).parser(HtmlParser.class);
    }

    public RestRequest ignoreErrors() {
        this.ignoreErrors = true;
        return this;
    }

    public RestRequest interceptors(RestCallInterceptor ... interceptors) throws RestCallException {
        AssertionUtils.assertArgNoNulls("interceptors", interceptors);
        try {
            for (RestCallInterceptor i : interceptors) {
                this.interceptors.add(i);
                i.onInit(this);
            }
        }
        catch (RuntimeException | RestCallException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RestCallException(null, e, "Interceptor threw an exception on init.", new Object[0]);
        }
        return this;
    }

    public boolean isAborted() {
        return this.request.isAborted();
    }

    @Override
    public boolean isDebug() {
        return this.headerData.get("Debug", Boolean.class).orElse(false);
    }

    public RestRequest json() {
        return this.serializer(JsonSerializer.class).parser(JsonParser.class);
    }

    public RestRequest json5() {
        return this.serializer(Json5Serializer.class).parser(Json5Parser.class);
    }

    public RestRequest log(Level level, String msg, Object ... args) {
        this.client.log(level, msg, args);
        return this;
    }

    public RestRequest log(Level level, Throwable t, String msg, Object ... args) {
        this.client.log(level, t, msg, args);
        return this;
    }

    public RestRequest mediaType(String value) throws RestCallException {
        return this.header(Accept.of(value)).header(ContentType.of(value));
    }

    public RestRequest msgPack() {
        return this.serializer(MsgPackSerializer.class).parser(MsgPackParser.class);
    }

    public RestRequest noTrace() throws RestCallException {
        return this.header(NoTrace.TRUE);
    }

    public RestRequest openApi() {
        return this.serializer(OpenApiSerializer.class).parser(OpenApiParser.class);
    }

    public RestRequest parser(Class<? extends Parser> parser) {
        this.parser = this.client.getInstance(AssertionUtils.assertArgNotNull("parser", parser));
        return this;
    }

    public RestRequest parser(Parser parser) {
        this.parser = AssertionUtils.assertArgNotNull("parser", parser);
        return this;
    }

    public RestRequest pathData(NameValuePair ... parts) {
        this.pathData.set(parts);
        return this;
    }

    public RestRequest pathData(String name, Object value) {
        this.pathData.set(this.createPart(HttpPartType.PATH, name, value));
        return this;
    }

    public RestRequest pathDataBean(Object value) {
        AssertionUtils.assertArg(this.isBean(AssertionUtils.assertArgNotNull("value", value)), "Object passed into pathDataBean(Object) is not a bean.", new Object[0]);
        PartList b = this.pathData;
        this.toBeanMap(value).forEach((k, v) -> b.set(this.createPart(HttpPartType.PATH, (String)k, v)));
        return this;
    }

    public RestRequest pathDataPairs(String ... pairs) {
        AssertionUtils.assertArg(pairs.length % 2 == 0, "Odd number of parameters passed into pathDataPairs(String...)", new Object[0]);
        PartList b = this.pathData;
        for (int i = 0; i < pairs.length; i += 2) {
            b.set(pairs[i], pairs[i + 1]);
        }
        return this;
    }

    public RestRequest plainText() {
        return this.serializer(PlainTextSerializer.class).parser(PlainTextParser.class);
    }

    public RestRequest protocolVersion(ProtocolVersion version) {
        this.request.setProtocolVersion(version);
        return this;
    }

    public RestRequest queryCustom(Object value) {
        try {
            String q = null;
            if (value instanceof Reader) {
                Reader value2 = (Reader)value;
                q = IoUtils.read(value2);
            } else if (value instanceof InputStream) {
                InputStream value2 = (InputStream)value;
                q = IoUtils.read(value2);
            } else {
                q = Utils.s(value);
            }
            this.uriBuilder.setCustomQuery(q);
        }
        catch (IOException e) {
            throw ThrowableUtils.rex(e, "Could not read custom query.", new Object[0]);
        }
        return this;
    }

    public RestRequest queryData(NameValuePair ... parts) {
        this.queryData.append(parts);
        return this;
    }

    public RestRequest queryData(String name, Object value) {
        this.queryData.append(this.createPart(HttpPartType.QUERY, name, value));
        return this;
    }

    public RestRequest queryDataBean(Object value) {
        AssertionUtils.assertArg(this.isBean(AssertionUtils.assertArgNotNull("value", value)), "Object passed into queryDataBean(Object) is not a bean.", new Object[0]);
        PartList b = this.queryData;
        this.toBeanMap(value).forEach((k, v) -> b.append(this.createPart(HttpPartType.QUERY, (String)k, v)));
        return this;
    }

    public RestRequest queryDataPairs(String ... pairs) throws RestCallException {
        AssertionUtils.assertArg(pairs.length % 2 == 0, "Odd number of parameters passed into queryDataPairs(String...)", new Object[0]);
        PartList b = this.queryData;
        for (int i = 0; i < pairs.length; i += 2) {
            b.append(pairs[i], pairs[i + 1]);
        }
        return this;
    }

    public void removeHeader(Header header) {
        this.headerData.remove(header);
    }

    public void removeHeaders(String name) {
        this.headerData.remove(name);
    }

    public RestRequest rethrow(Class<?> ... values) {
        if (this.rethrow == null) {
            this.rethrow = CollectionUtils.list(new Class[0]);
        }
        for (Class<?> v : values) {
            if (!Utils.nn(v) || !Throwable.class.isAssignableFrom(v)) continue;
            this.rethrow.add(v);
        }
        return this;
    }

    public RestResponse run() throws RestCallException {
        if (Utils.nn(this.response)) {
            throw new RestCallException(this.response, null, "run() already called.", new Object[0]);
        }
        try {
            HttpEntityEnclosingRequestBase request3;
            this.queryData.stream().map(x$0 -> new SimpleQuery((NameValuePair)x$0)).filter(SimplePart::isValid).forEach(x -> this.uriBuilder.addParameter(x.name, x.value));
            this.pathData.stream().map(x$0 -> new SimplePath((NameValuePair)x$0)).forEach(x -> {
                String path = this.uriBuilder.getPath();
                String name = x.name;
                String value = x.value;
                String var = "{" + name + "}";
                if (path.indexOf(var) == -1 && !name.equals("/*")) {
                    throw new IllegalStateException("Path variable {" + name + "} was not found in path.");
                }
                path = name.equals("/*") ? path.replaceAll("\\/\\*$", "/" + value) : path.replace(var, String.valueOf(value));
                this.uriBuilder.setPath(path);
            });
            HttpRequestBase httpRequestBase = this.request;
            HttpEntityEnclosingRequestBase request2 = httpRequestBase instanceof HttpEntityEnclosingRequestBase ? (request3 = (HttpEntityEnclosingRequestBase)httpRequestBase) : null;
            this.request.setURI(this.uriBuilder.build());
            HeaderList hl = this.headerData;
            Optional<Header> h = hl.getLast("Content-Type");
            String contentType = h.isPresent() ? h.get().getValue() : null;
            Serializer serializer = this.serializer;
            if (serializer == null) {
                serializer = this.client.getMatchingSerializer(contentType);
            }
            if (contentType == null && Utils.nn(serializer)) {
                contentType = serializer.getPrimaryMediaType().toString();
            }
            String accept = (h = hl.getLast("Accept")).isPresent() ? h.get().getValue() : null;
            Parser parser = this.parser;
            if (parser == null) {
                parser = this.client.getMatchingParser(accept);
            }
            if (accept == null && Utils.nn(parser)) {
                hl.set((Header)Accept.of(parser.getPrimaryMediaType()));
            }
            this.headerData.stream().map(x$0 -> new SimpleHeader((NameValuePair)x$0)).filter(SimplePart::isValid).forEach(x -> this.request.addHeader((Header)x));
            if (request2 == null && this.content != RestOperation.NO_BODY) {
                throw new RestCallException(null, null, "Method does not support content entity.  Method={0}, URI={1}", this.getMethod(), this.getURI());
            }
            if (Utils.nn(request2)) {
                Object input2 = null;
                input2 = this.content != RestOperation.NO_BODY ? this.content : new UrlEncodedFormEntity(this.formData.stream().map(x$0 -> new SimpleFormData((NameValuePair)x$0)).filter(SimplePart::isValid).collect(Collectors.toList()));
                if (input2 instanceof Supplier) {
                    Supplier s = (Supplier)input2;
                    input2 = s.get();
                }
                HttpEntity entity = null;
                if (input2 instanceof PartList) {
                    PartList input22 = (PartList)input2;
                    entity = new UrlEncodedFormEntity(input22.stream().map(x$0 -> new SimpleFormData((NameValuePair)x$0)).filter(SimplePart::isValid).collect(Collectors.toList()));
                } else if (input2 instanceof HttpResource) {
                    HttpResource input23 = (HttpResource)input2;
                    input23.getHeaders().forEach(x -> this.request.addHeader(x));
                    entity = (HttpEntity)input2;
                } else if (input2 instanceof HttpEntity) {
                    HttpEntity input3 = (HttpEntity)input2;
                    if (input3 instanceof SerializedEntity) {
                        SerializedEntity input32 = (SerializedEntity)input3;
                        entity = input32.copyWith(serializer, this.contentSchema);
                    } else {
                        entity = input3;
                    }
                } else if (input2 instanceof Reader) {
                    Reader input24 = (Reader)input2;
                    entity = HttpEntities.readerEntity(input24, this.getRequestContentType(TEXT_PLAIN));
                } else if (input2 instanceof InputStream) {
                    InputStream input25 = (InputStream)input2;
                    entity = HttpEntities.streamEntity(input25, -1L, this.getRequestContentType(ContentType.APPLICATION_OCTET_STREAM));
                } else if (Utils.nn(serializer)) {
                    entity = HttpEntities.serializedEntity(input2, serializer, this.contentSchema).setContentType(contentType);
                } else {
                    if (this.client.hasSerializers()) {
                        if (contentType == null) {
                            throw new RestCallException(null, null, "Content-Type not specified on request.  Cannot match correct serializer.  Use contentType(String) or mediaType(String) to specify transport language.", new Object[0]);
                        }
                        throw new RestCallException(null, null, "No matching serializer for media type ''{0}''", contentType);
                    }
                    entity = HttpEntities.stringEntity(input2 == null ? "" : BeanContext.DEFAULT.getClassMetaForObject(input2).toString(input2), this.getRequestContentType(TEXT_PLAIN));
                }
                request2.setEntity(entity);
            }
            this.response = this.client.createResponse(this, this.client.run(this.target, (HttpRequest)this.request, this.context), parser);
            if (this.isDebug() || this.client.logRequests == DetailLevel.FULL) {
                this.response.cacheContent();
            }
            for (RestCallInterceptor rci : this.interceptors) {
                rci.onConnect(this, this.response);
            }
            this.client.onCallConnect(this, this.response);
            String method = this.getMethod();
            int sc = this.response.getStatusCode();
            Thrown thrown = this.response.getHeader("Thrown").asHeader(Thrown.class);
            if (thrown.isPresent() && Utils.nn(this.rethrow)) {
                Thrown.Part thrownPart = thrown.asParts().get().get(0);
                String className = thrownPart.getClassName();
                String message = thrownPart.getMessage();
                for (Class<? extends Throwable> t : this.rethrow) {
                    if (!t.getName().equals(className)) continue;
                    ConstructorInfo c = null;
                    ClassInfoTyped<? extends Throwable> ci = ClassInfo.of(t);
                    c = ci.getPublicConstructor(x -> x.hasParameterTypes(HttpResponse.class)).orElse(null);
                    if (Utils.nn(c)) {
                        throw (Throwable)c.newInstance(this.response);
                    }
                    c = ci.getPublicConstructor(x -> x.hasParameterTypes(String.class)).orElse(null);
                    if (Utils.nn(c)) {
                        throw (Throwable)c.newInstance(Utils.nn(message) ? message : this.response.getContent().asString());
                    }
                    c = ci.getPublicConstructor(x -> x.hasParameterTypes(String.class, Throwable.class)).orElse(null);
                    if (Utils.nn(c)) {
                        throw (Throwable)c.newInstance(Utils.nn(message) ? message : this.response.getContent().asString(), null);
                    }
                    c = ci.getPublicConstructor(cons -> cons.getParameterCount() == 0).orElse(null);
                    if (!Utils.nn(c)) continue;
                    throw (Throwable)c.newInstance(new Object[0]);
                }
            }
            if (this.errorCodes.test(sc) && !this.ignoreErrors) {
                throw new RestCallException(this.response, null, "HTTP method ''{0}'' call to ''{1}'' caused response code ''{2}, {3}''.\nResponse: \n{4}", method, this.getURI(), sc, this.response.getReasonPhrase(), this.response.getContent().asAbbreviatedString(1000));
            }
        }
        catch (RuntimeException | RestCallException e) {
            if (Utils.nn(this.response)) {
                this.response.close();
            }
            throw e;
        }
        catch (Throwable e) {
            if (Utils.nn(this.response)) {
                this.response.close();
            }
            throw new RestCallException(this.response, e, "Call failed.", new Object[0]);
        }
        return this.response;
    }

    public Future<RestResponse> runFuture() throws RestCallException {
        return this.client.getExecutorService().submit(this::run);
    }

    public RestRequest serializer(Class<? extends Serializer> serializer) {
        this.serializer = serializer == null ? null : this.client.getInstance(serializer);
        return this;
    }

    public RestRequest serializer(Serializer serializer) {
        this.serializer = serializer;
        return this;
    }

    public void setHeader(Header header) {
        this.headerData.set(header);
    }

    public void setHeader(String name, String value) {
        this.headerData.set((Header)HttpHeaders.stringHeader(name, value));
    }

    public void setHeaders(Header[] headers) {
        this.headerData.set(headers);
    }

    @Deprecated
    public void setParams(HttpParams params) {
        this.request.setParams(params);
    }

    public RestRequest suppressLogging() {
        this.suppressLogging = true;
        return this;
    }

    public RestRequest target(HttpHost target) {
        this.target = target;
        return this;
    }

    public RestRequest uon() {
        return this.serializer(UonSerializer.class).parser(UonParser.class);
    }

    public RestRequest uri(Object uri) throws RestCallException {
        URI x = this.client.toUri(uri, null);
        if (Utils.nn(x.getScheme())) {
            this.uriBuilder.setScheme(x.getScheme());
        }
        if (Utils.nn(x.getHost())) {
            this.uriBuilder.setHost(x.getHost());
        }
        if (x.getPort() != -1) {
            this.uriBuilder.setPort(x.getPort());
        }
        if (Utils.nn(x.getUserInfo())) {
            this.uriBuilder.setUserInfo(x.getUserInfo());
        }
        if (Utils.nn(x.getFragment())) {
            this.uriBuilder.setFragment(x.getFragment());
        }
        if (Utils.nn(x.getQuery())) {
            this.uriBuilder.setCustomQuery(x.getQuery());
        }
        this.uriBuilder.setPath(x.getPath());
        return this;
    }

    public RestRequest uriFragment(String fragment) {
        this.uriBuilder.setFragment(fragment);
        return this;
    }

    public RestRequest uriHost(String host) {
        this.uriBuilder.setHost(host);
        return this;
    }

    public RestRequest uriPort(int port) {
        this.uriBuilder.setPort(port);
        return this;
    }

    public RestRequest uriScheme(String scheme) {
        this.uriBuilder.setScheme(scheme);
        return this;
    }

    public RestRequest uriUserInfo(String userInfo) {
        this.uriBuilder.setUserInfo(userInfo);
        return this;
    }

    public RestRequest uriUserInfo(String username, String password) {
        this.uriBuilder.setUserInfo(username, password);
        return this;
    }

    public RestRequest urlEnc() {
        return this.serializer(UrlEncodingSerializer.class).parser(UrlEncodingParser.class);
    }

    public RestRequest xml() {
        return this.serializer(XmlSerializer.class).parser(XmlParser.class);
    }

    private Header createHeader(String name, Object value) {
        return this.createHeader(name, value, null, null, null);
    }

    private NameValuePair createPart(HttpPartType type, String name, Object value) {
        return this.createPart(name, value, type, null, null, null);
    }

    private HttpPartSerializerSession getPartSerializerSession(HttpPartSerializer serializer) {
        HttpPartSerializerSession s;
        if (serializer == null) {
            serializer = this.client.getPartSerializer();
        }
        if ((s = this.partSerializerSessions.get(serializer)) == null) {
            s = serializer.getPartSession();
            this.partSerializerSessions.put(serializer, s);
        }
        return s;
    }

    private ContentType getRequestContentType(ContentType def) {
        String s;
        Header h = this.request.getFirstHeader("Content-Type");
        if (Utils.nn(h) && Utils.ne(s = h.getValue())) {
            return ContentType.of(s);
        }
        return def;
    }

    protected Header createHeader(String name, Object value, HttpPartSerializer serializer, HttpPartSchema schema, Boolean skipIfEmpty) {
        if (Utils.e(name)) {
            return null;
        }
        if (skipIfEmpty == null) {
            skipIfEmpty = this.client.isSkipEmptyHeaderData();
        }
        if (serializer == null) {
            serializer = this.client.getPartSerializer();
        }
        return new SerializedHeader(name, value, this.getPartSerializerSession(serializer), schema, (boolean)skipIfEmpty);
    }

    protected HttpRequestBase createInnerRequest(String method, URI uri, boolean hasBody) {
        RestRequestCreated req = hasBody ? new BasicHttpEntityRequestBase(this, method) : new BasicHttpRequestBase(this, method);
        req.setURI(uri);
        return req;
    }

    protected NameValuePair createPart(String name, Object value, HttpPartType type, HttpPartSerializer serializer, HttpPartSchema schema, Boolean skipIfEmpty) {
        if (Utils.e(name)) {
            return null;
        }
        if (skipIfEmpty == null) {
            skipIfEmpty = type == HttpPartType.QUERY ? Boolean.valueOf(this.client.isSkipEmptyQueryData()) : (type == HttpPartType.FORMDATA ? Boolean.valueOf(this.client.isSkipEmptyFormData()) : Boolean.valueOf(false));
        }
        if (serializer == null) {
            serializer = this.client.getPartSerializer();
        }
        return new SerializedPart(name, value, type, this.getPartSerializerSession(serializer), schema, skipIfEmpty);
    }

    @Override
    protected FluentMap<String, Object> properties() {
        return super.properties().a("client", this.client.properties()).a("ignoreErrors", (FluentMap<String, Object>)this.ignoreErrors).a("interceptors", (FluentMap<String, Object>)((Object)this.interceptors)).a("requestBodySchema", (List<RestCallInterceptor>)((Object)this.contentSchema)).a("response", (List<RestCallInterceptor>)((Object)this.response)).a("serializer", (List<RestCallInterceptor>)((Object)this.serializer));
    }

    RestRequest formDataArg(String name, Object value, HttpPartSchema schema, HttpPartSerializer serializer, boolean skipIfEmpty) {
        boolean isMulti;
        boolean bl = isMulti = Utils.e(name) || "*".equals(name) || value instanceof PartList || RestRequest.isNameValuePairArray(value);
        if (!isMulti) {
            if (!skipIfEmpty || !Utils.e(Utils.s(value))) {
                return this.formData(this.createPart(name, value, HttpPartType.FORMDATA, serializer, schema, skipIfEmpty));
            }
            return this;
        }
        List<NameValuePair> l = CollectionUtils.list(new NameValuePair[0]);
        if (HttpParts.canCast(value)) {
            l.add(HttpParts.cast(value));
        } else if (value instanceof PartList) {
            PartList value2 = (PartList)value;
            value2.forEach(x -> l.add((NameValuePair)x));
        } else if (value instanceof Collection) {
            Collection value3 = (Collection)value;
            value3.forEach(x -> l.add(HttpParts.cast(x)));
        } else if (Utils.isArray(value)) {
            for (int i = 0; i < Array.getLength(value); ++i) {
                l.add(HttpParts.cast(Array.get(value, i)));
            }
        } else if (value instanceof Map) {
            Map value4 = (Map)value;
            RestRequest.toMap(value4).forEach((k, v) -> l.add(this.createPart(Utils.s(k), v, HttpPartType.FORMDATA, serializer, schema, skipIfEmpty)));
        } else if (this.isBean(value)) {
            this.toBeanMap(value).forEach((k, v) -> l.add(this.createPart((String)k, v, HttpPartType.FORMDATA, serializer, schema, skipIfEmpty)));
        } else if (Utils.nn(value)) {
            this.formDataCustom(value);
            return this;
        }
        if (skipIfEmpty) {
            l.removeIf(x -> Utils.e(x.getValue()));
        }
        this.formData.append(l);
        return this;
    }

    HttpPartSerializerSession getPartSerializerSession() {
        if (this.partSerializerSession == null) {
            this.partSerializerSession = this.getPartSerializerSession(null);
        }
        return this.partSerializerSession;
    }

    RestRequest headerArg(String name, Object value, HttpPartSchema schema, HttpPartSerializer serializer, boolean skipIfEmpty) {
        boolean isMulti;
        boolean bl = isMulti = Utils.e(name) || "*".equals(name) || value instanceof HeaderList || RestRequest.isHeaderArray(value);
        if (!isMulti) {
            if (!skipIfEmpty || !Utils.e(Utils.s(value))) {
                return this.header(this.createHeader(name, value, serializer, schema, skipIfEmpty));
            }
            return this;
        }
        List<Header> l = CollectionUtils.list(new Header[0]);
        if (HttpHeaders.canCast(value)) {
            l.add(HttpHeaders.cast(value));
        } else if (value instanceof HeaderList) {
            HeaderList value2 = (HeaderList)value;
            value2.forEach(x -> l.add((Header)x));
        } else if (value instanceof Collection) {
            Collection value3 = (Collection)value;
            value3.forEach(x -> l.add(HttpHeaders.cast(x)));
        } else if (Utils.isArray(value)) {
            for (int i = 0; i < Array.getLength(value); ++i) {
                l.add(HttpHeaders.cast(Array.get(value, i)));
            }
        } else if (value instanceof Map) {
            Map value2 = (Map)value;
            RestRequest.toMap(value2).forEach((k, v) -> l.add(this.createHeader(Utils.s(k), v, serializer, schema, skipIfEmpty)));
        } else if (this.isBean(value)) {
            this.toBeanMap(value).forEach((k, v) -> l.add(this.createHeader((String)k, v, serializer, schema, skipIfEmpty)));
        } else if (Utils.nn(value)) {
            throw ThrowableUtils.rex("Invalid value type for header arg ''{0}'': {1}", name, Utils.cn(value));
        }
        if (skipIfEmpty) {
            l.removeIf(x -> Utils.e(x.getValue()));
        }
        this.headerData.append(l);
        return this;
    }

    boolean isLoggingSuppressed() {
        return this.suppressLogging;
    }

    RestRequest pathArg(String name, Object value, HttpPartSchema schema, HttpPartSerializer serializer) {
        boolean isMulti;
        boolean bl = isMulti = Utils.e(name) || "*".equals(name) || value instanceof PartList || RestRequest.isNameValuePairArray(value);
        if (!isMulti) {
            return this.pathData(this.createPart(name, value, HttpPartType.PATH, serializer, schema, false));
        }
        List<NameValuePair> l = CollectionUtils.list(new NameValuePair[0]);
        if (HttpParts.canCast(value)) {
            l.add(HttpParts.cast(value));
        } else if (value instanceof PartList) {
            PartList value2 = (PartList)value;
            value2.forEach(x -> l.add((NameValuePair)x));
        } else if (value instanceof Collection) {
            Collection value3 = (Collection)value;
            value3.forEach(x -> l.add(HttpParts.cast(x)));
        } else if (Utils.isArray(value)) {
            for (int i = 0; i < Array.getLength(value); ++i) {
                l.add(HttpParts.cast(Array.get(value, i)));
            }
        } else if (value instanceof Map) {
            Map value4 = (Map)value;
            RestRequest.toMap(value4).forEach((k, v) -> l.add(this.createPart(Utils.s(k), v, HttpPartType.PATH, serializer, schema, false)));
        } else if (this.isBean(value)) {
            this.toBeanMap(value).forEach((k, v) -> l.add(this.createPart((String)k, v, HttpPartType.PATH, serializer, schema, false)));
        } else if (Utils.nn(value)) {
            throw ThrowableUtils.rex("Invalid value type for path arg ''{0}'': {1}", name, Utils.cn(value));
        }
        this.pathData.append(l);
        return this;
    }

    RestRequest queryArg(String name, Object value, HttpPartSchema schema, HttpPartSerializer serializer, boolean skipIfEmpty) {
        boolean isMulti;
        boolean bl = isMulti = Utils.e(name) || "*".equals(name) || value instanceof PartList || RestRequest.isNameValuePairArray(value);
        if (!isMulti) {
            if (!skipIfEmpty || !Utils.e(Utils.s(value))) {
                return this.queryData(this.createPart(name, value, HttpPartType.QUERY, serializer, schema, skipIfEmpty));
            }
            return this;
        }
        List<NameValuePair> l = CollectionUtils.list(new NameValuePair[0]);
        if (HttpParts.canCast(value)) {
            l.add(HttpParts.cast(value));
        } else if (value instanceof PartList) {
            PartList value2 = (PartList)value;
            value2.forEach(x -> l.add((NameValuePair)x));
        } else if (value instanceof Collection) {
            Collection value3 = (Collection)value;
            value3.forEach(x -> l.add(HttpParts.cast(x)));
        } else if (Utils.isArray(value)) {
            for (int i = 0; i < Array.getLength(value); ++i) {
                l.add(HttpParts.cast(Array.get(value, i)));
            }
        } else if (value instanceof Map) {
            Map value4 = (Map)value;
            RestRequest.toMap(value4).forEach((k, v) -> l.add(this.createPart(Utils.s(k), v, HttpPartType.QUERY, serializer, schema, skipIfEmpty)));
        } else if (this.isBean(value)) {
            this.toBeanMap(value).forEach((k, v) -> l.add(this.createPart((String)k, v, HttpPartType.QUERY, serializer, schema, skipIfEmpty)));
        } else if (Utils.nn(value)) {
            this.queryCustom(value);
            return this;
        }
        if (skipIfEmpty) {
            l.removeIf(x -> Utils.e(x.getValue()));
        }
        this.queryData.append(l);
        return this;
    }

    private class SimpleFormData
    extends SimplePart {
        SimpleFormData(NameValuePair x) {
            super(x, RestRequest.this.client.isSkipEmptyFormData());
        }
    }

    private class SimpleHeader
    extends SimplePart
    implements Header {
        SimpleHeader(NameValuePair x) {
            super(x, RestRequest.this.client.isSkipEmptyHeaderData());
        }

        public HeaderElement[] getElements() throws ParseException {
            return null;
        }
    }

    private class SimplePath
    extends SimplePart {
        SimplePath(NameValuePair x) {
            super(x, false);
        }
    }

    private class SimpleQuery
    extends SimplePart {
        SimpleQuery(NameValuePair x) {
            super(x, RestRequest.this.client.isSkipEmptyQueryData());
        }
    }

    private class SimplePart
    implements NameValuePair {
        final String name;
        final String value;

        SimplePart(NameValuePair x, boolean skipIfEmpty) {
            this.name = x.getName();
            if (x instanceof SerializedHeader) {
                SerializedHeader x2 = (SerializedHeader)x;
                this.value = x2.copyWith(RestRequest.this.getPartSerializerSession(), null).getValue();
            } else if (x instanceof SerializedPart) {
                SerializedPart x3 = (SerializedPart)x;
                this.value = x3.copyWith(RestRequest.this.getPartSerializerSession(), null).getValue();
            } else {
                String v = x.getValue();
                this.value = Utils.e(v) && skipIfEmpty ? null : v;
            }
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        boolean isValid() {
            return !Utils.e(this.name) && this.value != null;
        }
    }
}

