/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.converter;

import org.apache.juneau.BeanSession;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.response.BasicHttpException;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.objecttools.ObjectRest;
import org.apache.juneau.objecttools.ObjectRestException;
import org.apache.juneau.parser.ParserMatch;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.converter.RestConverter;
import org.apache.juneau.swap.ObjectSwap;

public class Traversable
implements RestConverter {
    @Override
    public Object convert(RestRequest req, Object o) throws BasicHttpException, InternalServerError {
        if (o == null) {
            return null;
        }
        String pathRemainder = req.getPathRemainder().orElse(null);
        if (Utils.nn(pathRemainder)) {
            try {
                BeanSession bs = req.getBeanSession();
                ObjectSwap<Object, ?> swap = bs.getClassMetaForObject(o).getSwap(bs);
                if (Utils.nn(swap)) {
                    o = swap.swap(bs, o);
                }
                ReaderParser rp = req.getContent().getParserMatch().map(ParserMatch::getParser).filter(ReaderParser.class::isInstance).map(ReaderParser.class::cast).orElse(null);
                ObjectRest or = ObjectRest.create(o, rp);
                o = or.get(pathRemainder);
            }
            catch (ObjectRestException e) {
                throw new BasicHttpException(e.getStatus(), (Throwable)e);
            }
            catch (Throwable t) {
                throw new InternalServerError(t);
            }
        }
        return o;
    }
}

