/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.lang.reflect.Type;
import java.util.Deque;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.dto.swagger.HeaderInfo;
import org.apache.juneau.dto.swagger.SchemaInfo;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.dto.swagger.SwaggerElement;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.MultiSet;

@Bean(properties="description,schema,headers,examples,*")
@FluentSetters
public class ResponseInfo
extends SwaggerElement {
    private String description;
    private SchemaInfo schema;
    private Map<String, HeaderInfo> headers;
    private Map<String, Object> examples;

    public ResponseInfo() {
    }

    public ResponseInfo(ResponseInfo copyFrom) {
        super(copyFrom);
        this.description = copyFrom.description;
        this.schema = copyFrom.schema == null ? null : copyFrom.schema.copy();
        this.examples = CollectionUtils.copyOf(copyFrom.examples);
        if (copyFrom.headers == null) {
            this.headers = null;
        } else {
            this.headers = CollectionUtils.map();
            copyFrom.headers.forEach((k, v) -> this.headers.put((String)k, v.copy()));
        }
    }

    public ResponseInfo copy() {
        return new ResponseInfo(this);
    }

    public ResponseInfo copyFrom(ResponseInfo r) {
        if (r != null) {
            if (r.description != null) {
                this.description = r.description;
            }
            if (r.schema != null) {
                this.schema = r.schema;
            }
            if (r.headers != null) {
                this.headers = r.headers;
            }
            if (r.examples != null) {
                this.examples = r.examples;
            }
        }
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public ResponseInfo setDescription(String value) {
        this.description = value;
        return this;
    }

    public Map<String, Object> getExamples() {
        return this.examples;
    }

    public ResponseInfo setExamples(Map<String, Object> value) {
        this.examples = CollectionUtils.copyOf(value);
        return this;
    }

    public ResponseInfo addExample(String mimeType, Object example) {
        this.examples = CollectionUtils.mapBuilder(this.examples).sparse().add(mimeType, example).build();
        return this;
    }

    public Map<String, HeaderInfo> getHeaders() {
        return this.headers;
    }

    public ResponseInfo setHeaders(Map<String, HeaderInfo> value) {
        this.headers = CollectionUtils.copyOf(value);
        return this;
    }

    public ResponseInfo addHeader(String name, HeaderInfo header) {
        this.headers = CollectionUtils.mapBuilder(this.headers).add(name, header).build();
        return this;
    }

    public HeaderInfo getHeader(String name) {
        return this.getHeaders().get(name);
    }

    public SchemaInfo getSchema() {
        return this.schema;
    }

    public ResponseInfo setSchema(SchemaInfo value) {
        this.schema = value;
        return this;
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "description": {
                return ConverterUtils.toType(this.getDescription(), type);
            }
            case "examples": {
                return ConverterUtils.toType(this.getExamples(), type);
            }
            case "headers": {
                return ConverterUtils.toType(this.getHeaders(), type);
            }
            case "schema": {
                return ConverterUtils.toType(this.getSchema(), type);
            }
        }
        return super.get(property, type);
    }

    @Override
    public ResponseInfo set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "description": {
                return this.setDescription(StringUtils.stringify(value));
            }
            case "examples": {
                return this.setExamples(CollectionUtils.mapBuilder(String.class, Object.class, new Type[0]).sparse().addAny(value).build());
            }
            case "headers": {
                return this.setHeaders(CollectionUtils.mapBuilder(String.class, HeaderInfo.class, new Type[0]).sparse().addAny(value).build());
            }
            case "schema": {
                return this.setSchema(ConverterUtils.toType(value, SchemaInfo.class));
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setBuilder(String.class, new Type[0]).addIf(this.description != null, "description").addIf(this.examples != null, "examples").addIf(this.headers != null, "headers").addIf(this.schema != null, "schema").build();
        return new MultiSet<String>(s, super.keySet());
    }

    public ResponseInfo resolveRefs(Swagger swagger, Deque<String> refStack, int maxDepth) {
        if (this.schema != null) {
            this.schema = this.schema.resolveRefs(swagger, refStack, maxDepth);
        }
        if (this.headers != null) {
            this.headers.entrySet().forEach(x -> x.setValue(((HeaderInfo)x.getValue()).resolveRefs(swagger, refStack, maxDepth)));
        }
        return this;
    }
}

