/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BeanSession;
import org.apache.juneau.BinaryFormat;
import org.apache.juneau.Context;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.ArgUtils;
import org.apache.juneau.common.internal.IOUtils;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.common.internal.ThrowableUtils;
import org.apache.juneau.config.Entry;
import org.apache.juneau.config.Section;
import org.apache.juneau.config.event.ConfigEventListener;
import org.apache.juneau.config.event.ConfigEvents;
import org.apache.juneau.config.internal.ConfigMap;
import org.apache.juneau.config.internal.ConfigMapEntry;
import org.apache.juneau.config.mod.Mod;
import org.apache.juneau.config.mod.XorEncodeMod;
import org.apache.juneau.config.store.ClasspathStore;
import org.apache.juneau.config.store.ConfigStore;
import org.apache.juneau.config.store.FileStore;
import org.apache.juneau.config.store.MemoryStore;
import org.apache.juneau.config.vars.ConfigVar;
import org.apache.juneau.internal.Cache;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.json.Json5Serializer;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.utils.HashKey;

public final class Config
extends Context
implements ConfigEventListener {
    private static boolean DISABLE_AUTO_SYSTEM_PROPS = Boolean.getBoolean("juneau.disableAutoSystemProps");
    private static volatile Config SYSTEM_DEFAULT = Config.findSystemDefault();
    final String name;
    final ConfigStore store;
    final WriterSerializer serializer;
    final ReaderParser parser;
    final Map<Character, Mod> mods;
    final VarResolver varResolver;
    final int binaryLineLength;
    final BinaryFormat binaryFormat;
    final boolean multiLineValuesOnSeparateLines;
    final boolean readOnly;
    final BeanSession beanSession;
    final VarResolverSession varSession;
    private final ConfigMap configMap;
    private final List<ConfigEventListener> listeners = CollectionUtils.synced(CollectionUtils.linkedList(new ConfigEventListener[0]));

    public static synchronized void setSystemDefault(Config systemDefault) {
        SYSTEM_DEFAULT = systemDefault;
    }

    public static synchronized Config getSystemDefault() {
        return SYSTEM_DEFAULT;
    }

    private static synchronized Config findSystemDefault() {
        for (String n : Config.getCandidateSystemDefaultConfigNames()) {
            Config config = Config.find(n);
            if (config == null) continue;
            if (!DISABLE_AUTO_SYSTEM_PROPS) {
                config.setSystemProperties();
            }
            return config;
        }
        return null;
    }

    public static synchronized List<String> getCandidateSystemDefaultConfigNames() {
        ArrayList<String> l = CollectionUtils.list(new String[0]);
        String s = System.getProperty("juneau.configFile");
        if (s != null) {
            l.add(s);
            return l;
        }
        String cmd = System.getProperty("sun.java.command", "not_found").split("\\s+")[0];
        if (cmd.endsWith(".jar") && !cmd.contains("surefirebooter")) {
            cmd = cmd.replaceAll(".*?([^\\\\\\/]+)\\.jar$", "$1");
            l.add(cmd + ".cfg");
            cmd = cmd.replaceAll("[\\.\\_].*$", "");
            l.add(cmd + ".cfg");
        }
        TreeSet<File> files = CollectionUtils.sortedSet(new File(".").listFiles());
        for (File f : files) {
            if (!f.getName().endsWith(".cfg")) continue;
            l.add(f.getName());
        }
        l.add("juneau.cfg");
        l.add("default.cfg");
        l.add("application.cfg");
        l.add("app.cfg");
        l.add("settings.cfg");
        l.add("application.properties");
        return l;
    }

    private static synchronized Config find(String name) {
        if (name == null) {
            return null;
        }
        if (FileStore.DEFAULT.exists(name)) {
            return Config.create(name).store(FileStore.DEFAULT).build();
        }
        if (ClasspathStore.DEFAULT.exists(name)) {
            return Config.create(name).store(ClasspathStore.DEFAULT).build();
        }
        return null;
    }

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(String name) {
        return new Builder().name(name);
    }

    @Override
    public Builder copy() {
        return new Builder(this);
    }

    public Config(Builder builder) throws IOException {
        super(builder);
        this.name = builder.name;
        this.store = builder.store;
        this.configMap = this.store.getMap(this.name);
        this.configMap.register(this);
        this.serializer = builder.serializer;
        this.parser = builder.parser;
        this.beanSession = this.parser.getBeanContext().getSession();
        this.mods = CollectionUtils.unmodifiable(CollectionUtils.copyOf(builder.mods));
        this.varResolver = builder.varResolver;
        this.varSession = ((VarResolver)this.varResolver.copy().vars(ConfigVar.class).bean(Config.class, this).build()).createSession();
        this.binaryLineLength = builder.binaryLineLength;
        this.binaryFormat = builder.binaryFormat;
        this.multiLineValuesOnSeparateLines = builder.multiLineValuesOnSeparateLines;
        this.readOnly = builder.readOnly;
    }

    Config(Config copyFrom, VarResolverSession varSession) {
        super(copyFrom);
        this.name = copyFrom.name;
        this.store = copyFrom.store;
        this.configMap = copyFrom.configMap;
        this.configMap.register(this);
        this.serializer = copyFrom.serializer;
        this.parser = copyFrom.parser;
        this.mods = copyFrom.mods;
        this.varResolver = copyFrom.varResolver;
        this.varSession = varSession;
        this.binaryLineLength = copyFrom.binaryLineLength;
        this.binaryFormat = copyFrom.binaryFormat;
        this.multiLineValuesOnSeparateLines = copyFrom.multiLineValuesOnSeparateLines;
        this.readOnly = copyFrom.readOnly;
        this.beanSession = copyFrom.beanSession;
    }

    public Config resolving(VarResolverSession varSession) {
        return new Config(this, varSession);
    }

    public String getName() {
        return this.name;
    }

    private String getRaw(String key) {
        String skey;
        String sname = this.sname(key);
        ConfigMapEntry ce = this.configMap.getEntry(sname, skey = this.skey(key));
        if (ce == null) {
            return null;
        }
        return this.removeMods(ce.getModifiers(), ce.getValue());
    }

    String applyMods(String mods, String x) {
        if (mods != null && x != null) {
            for (int i = 0; i < mods.length(); ++i) {
                x = this.getMod(mods.charAt(i)).doApply(x);
            }
        }
        return x;
    }

    String removeMods(String mods, String x) {
        if (mods != null && x != null) {
            for (int i = mods.length() - 1; i > -1; --i) {
                x = this.getMod(mods.charAt(i)).doRemove(x);
            }
        }
        return x;
    }

    Mod getMod(char id) {
        Mod x = this.mods.get(Character.valueOf(id));
        return x == null ? Mod.NO_OP : x;
    }

    public Config setSystemProperties() {
        for (String section : this.getSectionNames()) {
            for (String key : this.getKeys(section)) {
                String k = section.isEmpty() ? key : section + "/" + key;
                System.setProperty(k, this.getRaw(k));
            }
        }
        return this;
    }

    public Config set(String key, String value) {
        this.checkWrite();
        ArgUtils.assertArgNotNull("key", key);
        String sname = this.sname(key);
        String skey = this.skey(key);
        ConfigMapEntry ce = this.configMap.getEntry(sname, skey);
        if (ce == null && value == null) {
            return this;
        }
        String s = this.applyMods(ce == null ? null : ce.getModifiers(), StringUtils.stringify(value));
        this.configMap.setEntry(sname, skey, s, null, null, null);
        return this;
    }

    public Config set(String key, Object value) throws SerializeException {
        return this.set(key, value, null);
    }

    public Config set(String key, Object value, Serializer serializer) throws SerializeException {
        return this.set(key, this.serialize(value, serializer));
    }

    public Config set(String key, Object value, Serializer serializer, String modifiers, String comment, List<String> preLines) throws SerializeException {
        this.checkWrite();
        ArgUtils.assertArgNotNull("key", key);
        String sname = this.sname(key);
        String skey = this.skey(key);
        modifiers = StringUtils.nullIfEmpty(modifiers);
        String s = this.applyMods(modifiers, this.serialize(value, serializer));
        this.configMap.setEntry(sname, skey, s, modifiers, comment, preLines);
        return this;
    }

    public Config remove(String key) {
        this.checkWrite();
        String sname = this.sname(key);
        String skey = this.skey(key);
        this.configMap.removeEntry(sname, skey);
        return this;
    }

    public Config applyMods() {
        this.checkWrite();
        for (String section : this.configMap.getSections()) {
            for (String key : this.configMap.getKeys(section)) {
                ConfigMapEntry ce = this.configMap.getEntry(section, key);
                if (ce.getModifiers() == null) continue;
                String mods = ce.getModifiers();
                String value = ce.getValue();
                for (int i = 0; i < mods.length(); ++i) {
                    Mod mod = this.getMod(mods.charAt(i));
                    if (mod.isApplied(value)) continue;
                    this.configMap.setEntry(section, key, mod.apply(value), null, null, null);
                }
            }
        }
        return this;
    }

    public Entry get(String key) {
        return new Entry(this, this.configMap, this.sname(key), this.skey(key));
    }

    public String getString(String key) {
        return new Entry(this, this.configMap, this.sname(key), this.skey(key)).orElse(null);
    }

    public Section getSection(String name) {
        return new Section(this, this.configMap, StringUtils.emptyIfNull(name));
    }

    public Set<String> getKeys(String section) {
        return this.configMap.getKeys(this.section(section));
    }

    public Set<String> getSectionNames() {
        return CollectionUtils.unmodifiable(this.configMap.getSections());
    }

    public boolean exists(String key) {
        return StringUtils.isNotEmpty(this.get(key).as(String.class).orElse(null));
    }

    public Config setSection(String name, List<String> preLines) {
        try {
            return this.setSection(this.section(name), preLines, null);
        }
        catch (SerializeException e) {
            throw ThrowableUtils.asRuntimeException(e);
        }
    }

    public Config setSection(String name, List<String> preLines, Map<String, Object> contents) throws SerializeException {
        this.checkWrite();
        this.configMap.setSection(this.section(name), preLines);
        if (contents != null) {
            for (Map.Entry<String, Object> e : contents.entrySet()) {
                this.set(this.section(name) + "/" + e.getKey(), e.getValue());
            }
        }
        return this;
    }

    public Config removeSection(String name) {
        this.checkWrite();
        this.configMap.removeSection(name);
        return this;
    }

    public Config setImport(String sectionName, String importName, List<String> preLines) {
        this.checkWrite();
        this.configMap.setImport(this.section(this.name), importName, preLines);
        return this;
    }

    public Config removeImport(String sectionName, String importName) {
        this.checkWrite();
        this.configMap.removeImport(sectionName, importName);
        return this;
    }

    public Config load(Map<String, Map<String, Object>> m) throws SerializeException {
        if (m != null) {
            for (Map.Entry<String, Map<String, Object>> e : m.entrySet()) {
                this.setSection(e.getKey(), null, e.getValue());
            }
        }
        return this;
    }

    public Config commit() throws IOException {
        this.checkWrite();
        this.configMap.commit();
        return this;
    }

    public Writer writeTo(Writer w) throws IOException {
        return this.configMap.writeTo(w);
    }

    public synchronized Config addListener(ConfigEventListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public synchronized Config removeListener(ConfigEventListener listener) {
        this.listeners.remove(listener);
        return this;
    }

    public void close() throws IOException {
        this.configMap.unregister(this);
    }

    public Config load(Reader contents, boolean synchronous) throws IOException, InterruptedException {
        this.checkWrite();
        this.configMap.load(IOUtils.read(contents), synchronous);
        return this;
    }

    public Config load(String contents, boolean synchronous) throws IOException, InterruptedException {
        this.checkWrite();
        this.configMap.load(contents, synchronous);
        return this;
    }

    public Config rollback() {
        this.checkWrite();
        this.configMap.rollback();
        return this;
    }

    public JsonMap toMap() {
        return this.configMap.asMap();
    }

    ConfigMap getConfigMap() {
        return this.configMap;
    }

    List<ConfigEventListener> getListeners() {
        return CollectionUtils.unmodifiable(this.listeners);
    }

    @Override
    public synchronized void onConfigChange(ConfigEvents events) {
        for (ConfigEventListener l : this.listeners) {
            l.onConfigChange(events);
        }
    }

    private String serialize(Object value, Serializer serializer) throws SerializeException {
        if (value == null) {
            return "";
        }
        if (serializer == null) {
            serializer = this.serializer;
        }
        Class<?> c = value.getClass();
        if (value instanceof CharSequence) {
            return this.nlIfMl((CharSequence)value);
        }
        if (this.isSimpleType(c)) {
            return value.toString();
        }
        if (value instanceof byte[]) {
            String s = null;
            byte[] b = (byte[])value;
            s = this.binaryFormat == BinaryFormat.HEX ? StringUtils.toHex(b) : (this.binaryFormat == BinaryFormat.SPACED_HEX ? StringUtils.toSpacedHex(b) : StringUtils.base64Encode(b));
            int l = this.binaryLineLength;
            if (l <= 0 || s.length() <= l) {
                return s;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < s.length(); i += l) {
                sb.append(this.binaryLineLength > 0 ? "\n" : "").append(s.substring(i, Math.min(s.length(), i + l)));
            }
            return sb.toString();
        }
        Object r = null;
        r = this.multiLineValuesOnSeparateLines ? "\n" + (String)serializer.serialize(value) : (String)serializer.serialize(value);
        if (((String)r).startsWith("'")) {
            return ((String)r).substring(1, ((String)r).length() - 1);
        }
        return r;
    }

    private String nlIfMl(CharSequence cs) {
        String s = cs.toString();
        if (s.indexOf(10) != -1 && this.multiLineValuesOnSeparateLines) {
            return "\n" + s;
        }
        return s;
    }

    private boolean isSimpleType(Type t) {
        if (!(t instanceof Class)) {
            return false;
        }
        Class c = (Class)t;
        return c == String.class || c.isPrimitive() || c.isAssignableFrom(Number.class) || c == Boolean.class || c.isEnum();
    }

    private String sname(String key) {
        ArgUtils.assertArgNotNull("key", key);
        int i = key.indexOf(47);
        if (i == -1) {
            return "";
        }
        return key.substring(0, i);
    }

    private String skey(String key) {
        int i = key.indexOf(47);
        if (i == -1) {
            return key;
        }
        return key.substring(i + 1);
    }

    private String section(String section) {
        ArgUtils.assertArgNotNull("section", section);
        if (StringUtils.isEmpty(section)) {
            return "";
        }
        return section;
    }

    void checkWrite() {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Cannot call this method on a read-only configuration.");
        }
    }

    @Override
    public String toString() {
        return this.configMap.toString();
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    @FluentSetters
    public static class Builder
    extends Context.Builder {
        String name;
        ConfigStore store;
        WriterSerializer serializer;
        ReaderParser parser;
        Map<Character, Mod> mods;
        VarResolver varResolver;
        int binaryLineLength;
        BinaryFormat binaryFormat;
        boolean multiLineValuesOnSeparateLines;
        boolean readOnly;

        protected Builder() {
            this.name = this.env("Config.name", "Configuration.cfg");
            this.store = FileStore.DEFAULT;
            this.serializer = Json5Serializer.DEFAULT;
            this.parser = JsonParser.DEFAULT;
            this.mods = CollectionUtils.map();
            this.mods(XorEncodeMod.INSTANCE);
            this.varResolver = VarResolver.DEFAULT;
            this.binaryLineLength = this.env("Config.binaryLineLength", -1);
            this.binaryFormat = this.env("Config.binaryFormat", BinaryFormat.BASE64);
            this.multiLineValuesOnSeparateLines = this.env("Config.multiLineValuesOnSeparateLines", false);
            this.readOnly = this.env("Config.readOnly", false);
        }

        protected Builder(Config copyFrom) {
            super(copyFrom);
            this.name = copyFrom.name;
            this.store = copyFrom.store;
            this.serializer = copyFrom.serializer;
            this.parser = copyFrom.parser;
            this.mods = CollectionUtils.copyOf(copyFrom.mods);
            this.varResolver = copyFrom.varResolver;
            this.binaryLineLength = copyFrom.binaryLineLength;
            this.binaryFormat = copyFrom.binaryFormat;
            this.multiLineValuesOnSeparateLines = copyFrom.multiLineValuesOnSeparateLines;
            this.readOnly = copyFrom.readOnly;
        }

        protected Builder(Builder copyFrom) {
            super(copyFrom);
            this.name = copyFrom.name;
            this.store = copyFrom.store;
            this.serializer = copyFrom.serializer;
            this.parser = copyFrom.parser;
            this.mods = CollectionUtils.copyOf(copyFrom.mods);
            this.varResolver = copyFrom.varResolver;
            this.binaryLineLength = copyFrom.binaryLineLength;
            this.binaryFormat = copyFrom.binaryFormat;
            this.multiLineValuesOnSeparateLines = copyFrom.multiLineValuesOnSeparateLines;
            this.readOnly = copyFrom.readOnly;
        }

        @Override
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        public Config build() {
            return this.build(Config.class);
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder store(ConfigStore value) {
            this.store = value;
            return this;
        }

        public Builder memStore() {
            this.store = MemoryStore.DEFAULT;
            return this;
        }

        public Builder serializer(WriterSerializer value) {
            this.serializer = value;
            return this;
        }

        public Builder parser(ReaderParser value) {
            this.parser = value;
            return this;
        }

        public Builder mods(Mod ... values) {
            for (Mod value : values) {
                this.mods.put(Character.valueOf(value.getId()), value);
            }
            return this;
        }

        public Builder varResolver(VarResolver value) {
            this.varResolver = value;
            return this;
        }

        public Builder binaryLineLength(int value) {
            this.binaryLineLength = value;
            return this;
        }

        public Builder binaryFormat(BinaryFormat value) {
            this.binaryFormat = value;
            return this;
        }

        public Builder multiLineValuesOnSeparateLines() {
            this.multiLineValuesOnSeparateLines = true;
            return this;
        }

        public Builder readOnly() {
            this.readOnly = true;
            return this;
        }

        @Override
        public Builder annotations(Annotation ... values) {
            super.annotations(values);
            return this;
        }

        @Override
        public Builder apply(AnnotationWorkList work) {
            super.apply(work);
            return this;
        }

        @Override
        public Builder applyAnnotations(Class<?> ... fromClasses) {
            super.applyAnnotations(fromClasses);
            return this;
        }

        @Override
        public Builder applyAnnotations(Method ... fromMethods) {
            super.applyAnnotations(fromMethods);
            return this;
        }

        @Override
        public Builder cache(Cache<HashKey, ? extends Context> value) {
            super.cache(value);
            return this;
        }

        @Override
        public Builder debug() {
            super.debug();
            return this;
        }

        @Override
        public Builder debug(boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder impl(Context value) {
            super.impl(value);
            return this;
        }

        @Override
        public Builder type(Class<? extends Context> value) {
            super.type(value);
            return this;
        }
    }
}

