/* 
    Licensed to the Apache Software Foundation (ASF) under one
    or more contributor license agreements.  See the NOTICE file
    distributed with this work for additional information
    regarding copyright ownership.  The ASF licenses this file
    to you under the Apache License, Version 2.0 (the
    "License"); you may not use this file except in compliance
    with the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied.  See the License for the
    specific language governing permissions and limitations
    under the License.  
 */
package org.apache.wiki.tasks;

import org.apache.wiki.workflow.Step;

import java.security.Principal;
import java.util.Locale;

/**
 * Manager responsible of creation of the different JSPWiki {@link Step}s.
 * 
 * Instances of classes generated by this TasksManager are assumed to have been added to an approval workflow via 
 * {@link org.apache.wiki.workflow.WorkflowBuilder#buildApprovalWorkflow(Principal, String, Step, String, org.apache.wiki.workflow.Fact[], Step, String)};
 * they will not function correctly otherwise.
 */
public interface TasksManager {

    /** The message key for storing the text for the presave task.  Value is <tt>{@value}</tt>. */
    String WIKIPAGE_PRESAVE_TASK_MESSAGE_KEY = "task.preSaveWikiPage";
    /** The message key of the text to finally approve a page save.  Value is <tt>{@value}</tt>. */
    String WIKIPAGE_SAVE_TASK_MESSAGE_KEY = "task.saveWikiPage";
    /** The message key of the text to finally approve a user profile save.  Value is <tt>{@value}</tt>. */
    String USER_PROFILE_SAVE_TASK_MESSAGE_KEY = "task.createUserProfile";
    
    /**
     * Builds a pre-save WikiPage task.
     * 
     * @param proposedText text proposed to be saved on the wiki page.
     * @return a pre-save WikiPage task.
     */
    Step buildPreSaveWikiPageTask( String proposedText );
    
    /**
     * Builds a save WikiPage task.
     *
     * @return a save WikiPage task.
     */
    Step buildSaveWikiPageTask();
    
    /**
     * Builds a save user profile task.
     * 
     * @param loc text proposed to be saved on the wiki page.
     * @return a save user profile task.
     */
    Step buildSaveUserProfileTask( Locale loc );
    
}
