/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.transitiveReasoner;

import org.apache.jena.graph.Capabilities;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.reasoner.BaseInfGraph;
import org.apache.jena.reasoner.FGraph;
import org.apache.jena.reasoner.Finder;
import org.apache.jena.reasoner.IllegalParameterException;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.ReasonerException;
import org.apache.jena.reasoner.ReasonerFactory;
import org.apache.jena.reasoner.ReasonerRegistry;
import org.apache.jena.reasoner.transitiveReasoner.TransitiveEngine;
import org.apache.jena.reasoner.transitiveReasoner.TransitiveGraphCache;
import org.apache.jena.reasoner.transitiveReasoner.TransitiveInfGraph;
import org.apache.jena.reasoner.transitiveReasoner.TransitiveReasonerFactory;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.ReasonerVocabulary;

public class TransitiveReasoner
implements Reasoner {
    protected TransitiveGraphCache subClassCache;
    protected TransitiveGraphCache subPropertyCache;
    protected Finder tbox = null;
    public static final Node directSubPropertyOf = ReasonerRegistry.makeDirect(RDFS.Nodes.subPropertyOf);
    public static final Node directSubClassOf = ReasonerRegistry.makeDirect(RDFS.Nodes.subClassOf);
    public static final Node subPropertyOf = RDFS.Nodes.subPropertyOf;
    public static final Node subClassOf = RDFS.Nodes.subClassOf;

    public TransitiveReasoner() {
        this.subClassCache = new TransitiveGraphCache(directSubClassOf, subClassOf);
        this.subPropertyCache = new TransitiveGraphCache(directSubPropertyOf, subPropertyOf);
    }

    protected TransitiveReasoner(Finder tbox, TransitiveGraphCache subClassCache, TransitiveGraphCache subPropertyCache) {
        this.tbox = tbox;
        this.subClassCache = subClassCache;
        this.subPropertyCache = subPropertyCache;
    }

    @Override
    public Model getReasonerCapabilities() {
        return TransitiveReasonerFactory.theInstance().getCapabilities();
    }

    @Override
    public void addDescription(Model configSpec, Resource base) {
    }

    @Override
    public boolean supportsProperty(Property property) {
        ReasonerFactory rf = TransitiveReasonerFactory.theInstance();
        Model caps = rf.getCapabilities();
        Resource root2 = caps.getResource(rf.getURI());
        return caps.contains(root2, ReasonerVocabulary.supportsP, property);
    }

    @Override
    public Reasoner bindSchema(Graph tbox) throws ReasonerException {
        return this.bindSchema(new FGraph(tbox));
    }

    @Override
    public Reasoner bindSchema(Model tbox) throws ReasonerException {
        return this.bindSchema(new FGraph(tbox.getGraph()));
    }

    Reasoner bindSchema(Finder tbox) throws ReasonerException {
        if (this.tbox != null) {
            throw new ReasonerException("Attempt to bind multiple rulesets - disallowed for now");
        }
        TransitiveGraphCache sCc = new TransitiveGraphCache(directSubClassOf, subClassOf);
        TransitiveGraphCache sPc = new TransitiveGraphCache(directSubPropertyOf, subPropertyOf);
        TransitiveEngine.cacheSubPropUtility(tbox, sPc);
        TransitiveEngine.cacheSubClassUtility(tbox, sPc, sCc);
        return new TransitiveReasoner(tbox, sCc, sPc);
    }

    @Override
    public InfGraph bind(Graph data) throws ReasonerException {
        return new TransitiveInfGraph(data, this);
    }

    @Override
    public void setDerivationLogging(boolean logOn) {
    }

    @Override
    public void setParameter(Property parameter, Object value) {
        throw new IllegalParameterException(parameter.toString());
    }

    public TransitiveGraphCache getSubPropertyCache() {
        return this.subPropertyCache;
    }

    public TransitiveGraphCache getSubClassCache() {
        return this.subClassCache;
    }

    public Finder getTbox() {
        return this.tbox;
    }

    @Override
    @Deprecated
    public Capabilities getGraphCapabilities() {
        return BaseInfGraph.reasonerInfCapabilities;
    }
}

