/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.fuseki.DEF;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.BaseActionREST;
import org.apache.jena.fuseki.servlets.GraphTarget;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.shacl.ShaclValidator;
import org.apache.jena.shacl.Shapes;
import org.apache.jena.shacl.ValidationReport;

public class SHACL_Validation
extends BaseActionREST {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPost(HttpAction action) {
        MediaType mediaType = ActionLib.contentNegotation(action, DEF.rdfOffer, DEF.acceptTurtle);
        Lang lang = RDFLanguages.contentTypeToLang(mediaType.getContentTypeStr());
        if (lang == null) {
            lang = RDFLanguages.TTL;
        }
        String targetNodeStr = action.getRequestParameter("target");
        action.beginRead();
        try {
            ValidationReport report;
            GraphTarget graphTarget = GraphTarget.determineTarget(action.getActiveDSG(), action);
            if (!graphTarget.exists()) {
                ServletOps.errorNotFound("No data graph: " + graphTarget.label());
            }
            Graph data = graphTarget.graph();
            Graph shapesGraph = ActionLib.readFromRequest(action, Lang.TTL);
            Node targetNode = null;
            if (targetNodeStr != null) {
                String x = data.getPrefixMapping().expandPrefix(targetNodeStr);
                targetNode = NodeFactory.createURI(x);
            }
            Shapes shapes = Shapes.parse(shapesGraph);
            ValidationReport validationReport = report = targetNode == null ? ShaclValidator.get().validate(shapesGraph, data) : ShaclValidator.get().validate(shapesGraph, data, targetNode);
            if (report.conforms()) {
                action.log.info(String.format("[%d] shacl: conforms", action.id));
            } else {
                action.log.info(String.format("[%d] shacl: %d validation errors", action.id, report.getEntries().size()));
            }
            report.getEntries().size();
            action.setResponseStatus(200);
            ActionLib.graphResponse(action, report.getGraph(), lang);
        }
        finally {
            action.endRead();
        }
    }
}

