/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mod.shiro;

import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.apache.jena.atlas.io.IOX;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.cmd.CmdGeneral;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.main.FusekiServer;
import org.apache.jena.fuseki.main.cmds.ServerArgs;
import org.apache.jena.fuseki.main.sys.FusekiModule;
import org.apache.jena.fuseki.mod.shiro.FusekiShiroLib;
import org.apache.jena.rdf.model.Model;
import org.apache.shiro.lang.io.ResourceUtils;
import org.apache.shiro.web.servlet.ShiroFilter;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.SessionHandler;
import org.eclipse.jetty.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FMod_Shiro
implements FusekiModule {
    public static final Logger shiroConfigLog = LoggerFactory.getLogger("org.apache.jena.fuseki.Shiro");
    private static List<String> iniFileLocations = null;
    private static ArgDecl argShiroIni = new ArgDecl(true, "shiro", "shiro-ini");
    private String shiroFile = null;

    @Override
    public String name() {
        return "FMod Shiro";
    }

    public static FMod_Shiro create() {
        return new FMod_Shiro();
    }

    public FMod_Shiro() {
        this(null);
    }

    public FMod_Shiro(String shiroFile) {
        this.shiroFile = shiroFile;
    }

    @Override
    public void serverArgsModify(CmdGeneral fusekiCmd, ServerArgs serverArgs) {
        fusekiCmd.add(argShiroIni);
    }

    @Override
    public void serverArgsPrepare(CmdGeneral fusekiCmd, ServerArgs serverArgs) {
        if (fusekiCmd.contains(argShiroIni)) {
            this.shiroFile = fusekiCmd.getValue(argShiroIni);
            Path path = Path.of(this.shiroFile, new String[0]);
            IOX.checkReadableFile(path, CmdException::new);
        }
    }

    @Override
    public void prepare(FusekiServer.Builder serverBuilder, Set<String> datasetNames, Model configModel) {
        if (this.shiroFile == null) {
            this.shiroFile = Lib.getenv("FUSEKI_SHIRO");
        }
        if (this.shiroFile == null) {
            return;
        }
        if (this.shiroFile != null) {
            String shiroResourceName = FusekiShiroLib.withResourcePrefix(this.shiroFile);
            if (!ResourceUtils.resourceExists(shiroResourceName)) {
                throw new FusekiConfigException("Shiro resource does not exist");
            }
            FusekiShiroFilter filter = new FusekiShiroFilter(shiroResourceName);
            serverBuilder.addFilter("/*", filter);
        }
        this.shiroFile = null;
    }

    @Override
    public void serverBeforeStarting(FusekiServer server) {
        Server jettyServer = server.getJettyServer();
        try {
            ServletContextHandler servletContextHandler = (ServletContextHandler)jettyServer.getHandler();
            if (servletContextHandler.getSessionHandler() == null) {
                SessionHandler sessionsHandler = new SessionHandler();
                servletContextHandler.setHandler(sessionsHandler);
            }
        }
        catch (RuntimeException ex) {
            shiroConfigLog.error("Failed to set a session manager - server aborted");
            throw ex;
        }
    }

    private static class FusekiShiroFilter
    extends ShiroFilter {
        private final String shiroInitializationResource;

        FusekiShiroFilter(String shiroResourceName) {
            this.shiroInitializationResource = shiroResourceName;
        }

        @Override
        public void init() throws Exception {
            List<String> locations = List.of();
            if (this.shiroInitializationResource != null) {
                locations = List.of(this.shiroInitializationResource);
            }
            FusekiShiroLib.shiroEnvironment(this.getServletContext(), locations);
            super.init();
        }
    }
}

