/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.path.eval;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.ARQNotImplemented;
import org.apache.jena.sparql.path.P_Alt;
import org.apache.jena.sparql.path.P_Distinct;
import org.apache.jena.sparql.path.P_FixedLength;
import org.apache.jena.sparql.path.P_Inverse;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_Mod;
import org.apache.jena.sparql.path.P_Multi;
import org.apache.jena.sparql.path.P_NegPropSet;
import org.apache.jena.sparql.path.P_OneOrMore1;
import org.apache.jena.sparql.path.P_OneOrMoreN;
import org.apache.jena.sparql.path.P_ReverseLink;
import org.apache.jena.sparql.path.P_Seq;
import org.apache.jena.sparql.path.P_Shortest;
import org.apache.jena.sparql.path.P_ZeroOrMore1;
import org.apache.jena.sparql.path.P_ZeroOrMoreN;
import org.apache.jena.sparql.path.P_ZeroOrOne;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathVisitor;
import org.apache.jena.sparql.path.eval.PathEngine;
import org.apache.jena.sparql.path.eval.PathEngine1;
import org.apache.jena.sparql.path.eval.PathEngineN;
import org.apache.jena.sparql.sse.writers.WriterPath;

final class PathEvaluator
implements PathVisitor {
    protected final Graph graph;
    protected final Node node;
    protected final Collection<Node> output;
    private PathEngine engine;

    protected PathEvaluator(Graph g, Node n, Collection<Node> output, PathEngine engine) {
        this.graph = g;
        this.node = n;
        this.output = output;
        this.engine = engine;
    }

    protected final void fill(Iterator<Node> iter) {
        while (iter.hasNext()) {
            this.output.add(iter.next());
        }
    }

    @Override
    public void visit(P_Link pathNode) {
        Iterator<Node> nodes = this.engine.doOne(this.node, pathNode.getNode());
        this.fill(nodes);
    }

    @Override
    public void visit(P_ReverseLink pathNode) {
        this.engine.flipDirection();
        Iterator<Node> nodes = this.engine.doOne(this.node, pathNode.getNode());
        this.fill(nodes);
        this.engine.flipDirection();
    }

    @Override
    public void visit(P_Inverse inversePath) {
        this.engine.flipDirection();
        this.engine.eval(inversePath.getSubPath(), this.node, this.output);
        this.engine.flipDirection();
    }

    @Override
    public void visit(P_NegPropSet pathNotOneOf) {
        this.engine.doNegatedPropertySet(pathNotOneOf, this.node, this.output);
    }

    @Override
    public void visit(P_Mod pathMod) {
        if (pathMod.isZeroOrMore()) {
            this.engine.doOneOrMoreN(pathMod.getSubPath(), this.node, this.output);
            return;
        }
        if (pathMod.isOneOrMore()) {
            this.engine.doOneOrMoreN(pathMod.getSubPath(), this.node, this.output);
            return;
        }
        if (pathMod.isFixedLength()) {
            this.engine.doFixedLengthPath(pathMod.getSubPath(), this.node, pathMod.getFixedLength(), this.output);
        } else {
            this.engine.doMultiLengthPath(pathMod.getSubPath(), this.node, pathMod.getMin(), pathMod.getMax(), this.output);
        }
    }

    @Override
    public void visit(P_FixedLength pFixedLength) {
        this.engine.doFixedLengthPath(pFixedLength.getSubPath(), this.node, pFixedLength.getCount(), this.output);
    }

    @Override
    public void visit(P_ZeroOrOne path) {
        this.engine.doZeroOrOne(path.getSubPath(), this.node, this.output);
    }

    @Override
    public void visit(P_ZeroOrMore1 path) {
        this.engine.doZeroOrMore(path.getSubPath(), this.node, this.output);
    }

    @Override
    public void visit(P_ZeroOrMoreN path) {
        this.engine.doZeroOrMoreN(path.getSubPath(), this.node, this.output);
    }

    @Override
    public void visit(P_OneOrMore1 path) {
        this.engine.doOneOrMore(path.getSubPath(), this.node, this.output);
    }

    @Override
    public void visit(P_OneOrMoreN path) {
        this.engine.doOneOrMoreN(path.getSubPath(), this.node, this.output);
    }

    @Override
    public void visit(P_Alt pathAlt) {
        this.engine.doAlt(pathAlt.getLeft(), pathAlt.getRight(), this.node, this.output);
    }

    @Override
    public void visit(P_Distinct pathDistinct) {
        PathEngine engine2 = this.engine;
        this.engine = new PathEngine1(this.graph, this.engine.direction());
        this.engine.eval(pathDistinct.getSubPath(), this.node, this.output);
        this.engine = engine2;
    }

    @Override
    public void visit(P_Multi pathMulti) {
        PathEngine engine2 = this.engine;
        this.engine = new PathEngineN(this.graph, this.engine.direction());
        this.engine.eval(pathMulti.getSubPath(), this.node, this.output);
        this.engine = engine2;
    }

    @Override
    public void visit(P_Shortest path) {
        throw new ARQNotImplemented(WriterPath.asString(path));
    }

    @Override
    public void visit(P_Seq pathSeq) {
        this.engine.doSeq(pathSeq.getLeft(), pathSeq.getRight(), this.node, this.output);
    }

    protected final Iter<Triple> between(Node x, Node z) {
        return Iter.iter(this.engine.graphFind(x, Node.ANY, z));
    }

    protected final void doZero(Path path, Node node, Collection<Node> output) {
        output.add(node);
    }

    protected static class FilterExclude
    implements Predicate<Triple> {
        private Collection<Node> excludes;

        public FilterExclude(Collection<Node> excludes) {
            this.excludes = excludes;
        }

        @Override
        public boolean test(Triple triple) {
            return !this.excludes.contains(triple.getPredicate());
        }
    }
}

