/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.compact.reader;

import org.apache.jena.shacl.ShaclException;

public class ShaclcParseException
extends ShaclException {
    private int line;
    private int column;

    public ShaclcParseException(int line, int column) {
        this(null, null, line, column);
    }

    public ShaclcParseException(Throwable cause, int line, int column) {
        this(null, cause, line, column);
    }

    public ShaclcParseException(String msg, int line, int column) {
        this(msg, null, line, column);
    }

    public ShaclcParseException(String msg, Throwable cause, int line, int column) {
        super(msg, cause);
        this.set(line, column);
    }

    private void set(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public int getColumn() {
        return this.column;
    }

    public int getLine() {
        return this.line;
    }

    public static String formatMessage(String msg, int line, int column) {
        if (line == -1 || column == -1) {
            return msg;
        }
        return String.format("[line: %d, col: %d] " + msg, line, column);
    }
}

