/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.json;

import jakarta.json.stream.JsonParser;
import java.io.InputStream;
import java.io.Reader;
import org.opensearch.client.json.DelegatingDeserializer;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpMapperBase;
import org.opensearch.client.json.JsonpUtils;
import org.opensearch.client.json.ObjectDeserializer;

public interface PlainDeserializable<B> {
    public B self();

    default public B withJson(JsonParser parser, JsonpMapper mapper) {
        JsonpDeserializer<?> deserializer = JsonpMapperBase.findDeserializer(this.getClass().getEnclosingClass());
        ObjectDeserializer objectDeserializer = (ObjectDeserializer)DelegatingDeserializer.unwrap(deserializer);
        if (!1.$assertionsDisabled && objectDeserializer == null) {
            throw new AssertionError();
        }
        return objectDeserializer.deserialize(this.self(), parser, mapper, parser.next());
    }

    default public B withJson(InputStream inputStream) {
        JsonpMapper defaultMapper = JsonpUtils.DEFAULT_JSONP_MAPPER;
        try (JsonParser parser = defaultMapper.jsonProvider().createParser(inputStream);){
            B b = this.withJson(parser, defaultMapper);
            return b;
        }
    }

    default public B withJson(Reader reader) {
        JsonpMapper defaultMapper = JsonpUtils.DEFAULT_JSONP_MAPPER;
        try (JsonParser parser = defaultMapper.jsonProvider().createParser(reader);){
            B b = this.withJson(parser, defaultMapper);
            return b;
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

