/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.api;

import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import org.apache.james.jdkim.api.HashMethod;

public enum SigningAlgorithm {
    RSA{

        @Override
        public String asJdkSignatureAlgorithm(HashMethod hashMethod) {
            return hashMethod.name() + "with" + this.name();
        }
    };


    public String asTagValue() {
        return this.name().toLowerCase(Locale.US);
    }

    public abstract String asJdkSignatureAlgorithm(HashMethod var1);

    public static Optional<SigningAlgorithm> of(String signingAlgorithm) {
        return Arrays.stream(SigningAlgorithm.values()).filter(a -> a.name().toLowerCase(Locale.ROOT).equals(signingAlgorithm.toLowerCase(Locale.ROOT))).findFirst();
    }
}

