/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.mail.Flags;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.Header;
import org.apache.james.mailbox.model.Headers;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MimeDescriptor;
import org.apache.james.mailbox.model.MimePath;
import org.apache.james.mailbox.model.ThreadId;

public interface MessageResult
extends Comparable<MessageResult> {
    public MessageId getMessageId();

    public ThreadId getThreadId();

    public Optional<Date> getSaveDate();

    public Date getInternalDate();

    public Flags getFlags();

    public long getSize();

    public MessageMetaData messageMetaData();

    public MessageUid getUid();

    public ModSeq getModSeq();

    public MimeDescriptor getMimeDescriptor() throws MailboxException;

    public MailboxId getMailboxId();

    public Iterator<Header> iterateHeaders(MimePath var1) throws MailboxException;

    public Iterator<Header> iterateMimeHeaders(MimePath var1) throws MailboxException;

    public Content getFullContent() throws MailboxException, IOException;

    public Content getFullContent(MimePath var1) throws MailboxException;

    public Content getBody() throws MailboxException, IOException;

    public Content getBody(MimePath var1) throws MailboxException;

    public Content getMimeBody(MimePath var1) throws MailboxException;

    public Headers getHeaders() throws MailboxException;

    public List<MessageAttachmentMetadata> getLoadedAttachments() throws MailboxException;
}

