/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import org.apache.poi.hpsf.CustomProperties;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.NoPropertySetStreamException;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hpsf.UnexpectedPropertySetTypeException;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.DublinCore;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.OfficeOpenXMLCore;
import org.apache.tika.metadata.OfficeOpenXMLExtended;
import org.apache.tika.metadata.PagedText;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.microsoft.AbstractPOIFSExtractor;
import org.apache.tika.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SummaryExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPOIFSExtractor.class);
    private static final String SUMMARY_INFORMATION = "\u0005SummaryInformation";
    private static final String DOCUMENT_SUMMARY_INFORMATION = "\u0005DocumentSummaryInformation";
    private final Metadata metadata;

    public SummaryExtractor(Metadata metadata) {
        this.metadata = metadata;
    }

    public static void addMulti(Metadata metadata, Property property, String string) {
        if (StringUtils.isBlank(string)) {
            return;
        }
        String[] parts = string.split(";");
        String[] current = metadata.getValues(property);
        HashSet<String> seen = new HashSet<String>();
        if (current != null) {
            seen.addAll(Arrays.asList(current));
        }
        for (String part : parts) {
            if (seen.contains(part) || StringUtils.isBlank(part)) continue;
            metadata.add(property, part);
            seen.add(part);
        }
    }

    public void parseSummaries(POIFSFileSystem filesystem) throws IOException, TikaException {
        this.parseSummaries(filesystem.getRoot());
    }

    public void parseSummaries(DirectoryNode root) throws IOException, TikaException {
        this.parseSummaryEntryIfExists(root, SUMMARY_INFORMATION);
        this.parseSummaryEntryIfExists(root, DOCUMENT_SUMMARY_INFORMATION);
    }

    private void parseSummaryEntryIfExists(DirectoryNode root, String entryName) throws IOException, TikaException {
        try {
            if (!root.hasEntry(entryName)) {
                return;
            }
            DocumentEntry entry = (DocumentEntry)root.getEntry(entryName);
            PropertySet properties = new PropertySet(new DocumentInputStream(entry));
            if (properties.isSummaryInformation()) {
                this.parse(new SummaryInformation(properties));
            }
            if (properties.isDocumentSummaryInformation()) {
                this.parse(new DocumentSummaryInformation(properties));
            }
        }
        catch (FileNotFoundException entry) {
        }
        catch (NoPropertySetStreamException entry) {
        }
        catch (UnexpectedPropertySetTypeException e) {
            throw new TikaException("Unexpected HPSF document", e);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.warn("Ignoring unexpected exception while parsing summary entry {}", (Object)entryName, (Object)e);
        }
    }

    private void parse(SummaryInformation summary) {
        this.set(TikaCoreProperties.TITLE, summary.getTitle());
        SummaryExtractor.addMulti(this.metadata, TikaCoreProperties.CREATOR, summary.getAuthor());
        this.add(Office.KEYWORDS, summary.getKeywords());
        this.add(DublinCore.SUBJECT, summary.getSubject());
        this.set(TikaCoreProperties.MODIFIER, summary.getLastAuthor());
        this.set(TikaCoreProperties.COMMENTS, summary.getComments());
        this.set(OfficeOpenXMLExtended.TEMPLATE, summary.getTemplate());
        this.set(OfficeOpenXMLExtended.APPLICATION, summary.getApplicationName());
        this.set(OfficeOpenXMLCore.REVISION, summary.getRevNumber());
        this.set(TikaCoreProperties.CREATED, summary.getCreateDateTime());
        this.set(TikaCoreProperties.MODIFIED, summary.getLastSaveDateTime());
        this.set(TikaCoreProperties.PRINT_DATE, summary.getLastPrinted());
        this.set(OfficeOpenXMLExtended.TOTAL_TIME, Long.toString(summary.getEditTime()));
        this.set(OfficeOpenXMLExtended.DOC_SECURITY, summary.getSecurity());
        this.set(Office.WORD_COUNT, summary.getWordCount());
        this.set(Office.CHARACTER_COUNT, summary.getCharCount());
        this.set(Office.PAGE_COUNT, summary.getPageCount());
        if (summary.getPageCount() > 0) {
            this.metadata.set(PagedText.N_PAGES, summary.getPageCount());
        }
    }

    private void parse(DocumentSummaryInformation summary) {
        this.set(OfficeOpenXMLExtended.COMPANY, summary.getCompany());
        SummaryExtractor.addMulti(this.metadata, OfficeOpenXMLExtended.MANAGER, summary.getManager());
        this.set(TikaCoreProperties.LANGUAGE, this.getLanguage(summary));
        this.set(OfficeOpenXMLCore.CATEGORY, summary.getCategory());
        this.set(Office.SLIDE_COUNT, summary.getSlideCount());
        if (summary.getSlideCount() > 0) {
            this.metadata.set(PagedText.N_PAGES, summary.getSlideCount());
        }
        this.parse(summary.getCustomProperties());
    }

    private String getLanguage(DocumentSummaryInformation summary) {
        Object value;
        CustomProperties customProperties = summary.getCustomProperties();
        if (customProperties != null && (value = customProperties.get("Language")) instanceof String) {
            return (String)value;
        }
        return null;
    }

    private void parse(CustomProperties customProperties) {
        if (customProperties != null) {
            for (String name : customProperties.nameSet()) {
                Property prop;
                String key = "custom:" + name;
                Object value = customProperties.get(name);
                if (value instanceof String) {
                    this.set(key, (String)value);
                    continue;
                }
                if (value instanceof Date) {
                    prop = Property.externalDate(key);
                    this.metadata.set(prop, (Date)value);
                    continue;
                }
                if (value instanceof Boolean) {
                    prop = Property.externalBoolean(key);
                    this.metadata.set(prop, value.toString());
                    continue;
                }
                if (value instanceof Long) {
                    prop = Property.externalInteger(key);
                    this.metadata.set(prop, ((Long)value).intValue());
                    continue;
                }
                if (value instanceof Double) {
                    prop = Property.externalReal(key);
                    this.metadata.set(prop, (Double)value);
                    continue;
                }
                if (!(value instanceof Integer)) continue;
                prop = Property.externalInteger(key);
                this.metadata.set(prop, (Integer)value);
            }
        }
    }

    private void set(String name, String value) {
        if (!StringUtils.isBlank(value)) {
            this.metadata.set(name, value);
        }
    }

    private void set(Property property, String value) {
        if (!StringUtils.isBlank(value)) {
            this.metadata.set(property, value);
        }
    }

    private void add(Property property, String value) {
        if (!StringUtils.isBlank(value)) {
            this.metadata.add(property, value);
        }
    }

    private void set(Property property, Date value) {
        if (value != null) {
            this.metadata.set(property, value);
        }
    }

    private void set(Property property, int value) {
        if (value > 0) {
            this.metadata.set(property, value);
        }
    }

    private void set(String name, long value) {
        if (value > 0L) {
            this.metadata.set(name, Long.toString(value));
        }
    }
}

