/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import java.util.ArrayList;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.version.OnParentVersionAction;
import org.apache.jackrabbit.commons.webdav.NodeTypeConstants;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.nodetype.QItemDefinitionBuilder;
import org.apache.jackrabbit.spi.commons.nodetype.QNodeDefinitionBuilder;
import org.apache.jackrabbit.spi.commons.nodetype.QNodeTypeDefinitionBuilder;
import org.apache.jackrabbit.spi.commons.nodetype.QPropertyDefinitionBuilder;
import org.apache.jackrabbit.spi.commons.nodetype.constraint.ValueConstraint;
import org.apache.jackrabbit.spi.commons.value.ValueFactoryQImpl;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.ElementIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

class DefinitionUtil
implements NodeTypeConstants {
    private static Logger log = LoggerFactory.getLogger(DefinitionUtil.class);

    private DefinitionUtil() {
    }

    static QNodeDefinition createQNodeDefinition(Name declaringNodeType, Element ndefElement, NamePathResolver resolver) throws RepositoryException {
        QNodeDefinitionBuilder builder = new QNodeDefinitionBuilder();
        DefinitionUtil.buildQItemDefinition(declaringNodeType, ndefElement, resolver, builder);
        try {
            Element reqPrimaryTypes;
            if (ndefElement.hasAttribute("defaultPrimaryType")) {
                Name defaultPrimaryType = resolver.getQName(ndefElement.getAttribute("defaultPrimaryType"));
                builder.setDefaultPrimaryType(defaultPrimaryType);
            }
            if ((reqPrimaryTypes = DomUtil.getChildElement(ndefElement, "requiredPrimaryTypes", null)) != null) {
                ElementIterator it = DomUtil.getChildren(reqPrimaryTypes, "requiredPrimaryType", null);
                while (it.hasNext()) {
                    builder.addRequiredPrimaryType(resolver.getQName(DomUtil.getTextTrim(it.nextElement())));
                }
            } else {
                builder.addRequiredPrimaryType(NameConstants.NT_BASE);
            }
            if (ndefElement.hasAttribute("sameNameSiblings")) {
                builder.setAllowsSameNameSiblings(Boolean.valueOf(ndefElement.getAttribute("sameNameSiblings")));
            }
        }
        catch (NameException e) {
            throw new RepositoryException(e);
        }
        return builder.build();
    }

    static QPropertyDefinition createQPropertyDefinition(Name declaringNodeType, Element pdefElement, NamePathResolver resolver, QValueFactory qValueFactory) throws RepositoryException {
        ElementIterator it;
        QPropertyDefinitionBuilder builder = new QPropertyDefinitionBuilder();
        DefinitionUtil.buildQItemDefinition(declaringNodeType, pdefElement, resolver, builder);
        if (pdefElement.hasAttribute("requiredType")) {
            builder.setRequiredType(PropertyType.valueFromName(pdefElement.getAttribute("requiredType")));
        }
        if (pdefElement.hasAttribute("multiple")) {
            builder.setMultiple(Boolean.valueOf(pdefElement.getAttribute("multiple")));
        }
        if (pdefElement.hasAttribute("fullTextSearchable")) {
            builder.setFullTextSearchable(Boolean.valueOf(pdefElement.getAttribute("fullTextSearchable")));
        }
        if (pdefElement.hasAttribute("queryOrderable")) {
            builder.setQueryOrderable(Boolean.valueOf(pdefElement.getAttribute("queryOrderable")));
        }
        int requiredType = builder.getRequiredType();
        Element child = DomUtil.getChildElement(pdefElement, "defaultValues", null);
        if (child != null) {
            it = DomUtil.getChildren(child, "defaultValue", null);
            while (it.hasNext()) {
                QValue qValue;
                String jcrVal = DomUtil.getText(it.nextElement());
                if (jcrVal == null) {
                    jcrVal = "";
                }
                if (requiredType == 2) {
                    Value v = new ValueFactoryQImpl(qValueFactory, resolver).createValue(jcrVal, requiredType);
                    qValue = ValueFormat.getQValue(v, resolver, qValueFactory);
                } else {
                    qValue = ValueFormat.getQValue(jcrVal, requiredType, resolver, qValueFactory);
                }
                builder.addDefaultValue(qValue);
            }
        }
        if ((child = DomUtil.getChildElement(pdefElement, "valueConstraints", null)) != null) {
            it = DomUtil.getChildren(child, "valueConstraint", null);
            while (it.hasNext()) {
                String qValue = DomUtil.getText(it.nextElement());
                builder.addValueConstraint(ValueConstraint.create(requiredType, qValue, resolver));
            }
        }
        if ((child = DomUtil.getChildElement(pdefElement, "availableQueryOperators", null)) == null) {
            builder.setAvailableQueryOperators(new String[0]);
        } else {
            ArrayList<String> names = new ArrayList<String>();
            ElementIterator it2 = DomUtil.getChildren(child, "availableQueryOperator", null);
            while (it2.hasNext()) {
                String str = DomUtil.getText(it2.nextElement());
                names.add(str);
            }
            builder.setAvailableQueryOperators(names.toArray(new String[names.size()]));
        }
        return builder.build();
    }

    static QNodeTypeDefinition createQNodeTypeDefinition(Element ntdElement, NamePathResolver resolver, QValueFactory qValueFactory) throws RepositoryException {
        QNodeTypeDefinitionBuilder builder = new QNodeTypeDefinitionBuilder();
        try {
            Element child;
            if (ntdElement.hasAttribute("name")) {
                builder.setName(resolver.getQName(ntdElement.getAttribute("name")));
            }
            if (ntdElement.hasAttribute("primaryItemName")) {
                builder.setPrimaryItemName(resolver.getQName(ntdElement.getAttribute("primaryItemName")));
            }
            if ((child = DomUtil.getChildElement(ntdElement, "supertypes", null)) != null) {
                ElementIterator stIter = DomUtil.getChildren(child, "supertype", null);
                ArrayList<Name> qNames = new ArrayList<Name>();
                while (stIter.hasNext()) {
                    Name st = resolver.getQName(DomUtil.getTextTrim(stIter.nextElement()));
                    qNames.add(st);
                }
                builder.setSupertypes(qNames.toArray(new Name[qNames.size()]));
            }
            if (ntdElement.hasAttribute("isMixin")) {
                builder.setMixin(Boolean.valueOf(ntdElement.getAttribute("isMixin")));
            }
            if (ntdElement.hasAttribute("hasOrderableChildNodes")) {
                builder.setOrderableChildNodes(Boolean.valueOf(ntdElement.getAttribute("hasOrderableChildNodes")));
            }
            if (ntdElement.hasAttribute("isAbstract")) {
                builder.setAbstract(Boolean.valueOf(ntdElement.getAttribute("isAbstract")));
            }
            if (ntdElement.hasAttribute("isQueryable")) {
                builder.setQueryable(Boolean.valueOf(ntdElement.getAttribute("isQueryable")));
            }
            ElementIterator it = DomUtil.getChildren(ntdElement, "childNodeDefinition", null);
            ArrayList<QNodeDefinition> nds = new ArrayList<QNodeDefinition>();
            while (it.hasNext()) {
                nds.add(DefinitionUtil.createQNodeDefinition(builder.getName(), it.nextElement(), resolver));
            }
            builder.setChildNodeDefs(nds.toArray(new QNodeDefinition[nds.size()]));
            it = DomUtil.getChildren(ntdElement, "propertyDefinition", null);
            ArrayList<QPropertyDefinition> pds = new ArrayList<QPropertyDefinition>();
            while (it.hasNext()) {
                pds.add(DefinitionUtil.createQPropertyDefinition(builder.getName(), it.nextElement(), resolver, qValueFactory));
            }
            builder.setPropertyDefs(pds.toArray(new QPropertyDefinition[pds.size()]));
        }
        catch (NameException e) {
            log.error(e.getMessage());
            throw new RepositoryException(e);
        }
        return builder.build();
    }

    private static void buildQItemDefinition(Name declaringNodeType, Element itemDefElement, NamePathResolver resolver, QItemDefinitionBuilder builder) throws RepositoryException {
        try {
            String attr = itemDefElement.getAttribute("declaringNodeType");
            if (attr != null) {
                Name dnt = resolver.getQName(attr);
                if (declaringNodeType != null && !declaringNodeType.equals(dnt)) {
                    throw new RepositoryException("Declaring nodetype mismatch: In element = '" + String.valueOf(dnt) + "', Declaring nodetype = '" + String.valueOf(declaringNodeType) + "'");
                }
                builder.setDeclaringNodeType(dnt);
            } else {
                builder.setDeclaringNodeType(declaringNodeType);
            }
            if (itemDefElement.hasAttribute("name")) {
                String nAttr = itemDefElement.getAttribute("name");
                if (nAttr.length() > 0) {
                    builder.setName(DefinitionUtil.isAnyName(nAttr) ? NameConstants.ANY_NAME : resolver.getQName(nAttr));
                } else {
                    builder.setName(NameConstants.ROOT);
                }
            } else {
                builder.setName(NameConstants.ANY_NAME);
            }
        }
        catch (NameException e) {
            throw new RepositoryException(e);
        }
        if (itemDefElement.hasAttribute("autoCreated")) {
            builder.setAutoCreated(Boolean.valueOf(itemDefElement.getAttribute("autoCreated")));
        }
        if (itemDefElement.hasAttribute("mandatory")) {
            builder.setMandatory(Boolean.valueOf(itemDefElement.getAttribute("mandatory")));
        }
        if (itemDefElement.hasAttribute("protected")) {
            builder.setProtected(Boolean.valueOf(itemDefElement.getAttribute("protected")));
        }
        if (itemDefElement.hasAttribute("onParentVersion")) {
            builder.setOnParentVersion(OnParentVersionAction.valueFromName(itemDefElement.getAttribute("onParentVersion")));
        }
    }

    private static boolean isAnyName(String nameAttribute) {
        return NameConstants.ANY_NAME.getLocalName().equals(nameAttribute);
    }
}

