/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.jetbrains.annotations.Nullable;

public enum UserTokenType implements UaEnumeration
{
    Anonymous(0),
    UserName(1),
    Certificate(2),
    IssuedToken(3);

    private final int value;

    private UserTokenType(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Nullable
    public static UserTokenType from(int value) {
        switch (value) {
            case 0: {
                return Anonymous;
            }
            case 1: {
                return UserName;
            }
            case 2: {
                return Certificate;
            }
            case 3: {
                return IssuedToken;
            }
        }
        return null;
    }

    public static ExpandedNodeId getTypeId() {
        return ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=303");
    }

    public static class Codec
    extends GenericDataTypeCodec<UserTokenType> {
        @Override
        public Class<UserTokenType> getType() {
            return UserTokenType.class;
        }

        @Override
        public UserTokenType decode(SerializationContext context, UaDecoder decoder) {
            return decoder.readEnum(null, UserTokenType.class);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, UserTokenType value) {
            encoder.writeEnum(null, value);
        }
    }
}

