/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.quota;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TSpaceQuota;
import org.apache.iotdb.commons.utils.BasicStructureSerDeUtil;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;

public class SetSpaceQuotaPlan
extends ConfigPhysicalPlan {
    private List<String> prefixPathList;
    private TSpaceQuota spaceLimit;

    public SetSpaceQuotaPlan() {
        super(ConfigPhysicalPlanType.setSpaceQuota);
    }

    public SetSpaceQuotaPlan(List<String> prefixPathList, TSpaceQuota spaceLimit) {
        super(ConfigPhysicalPlanType.setSpaceQuota);
        this.prefixPathList = prefixPathList;
        this.spaceLimit = spaceLimit;
    }

    public List<String> getPrefixPathList() {
        return this.prefixPathList;
    }

    public void setPrefixPathList(List<String> prefixPathList) {
        this.prefixPathList = prefixPathList;
    }

    public TSpaceQuota getSpaceLimit() {
        return this.spaceLimit;
    }

    public void setSpaceLimit(TSpaceQuota spaceLimit) {
        this.spaceLimit = spaceLimit;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        BasicStructureSerDeUtil.write(this.prefixPathList, (DataOutputStream)stream);
        BasicStructureSerDeUtil.write((long)this.spaceLimit.getDeviceNum(), (DataOutputStream)stream);
        BasicStructureSerDeUtil.write((long)this.spaceLimit.getTimeserieNum(), (DataOutputStream)stream);
        BasicStructureSerDeUtil.write((long)this.spaceLimit.getDiskSize(), (DataOutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.prefixPathList = BasicStructureSerDeUtil.readStringList((ByteBuffer)buffer);
        long deviceNum = BasicStructureSerDeUtil.readLong((ByteBuffer)buffer);
        long timeSeriesNum = BasicStructureSerDeUtil.readLong((ByteBuffer)buffer);
        long disk = BasicStructureSerDeUtil.readLong((ByteBuffer)buffer);
        TSpaceQuota tSpaceQuota = new TSpaceQuota();
        tSpaceQuota.setDiskSize(disk);
        tSpaceQuota.setDeviceNum(deviceNum);
        tSpaceQuota.setTimeserieNum(timeSeriesNum);
        this.spaceLimit = tSpaceQuota;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SetSpaceQuotaPlan that = (SetSpaceQuotaPlan)o;
        return Objects.equals(this.prefixPathList, that.prefixPathList) && Objects.equals(this.spaceLimit, that.spaceLimit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.prefixPathList, this.spaceLimit);
    }
}

