/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.encoding.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import org.apache.tsfile.exception.encoding.TsFileEncodingException;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.utils.Binary;

public abstract class Encoder {
    public static final String MAX_STRING_LENGTH = "max_string_length";
    public static final String MAX_POINT_NUMBER = "max_point_number";
    private TSEncoding type;

    public void setType(TSEncoding type) {
        this.type = type;
    }

    public TSEncoding getType() {
        return this.type;
    }

    public Encoder(TSEncoding type) {
        this.type = type;
    }

    public void encode(boolean value, ByteArrayOutputStream out) {
        throw new TsFileEncodingException("Method encode boolean is not supported by Encoder");
    }

    public void encode(short value, ByteArrayOutputStream out) {
        throw new TsFileEncodingException("Method encode short is not supported by Encoder");
    }

    public void encode(int value, ByteArrayOutputStream out) {
        throw new TsFileEncodingException("Method encode int is not supported by Encoder");
    }

    public void encode(long value, ByteArrayOutputStream out) {
        throw new TsFileEncodingException("Method encode long is not supported by Encoder");
    }

    public void encode(float value, ByteArrayOutputStream out) {
        throw new TsFileEncodingException("Method encode float is not supported by Encoder");
    }

    public void encode(double value, ByteArrayOutputStream out) {
        throw new TsFileEncodingException("Method encode double is not supported by Encoder");
    }

    public void encode(Binary value, ByteArrayOutputStream out) {
        throw new TsFileEncodingException("Method encode Binary is not supported by Encoder");
    }

    public void encode(BigDecimal value, ByteArrayOutputStream out) {
        throw new TsFileEncodingException("Method encode BigDecimal is not supported by Encoder");
    }

    public abstract void flush(ByteArrayOutputStream var1) throws IOException;

    public int getOneItemMaxSize() {
        throw new UnsupportedOperationException();
    }

    public long getMaxByteSize() {
        throw new UnsupportedOperationException();
    }
}

