/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.template;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.isession.template.TemplateNode;
import org.apache.iotdb.rpc.StatementExecutionException;

public class InternalNode
extends TemplateNode {
    private Map<String, TemplateNode> children = new HashMap<String, TemplateNode>();
    private boolean shareTime;

    public InternalNode(String name, boolean shareTime) {
        super(name);
        this.shareTime = shareTime;
    }

    public void addChild(TemplateNode node) throws StatementExecutionException {
        if (this.children.containsKey(node.getName())) {
            throw new StatementExecutionException("Duplicated child of node in template.");
        }
        this.children.put(node.getName(), node);
    }

    public void deleteChild(TemplateNode node) {
        if (this.children.containsKey(node.getName())) {
            this.children.remove(node.getName());
        }
    }

    public Map<String, TemplateNode> getChildren() {
        return this.children;
    }

    public boolean isShareTime() {
        return this.shareTime;
    }
}

