/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.seata.config.nacos;

import com.alibaba.nacos.api.exception.NacosException;
import org.apache.seata.common.util.ReflectionUtil;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.config.Dispose;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

import java.lang.reflect.Method;
import java.util.Properties;

/**
 * The type Nacos configuration test
 */
public class NacosConfigurationTest {

    private static Configuration configuration;

    @BeforeAll
    public static void setup() throws NacosException {
        System.clearProperty("seataEnv");
        configuration = NacosConfiguration.getInstance();
        if (configuration instanceof Dispose) {
            ((Dispose) configuration).dispose();
        }
        ConfigurationFactory.reload();
        configuration = NacosConfiguration.getInstance();
    }

    @Test
    public void testGetConfigProperties() throws Exception {
        Assertions.assertNotNull(configuration);
        Method method = ReflectionUtil.getMethod(NacosConfiguration.class, "getConfigProperties");
        // do not use `ConfigurationFactory.getInstance()`, it's a proxy object
        Properties properties = (Properties) method.invoke(configuration);
        Assertions.assertEquals("/bar", properties.getProperty("contextPath"));
        System.setProperty("contextPath", "/foo");
        properties = (Properties) method.invoke(configuration);
        Assertions.assertEquals("/foo", properties.getProperty("contextPath"));
        System.clearProperty("contextPath");
    }
}
