/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.server.service;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.xiaomi.data.push.context.AgentContext;
import com.xiaomi.data.push.rpc.RpcServer;
import com.xiaomi.data.push.rpc.netty.AgentChannel;
import com.xiaomi.data.push.rpc.protocol.RemotingCommand;
import com.xiaomi.youpin.docean.plugin.dubbo.anno.Service;
import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.api.model.meta.LogCollectMeta;
import org.apache.ozhera.log.api.service.PublishConfigService;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.utils.NetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(interfaceClass=PublishConfigService.class, group="$dubbo.group", timeout=14000)
public class DefaultPublishConfigService
implements PublishConfigService {
    private static final Logger log = LoggerFactory.getLogger(DefaultPublishConfigService.class);
    private static final AtomicInteger COUNT_INCR = new AtomicInteger(0);
    @Resource
    private RpcServer rpcServer;

    public void sengConfigToAgent(String agentIp, LogCollectMeta logCollectMeta) {
        for (int count = 1; count < 4; ++count) {
            String agentCurrentIp;
            Map<String, AgentChannel> logAgentMap = this.getAgentChannelMap();
            if (logAgentMap.containsKey(agentCurrentIp = this.queryCurrentDockerAgentIP(agentIp, logAgentMap))) {
                String sendStr = Constant.GSON.toJson((Object)logCollectMeta);
                if (CollectionUtils.isNotEmpty((Collection)logCollectMeta.getAppLogMetaList())) {
                    RemotingCommand req = RemotingCommand.createRequestCommand((int)3000);
                    req.setBody(sendStr.getBytes());
                    log.info("Send the configuration,agent ip:{},Configuration information:{}", (Object)agentCurrentIp, (Object)sendStr);
                    Stopwatch started = Stopwatch.createStarted();
                    RemotingCommand res = this.rpcServer.sendMessage((Channel)logAgentMap.get(agentCurrentIp), req, 10000L);
                    started.stop();
                    String response = new String(res.getBody());
                    log.info("The configuration is sent successfully---->{},duration\uff1a{}s,agentIp:{}", new Object[]{response, started.elapsed().getSeconds(), agentCurrentIp});
                    if (Objects.equals(response, "ok")) {
                        break;
                    }
                }
            } else {
                log.info("The current agent IP is not connected,ip:{},configuration data:{}", (Object)agentIp, (Object)Constant.GSON.toJson((Object)logCollectMeta));
            }
            try {
                TimeUnit.MILLISECONDS.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public List<String> getAllAgentList() {
        ArrayList remoteAddress = Lists.newArrayList();
        ArrayList ipAddress = Lists.newArrayList();
        AgentContext.ins().map.entrySet().forEach(agentChannelEntry -> {
            String key = (String)agentChannelEntry.getKey();
            remoteAddress.add(key);
            ipAddress.add(StringUtils.substringBefore((String)key, (String)":"));
        });
        if (COUNT_INCR.getAndIncrement() % 200 == 0) {
            log.info("The set of remote addresses of the connected agent machine is:{}", (Object)Constant.GSON.toJson((Object)remoteAddress));
        }
        return remoteAddress;
    }

    private Map<String, AgentChannel> getAgentChannelMap() {
        HashMap<String, AgentChannel> logAgentMap = new HashMap<String, AgentChannel>();
        AgentContext.ins().map.forEach((k, v) -> logAgentMap.put(StringUtils.substringBefore((String)k, (String)":"), (AgentChannel)v));
        return logAgentMap;
    }

    private String queryCurrentDockerAgentIP(String agentIp, Map<String, AgentChannel> logAgentMap) {
        if (Objects.equals(agentIp, NetUtil.getLocalIp())) {
            String tempIp = agentIp;
            List ipList = this.getAgentChannelMap().keySet().stream().filter(ip -> ip.startsWith("172")).collect(Collectors.toList());
            Optional<String> optionalS = ipList.stream().filter(ip -> Objects.equals(((AgentChannel)logAgentMap.get(ip)).getIp(), tempIp)).findFirst();
            if (optionalS.isPresent()) {
                String correctIp = optionalS.get();
                log.info("origin ip:{},set agent ip:{}", (Object)agentIp, (Object)correctIp);
                agentIp = correctIp;
            }
        }
        return agentIp;
    }
}

