/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.rocketmq;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.google.gson.Gson;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.app.api.message.HeraAppInfoModifyMessage;
import org.apache.ozhera.monitor.dao.HeraAppRoleDao;
import org.apache.ozhera.monitor.service.AppGrafanaMappingService;
import org.apache.ozhera.monitor.service.AppMonitorService;
import org.apache.ozhera.monitor.service.GrafanaService;
import org.apache.ozhera.monitor.service.HeraBaseInfoService;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.client.consumer.AllocateMessageQueueStrategy;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyStatus;
import org.apache.rocketmq.client.consumer.rebalance.AllocateMessageQueueAveragely;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.remoting.RPCHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="heraMonitorMqConsumer")
public class RocketMqHeraMonitorConsumer {
    private static final Logger log = LoggerFactory.getLogger(RocketMqHeraMonitorConsumer.class);
    @NacosValue(value="${hera.app.modify.notice.topic}", autoRefreshed=true)
    private String consumerTopic;
    @NacosValue(value="${hera.app.modify.notice.tag}", autoRefreshed=true)
    private String consumerTag;
    @NacosValue(value="${hera.app.modify.notice.group}", autoRefreshed=true)
    private String consumerGroup;
    @NacosValue(value="${rocketmq.namesrv.addr}", autoRefreshed=true)
    private String namesrvAddr;
    @NacosValue(value="${rocketmq.ak}")
    private String ak;
    @NacosValue(value="${rocketmq.sk}")
    private String sk;
    private DefaultMQPushConsumer heraMonitorMQPushConsumer;
    @Autowired
    HeraAppRoleDao heraAppRoleDao;
    @Autowired
    GrafanaService grafanaService;
    @Autowired
    AppGrafanaMappingService appGrafanaMappingService;
    @Autowired
    HeraBaseInfoService heraBaseInfoService;
    @Autowired
    AppMonitorService appMonitorService;
    private AtomicBoolean rocketMqStartedStatus = new AtomicBoolean(false);

    public void start() throws MQClientException {
        try {
            boolean b = this.rocketMqStartedStatus.compareAndSet(false, true);
            if (!b) {
                log.error("RocketMqHeraMonitorConsumer.heraAppMQPushConsumer start failed, it has started!!");
                return;
            }
            log.info("RocketMqHeraMonitorConsumer.heraAppMQPushConsumer init start!!");
            if (StringUtils.isNotEmpty((CharSequence)this.ak) && StringUtils.isNotEmpty((CharSequence)this.sk)) {
                SessionCredentials credentials = new SessionCredentials(this.ak, this.sk);
                AclClientRPCHook rpcHook = new AclClientRPCHook(credentials);
                this.heraMonitorMQPushConsumer = new DefaultMQPushConsumer(this.consumerGroup, (RPCHook)rpcHook, (AllocateMessageQueueStrategy)new AllocateMessageQueueAveragely());
            } else {
                this.heraMonitorMQPushConsumer = new DefaultMQPushConsumer(this.consumerGroup);
            }
            this.heraMonitorMQPushConsumer.setNamesrvAddr(this.namesrvAddr);
            this.heraMonitorMQPushConsumer.setConsumeFromWhere(ConsumeFromWhere.CONSUME_FROM_LAST_OFFSET);
            this.heraMonitorMQPushConsumer.subscribe(this.consumerTopic, this.consumerTag);
            log.info("Mimonitor#RocketMqHeraMonitorConsumer consumerTopic:{},consumerTag:{},consumerGroup:{}", new Object[]{this.consumerTopic, this.consumerTag, this.consumerGroup});
            this.heraMonitorMQPushConsumer.registerMessageListener((list, consumeOrderlyContext) -> {
                try {
                    list.stream().forEach(it -> {
                        log.info("RocketMqHeraMonitorConsumer#  received message : MsgId: {}, Topic: {} Tags:{}", new Object[]{it.getMsgId(), it.getTopic(), it.getTags()});
                        this.consumeMessage((MessageExt)it);
                    });
                }
                catch (Exception e) {
                    log.info("RocketMqHeraMonitorConsumer#  message error: {}", (Object)e.getMessage(), (Object)e);
                }
                return ConsumeOrderlyStatus.SUCCESS;
            });
            log.info("RocketMqHeraMonitorConsumer#  init end!!");
            this.heraMonitorMQPushConsumer.start();
            log.info("RocketMqHeraMonitorConsumer#  has started!!");
        }
        catch (MQClientException e) {
            log.error("RocketMqHeraMonitorConsumer#  start error: {}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
    }

    private void consumeMessage(MessageExt message) {
        log.info("RocketMqHeraMonitorConsumer# consumeMessage: {} {}", (Object)message.getMsgId(), (Object)new String(message.getBody()));
        Gson gson = new Gson();
        try {
            byte[] body = message.getBody();
            HeraAppInfoModifyMessage appModifyMessage = (HeraAppInfoModifyMessage)gson.fromJson(new String(body), HeraAppInfoModifyMessage.class);
            log.info("RocketMqHeraMonitorConsumer# consumeMessage convert appModifyMessage : {}", (Object)appModifyMessage.toString());
            this.appMonitorService.heraAppInfoModify(appModifyMessage);
        }
        catch (Throwable ex) {
            log.error("RocketMqHeraMonitorConsumer#consumeMessage error:" + ex.getMessage(), ex);
        }
    }
}

