/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.dao;

import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.bo.AlarmStrategyType;
import org.apache.ozhera.monitor.dao.mapper.AppAlarmRuleTemplateMapper;
import org.apache.ozhera.monitor.dao.model.AppAlarmRuleTemplate;
import org.apache.ozhera.monitor.dao.model.AppAlarmRuleTemplateExample;
import org.apache.ozhera.monitor.service.model.prometheus.AppAlarmRuleTemplateQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class AppAlarmRuleTemplateDao {
    private static final Logger log = LoggerFactory.getLogger(AppAlarmRuleTemplateDao.class);
    @Autowired
    private AppAlarmRuleTemplateMapper templateMapper;

    public Long getDataTotal(AppAlarmRuleTemplateQuery appAlarmRuleTemplate) {
        AppAlarmRuleTemplateExample example = new AppAlarmRuleTemplateExample();
        AppAlarmRuleTemplateExample.Criteria ca = example.createCriteria();
        if (appAlarmRuleTemplate.getStatus() != null) {
            ca.andStatusEqualTo(appAlarmRuleTemplate.getStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)appAlarmRuleTemplate.getRemark())) {
            ca.andRemarkLike("%" + appAlarmRuleTemplate.getRemark() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)appAlarmRuleTemplate.getName())) {
            ca.andNameLike("%" + appAlarmRuleTemplate.getName() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)appAlarmRuleTemplate.getCreater())) {
            ca.andCreaterEqualTo(appAlarmRuleTemplate.getCreater());
        }
        if (appAlarmRuleTemplate.getType() != null) {
            ca.andTypeEqualTo(appAlarmRuleTemplate.getType());
        }
        if (appAlarmRuleTemplate.getStrategyType() != null) {
            ca.andStrategyTypeEqualTo(appAlarmRuleTemplate.getStrategyType());
        }
        return this.templateMapper.countByExample(example);
    }

    public List<AppAlarmRuleTemplate> query(AppAlarmRuleTemplateQuery appAlarmRuleTemplate, Integer offset, Integer pageSize) {
        AppAlarmRuleTemplateExample example = new AppAlarmRuleTemplateExample();
        AppAlarmRuleTemplateExample.Criteria ca = example.createCriteria();
        if (appAlarmRuleTemplate.getStatus() != null) {
            ca.andStatusEqualTo(appAlarmRuleTemplate.getStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)appAlarmRuleTemplate.getRemark())) {
            ca.andRemarkLike("%" + appAlarmRuleTemplate.getRemark() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)appAlarmRuleTemplate.getName())) {
            ca.andNameLike("%" + appAlarmRuleTemplate.getName() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)appAlarmRuleTemplate.getCreater())) {
            ca.andCreaterEqualTo(appAlarmRuleTemplate.getCreater());
        }
        if (appAlarmRuleTemplate.getType() != null) {
            ca.andTypeEqualTo(appAlarmRuleTemplate.getType());
        }
        if (appAlarmRuleTemplate.getStrategyType() != null) {
            ca.andStrategyTypeEqualTo(appAlarmRuleTemplate.getStrategyType());
        }
        example.setOffset(offset);
        example.setLimit(pageSize);
        example.setOrderByClause("id desc");
        return this.templateMapper.selectByExample(example);
    }

    public AppAlarmRuleTemplate getById(Integer id) {
        return this.templateMapper.selectByPrimaryKey(id);
    }

    public int create(AppAlarmRuleTemplate appAlarmRuleTemplate) {
        if (null == appAlarmRuleTemplate) {
            log.error("[AppAlarmRuleTemplateDao.create] null appAlarmRuleTemplate");
            return 0;
        }
        appAlarmRuleTemplate.setCreateTime(new Date());
        appAlarmRuleTemplate.setUpdateTime(new Date());
        appAlarmRuleTemplate.setStatus(0);
        if (appAlarmRuleTemplate.getStrategyType() == null) {
            appAlarmRuleTemplate.setStrategyType(AlarmStrategyType.SYSTEM.getCode());
        }
        try {
            int affected = this.templateMapper.insert(appAlarmRuleTemplate);
            if (affected < 1) {
                log.warn("[AppAlarmRuleTemplateDao.create] failed to insert appAlarmRuleTemplate: {}", (Object)appAlarmRuleTemplate.toString());
                return 0;
            }
            return affected;
        }
        catch (Exception e) {
            log.error("[AppAlarmRuleTemplateDao.create] failed to insert appAlarmRuleTemplate: {}, err: {}", (Object)appAlarmRuleTemplate.toString(), (Object)e);
            return 0;
        }
    }

    public int update(AppAlarmRuleTemplate appAlarmRuleTemplate) {
        if (null == appAlarmRuleTemplate) {
            log.error("[AppAlarmRuleTemplateDao.update] null appAlarmRuleTemplate");
            return 0;
        }
        appAlarmRuleTemplate.setUpdateTime(new Date());
        try {
            int affected = this.templateMapper.updateByPrimaryKeySelective(appAlarmRuleTemplate);
            if (affected < 1) {
                log.warn("[AppAlarmRuleTemplateDao.update] failed to insert appAlarmRuleTemplate: {}", (Object)appAlarmRuleTemplate.toString());
                return 0;
            }
            return affected;
        }
        catch (Exception e) {
            log.error("[AppAlarmRuleTemplateDao.update] failed to insert appAlarmRuleTemplate: {}, err: {}", (Object)appAlarmRuleTemplate.toString(), (Object)e);
            return 0;
        }
    }

    public void batchInsert(List<AppAlarmRuleTemplate> list) {
        int i = this.templateMapper.batchInsert(list);
    }

    public int deleteById(Integer id) {
        try {
            return this.templateMapper.deleteByPrimaryKey(id);
        }
        catch (Exception e) {
            log.error("deleteById error! message:{}", (Object)e.getMessage(), (Object)e);
            return 0;
        }
    }
}

