/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.jcommon.log;

import ch.qos.logback.core.rolling.RollingFileAppender;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class RecreateRollingFileAppender<E>
extends RollingFileAppender<E> {
    private long fileCheckInterval = 20L;

    public long getFileCheckInterval() {
        return this.fileCheckInterval;
    }

    public void setFileCheckInterval(long fileCheckInterval) {
        this.fileCheckInterval = fileCheckInterval;
    }

    public void start() {
        super.start();
        this.startCheckTask(this);
    }

    private void startCheckTask(RecreateRollingFileAppender fileAppender) {
        if (this.fileCheckInterval < 1L) {
            return;
        }
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
        executor.scheduleWithFixedDelay(() -> {
            if (!Files.exists(Paths.get(this.getFile(), new String[0]), new LinkOption[0])) {
                try {
                    fileAppender.openFile(this.getFile());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }, 10L, this.fileCheckInterval, TimeUnit.SECONDS);
    }
}

