/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.prometheus.client.binder;

import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GcInfo;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.lang.NonNullApi;
import io.micrometer.core.lang.NonNullFields;
import io.micrometer.core.lang.Nullable;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ListenerNotFoundException;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;

@NonNullApi
@NonNullFields
public class JvmGcMetricsReduced
implements MeterBinder,
AutoCloseable {
    private final boolean managementExtensionsPresent = JvmGcMetricsReduced.isManagementExtensionsPresent();
    private final Iterable<Tag> tags;
    @Nullable
    private String youngGenPoolName;
    @Nullable
    private String oldGenPoolName;
    private final List<Runnable> notificationListenerCleanUpRunnables = new CopyOnWriteArrayList<Runnable>();

    public JvmGcMetricsReduced() {
        this(Collections.emptyList());
    }

    public JvmGcMetricsReduced(Iterable<Tag> tags) {
        for (MemoryPoolMXBean mbean : ManagementFactory.getMemoryPoolMXBeans()) {
            String name = mbean.getName();
            if (this.isYoungGenPool(name)) {
                this.youngGenPoolName = name;
                continue;
            }
            if (!this.isOldGenPool(name)) continue;
            this.oldGenPoolName = name;
        }
        this.tags = tags;
    }

    public void bindTo(MeterRegistry registry) {
        Counter promotedBytes = Counter.builder((String)"jvm.gc.memory.promoted").tags(this.tags).baseUnit("bytes").description("Count of positive increases in the size of the old generation memory pool before GC to after GC").register(registry);
        Counter allocatedBytes = Counter.builder((String)"jvm.gc.memory.allocated").tags(this.tags).baseUnit("bytes").description("Incremented for an increase in the size of the young generation memory pool after one GC to before the next").register(registry);
        if (this.managementExtensionsPresent) {
            AtomicLong youngGenSizeAfter = new AtomicLong(0L);
            for (GarbageCollectorMXBean mbean : ManagementFactory.getGarbageCollectorMXBeans()) {
                if (!(mbean instanceof NotificationEmitter)) continue;
                NotificationListener notificationListener = (notification, ref) -> {
                    if (notification.getType().equals("com.sun.management.gc.notification")) {
                        long delta;
                        long oldAfter;
                        long oldBefore;
                        CompositeData cd = (CompositeData)notification.getUserData();
                        GarbageCollectionNotificationInfo notificationInfo = GarbageCollectionNotificationInfo.from(cd);
                        String gcCause = notificationInfo.getGcCause();
                        String gcAction = notificationInfo.getGcAction();
                        GcInfo gcInfo = notificationInfo.getGcInfo();
                        long duration = gcInfo.getDuration();
                        if (this.isConcurrentPhase(gcCause)) {
                            Timer.builder((String)"jvm.gc.concurrent.phase.time").tags(this.tags).tags(new String[]{"action", gcAction, "cause", gcCause}).description("Time spent in concurrent phase").register(registry).record(duration, TimeUnit.MILLISECONDS);
                        } else {
                            Timer.builder((String)"jvm.gc.pause").tags(this.tags).tags(new String[]{"action", gcAction, "cause", gcCause}).description("Time spent in GC pause").register(registry).record(duration, TimeUnit.MILLISECONDS);
                        }
                        Map<String, MemoryUsage> before = gcInfo.getMemoryUsageBeforeGc();
                        Map<String, MemoryUsage> after = gcInfo.getMemoryUsageAfterGc();
                        if (this.oldGenPoolName != null) {
                            oldBefore = before.get(this.oldGenPoolName).getUsed();
                            oldAfter = after.get(this.oldGenPoolName).getUsed();
                            delta = oldAfter - oldBefore;
                            if (delta > 0L) {
                                promotedBytes.increment((double)delta);
                            }
                        }
                        if (this.youngGenPoolName != null) {
                            oldBefore = before.get(this.youngGenPoolName).getUsed();
                            oldAfter = after.get(this.youngGenPoolName).getUsed();
                            delta = oldBefore - youngGenSizeAfter.get();
                            youngGenSizeAfter.set(oldAfter);
                            if (delta > 0L) {
                                allocatedBytes.increment((double)delta);
                            }
                        }
                    }
                };
                NotificationEmitter notificationEmitter = (NotificationEmitter)((Object)mbean);
                notificationEmitter.addNotificationListener(notificationListener, null, null);
                this.notificationListenerCleanUpRunnables.add(() -> {
                    try {
                        notificationEmitter.removeNotificationListener(notificationListener);
                    }
                    catch (ListenerNotFoundException listenerNotFoundException) {
                        // empty catch block
                    }
                });
            }
        }
    }

    private static boolean isManagementExtensionsPresent() {
        try {
            Class.forName("com.sun.management.GarbageCollectionNotificationInfo", false, JvmGcMetricsReduced.class.getClassLoader());
            return true;
        }
        catch (Throwable var1) {
            return false;
        }
    }

    private boolean isConcurrentPhase(String cause) {
        return "No GC".equals(cause);
    }

    private boolean isOldGenPool(String name) {
        return name.endsWith("Old Gen") || name.endsWith("Tenured Gen");
    }

    private boolean isYoungGenPool(String name) {
        return name.endsWith("Eden Space");
    }

    @Override
    public void close() {
        this.notificationListenerCleanUpRunnables.forEach(Runnable::run);
    }

    @NonNullApi
    static enum GcGenerationAge {
        OLD,
        YOUNG,
        UNKNOWN;

        private static Map<String, GcGenerationAge> knownCollectors;

        static GcGenerationAge fromName(String name) {
            return knownCollectors.getOrDefault(name, UNKNOWN);
        }

        static {
            knownCollectors = new HashMap<String, GcGenerationAge>(){
                {
                    this.put("ConcurrentMarkSweep", OLD);
                    this.put("Copy", YOUNG);
                    this.put("G1 Old Generation", OLD);
                    this.put("G1 Young Generation", YOUNG);
                    this.put("MarkSweepCompact", OLD);
                    this.put("PS MarkSweep", OLD);
                    this.put("PS Scavenge", YOUNG);
                    this.put("ParNew", YOUNG);
                }
            };
        }
    }
}

