/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.stream.job.extension.impl;

import com.xiaomi.mone.es.EsProcessor;
import java.util.Map;
import org.apache.ozhera.log.stream.job.compensate.MqMessageDTO;
import org.apache.ozhera.log.stream.job.extension.MessageSender;
import org.apache.ozhera.log.stream.job.extension.MqMessageProduct;
import org.apache.ozhera.log.utils.DateUtils;

public class EsMessageSender
implements MessageSender {
    private EsProcessor esProcessor;
    private final String index;
    private MqMessageProduct compensateMsgProduct;

    public EsMessageSender(String index, MqMessageProduct compensateMsgProduct) {
        this.index = index;
        this.compensateMsgProduct = compensateMsgProduct;
    }

    public EsProcessor getEsProcessor() {
        return this.esProcessor;
    }

    public void setEsProcessor(EsProcessor esProcessor) {
        this.esProcessor = esProcessor;
    }

    @Override
    public Boolean send(Map<String, Object> data) throws Exception {
        String time = DateUtils.getTime();
        String esIndex = this.index + "-" + time;
        this.esProcessor.bulkInsert(esIndex, data);
        return true;
    }

    @Override
    public boolean compensateSend(MqMessageDTO compensateMsg) {
        if (null != this.compensateMsgProduct) {
            this.compensateMsgProduct.product(compensateMsg);
            return true;
        }
        return false;
    }
}

