/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mone.tpc.login.util;

import com.google.gson.reflect.TypeToken;
import com.xiaomi.mone.tpc.login.util.ConstUtil;
import com.xiaomi.mone.tpc.login.util.HttpClientUtil;
import com.xiaomi.mone.tpc.login.util.MD5Util;
import com.xiaomi.mone.tpc.login.util.SignUtil;
import com.xiaomi.mone.tpc.login.vo.AuthUserVo;
import com.xiaomi.mone.tpc.login.vo.ResultVo;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemReqUtil {
    private static final Logger logger = LoggerFactory.getLogger(SystemReqUtil.class);

    public static ResultVo<AuthUserVo> applyRequest(String reqUrl, String sysName, String token, String account, long ttlMills) {
        long now = System.currentTimeMillis();
        HashMap<String, String> getParams = new HashMap<String, String>();
        getParams.put("sysName", sysName);
        getParams.put("reqTime", "" + now);
        getParams.put("account", account);
        getParams.put("ttlMills", "" + ttlMills);
        getParams.put("sysSign", SignUtil.getSysSign(sysName, token, now, null, MD5Util.md5(account + ttlMills)));
        ResultVo<AuthUserVo> resultVo = HttpClientUtil.doHttpGet(reqUrl, getParams, new TypeToken<ResultVo<AuthUserVo>>(){});
        return resultVo;
    }

    public static <T> T dataRequest(String reqUrl, String sysName, String token, String userToken, Object param, TypeToken<T> type) {
        try {
            long now = System.currentTimeMillis();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("sysName", sysName);
            headers.put("reqTime", "" + now);
            if (StringUtils.isNotBlank((CharSequence)userToken)) {
                headers.put("userToken", userToken);
            }
            headers.put("sysSign", SignUtil.getSysSign(sysName, token, now, userToken, SignUtil.getDataSign(param)));
            return HttpClientUtil.doHttpPostJson(reqUrl, param, headers, type);
        }
        catch (Throwable e) {
            logger.error("SystemReqUtil.dataRequest\u6267\u884c\u5f02\u5e38", e);
            return null;
        }
    }

    public static ResultVo<AuthUserVo> authRequest(String authToken, boolean fullInfo) {
        HashMap<String, String> getParams = new HashMap<String, String>();
        getParams.put("authToken", authToken);
        getParams.put("fullInfo", "" + fullInfo);
        ResultVo<AuthUserVo> resultVo = HttpClientUtil.doHttpGet(ConstUtil.authTokenUrlVal, getParams, new TypeToken<ResultVo<AuthUserVo>>(){});
        logger.info("http.authRequest param={}, resultVo={}", getParams, resultVo);
        return resultVo;
    }

    public static ResultVo<AuthUserVo> authRequest(String sysName, String sysSign, String userToken, String reqTime, String dataSign, String url) {
        HashMap<String, String> getParams = new HashMap<String, String>();
        getParams.put("sysName", sysName);
        getParams.put("sysSign", sysSign);
        if (StringUtils.isNotBlank((CharSequence)userToken)) {
            getParams.put("userToken", userToken);
        }
        if (StringUtils.isNotBlank((CharSequence)dataSign)) {
            getParams.put("dataSign", dataSign);
        }
        getParams.put("reqTime", reqTime);
        ResultVo<AuthUserVo> resultVo = HttpClientUtil.doHttpGet(url, getParams, new TypeToken<ResultVo<AuthUserVo>>(){});
        logger.info("http.authRequest param={}, resultVo={}", getParams, resultVo);
        return resultVo;
    }
}

