/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc;

import java.util.concurrent.TimeUnit;

public final class TimeoutCountDown
implements Comparable<TimeoutCountDown> {
    private final long timeoutInMillis;
    private final long deadlineInNanos;
    private volatile boolean expired;

    public static TimeoutCountDown newCountDown(long timeout, TimeUnit unit) {
        return new TimeoutCountDown(timeout, unit);
    }

    private TimeoutCountDown(long timeout, TimeUnit unit) {
        this.timeoutInMillis = TimeUnit.MILLISECONDS.convert(timeout, unit);
        this.deadlineInNanos = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeout, unit);
    }

    public long getTimeoutInMilli() {
        return this.timeoutInMillis;
    }

    public boolean isExpired() {
        if (!this.expired) {
            if (this.deadlineInNanos - System.nanoTime() <= 0L) {
                this.expired = true;
            } else {
                return false;
            }
        }
        return true;
    }

    public long timeRemaining(TimeUnit unit) {
        long currentNanos = System.nanoTime();
        if (!this.expired && this.deadlineInNanos - currentNanos <= 0L) {
            this.expired = true;
        }
        return unit.convert(this.deadlineInNanos - currentNanos, TimeUnit.NANOSECONDS);
    }

    public long elapsedMillis() {
        if (this.isExpired()) {
            return this.timeoutInMillis + TimeUnit.MILLISECONDS.convert(System.nanoTime() - this.deadlineInNanos, TimeUnit.NANOSECONDS);
        }
        return this.timeoutInMillis - TimeUnit.MILLISECONDS.convert(this.deadlineInNanos - System.nanoTime(), TimeUnit.NANOSECONDS);
    }

    public String toString() {
        long timeoutMillis = TimeUnit.MILLISECONDS.convert(this.deadlineInNanos, TimeUnit.NANOSECONDS);
        long remainingMillis = this.timeRemaining(TimeUnit.MILLISECONDS);
        StringBuilder buf = new StringBuilder();
        buf.append("Total timeout value - ");
        buf.append(timeoutMillis);
        buf.append(", times remaining - ");
        buf.append(remainingMillis);
        return buf.toString();
    }

    @Override
    public int compareTo(TimeoutCountDown another) {
        long delta = this.deadlineInNanos - another.deadlineInNanos;
        if (delta < 0L) {
            return -1;
        }
        if (delta > 0L) {
            return 1;
        }
        return 0;
    }
}

