/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.migration;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.client.migration.MigrationInvoker;
import org.apache.dubbo.registry.integration.RegistryProtocol;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Cluster;
import org.apache.dubbo.rpc.cluster.ClusterInvoker;

public class ServiceDiscoveryMigrationInvoker<T>
extends MigrationInvoker<T> {
    private static final Logger logger = LoggerFactory.getLogger(ServiceDiscoveryMigrationInvoker.class);

    public ServiceDiscoveryMigrationInvoker(RegistryProtocol registryProtocol, Cluster cluster, Registry registry, Class<T> type, URL url, URL consumerUrl) {
        super(registryProtocol, cluster, registry, type, url, consumerUrl);
    }

    @Override
    public boolean isServiceInvoker() {
        return true;
    }

    @Override
    public synchronized void fallbackToInterfaceInvoker() {
        logger.error("Service discovery registry type does not support discovery of interface level addresses, " + this.getRegistryUrl());
        this.migrateToServiceDiscoveryInvoker(true);
    }

    @Override
    public synchronized void migrateToServiceDiscoveryInvoker(boolean forceMigrate) {
        this.refreshServiceDiscoveryInvoker();
    }

    @Override
    public Result invoke(Invocation invocation) throws RpcException {
        ClusterInvoker invoker = this.getServiceDiscoveryInvoker();
        if (invoker == null) {
            throw new IllegalStateException("There's no service discovery invoker available for service " + invocation.getServiceName());
        }
        return invoker.invoke(invocation);
    }
}

