/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.context;

import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractConfig;

public class ConfigConfigurationAdapter
implements Configuration {
    private Map<String, String> metaData;

    public ConfigConfigurationAdapter(AbstractConfig config) {
        Map<String, String> configMetadata = config.getMetaData();
        this.metaData = new HashMap<String, String>(configMetadata.size(), 1.0f);
        for (Map.Entry<String, String> entry : configMetadata.entrySet()) {
            String prefix = config.getPrefix().endsWith(".") ? config.getPrefix() : config.getPrefix() + ".";
            String id = StringUtils.isEmpty(config.getId()) ? "" : config.getId() + ".";
            this.metaData.put(prefix + id + entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object getInternalProperty(String key) {
        return this.metaData.get(key);
    }
}

