/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.shaded.freemarker.core;

import java.io.IOException;
import java.util.ArrayList;
import org.mapstruct.ap.shaded.freemarker.core.Assignment;
import org.mapstruct.ap.shaded.freemarker.core.Environment;
import org.mapstruct.ap.shaded.freemarker.core.Expression;
import org.mapstruct.ap.shaded.freemarker.core.ParameterRole;
import org.mapstruct.ap.shaded.freemarker.core.ParseException;
import org.mapstruct.ap.shaded.freemarker.core.TemplateElement;
import org.mapstruct.ap.shaded.freemarker.core.TemplateObject;
import org.mapstruct.ap.shaded.freemarker.template.TemplateException;

final class AssignmentInstruction
extends TemplateElement {
    private int scope;
    private Expression namespaceExp;

    AssignmentInstruction(int scope) {
        this.scope = scope;
        this.nestedElements = new ArrayList(1);
    }

    void addAssignment(Assignment ass) {
        this.nestedElements.add(ass);
    }

    void setNamespaceExp(Expression namespaceExp) {
        this.namespaceExp = namespaceExp;
        for (int i = 0; i < this.nestedElements.size(); ++i) {
            ((Assignment)this.nestedElements.get(i)).setNamespaceExp(namespaceExp);
        }
    }

    void accept(Environment env) throws TemplateException, IOException {
        for (int i = 0; i < this.nestedElements.size(); ++i) {
            Assignment ass = (Assignment)this.nestedElements.get(i);
            env.visit(ass);
        }
    }

    protected String dump(boolean canonical) {
        StringBuffer buf = new StringBuffer();
        if (canonical) {
            buf.append('<');
        }
        buf.append(Assignment.getDirectiveName(this.scope));
        if (canonical) {
            buf.append(' ');
            for (int i = 0; i < this.nestedElements.size(); ++i) {
                Assignment ass = (Assignment)this.nestedElements.get(i);
                buf.append(ass.getCanonicalForm());
                if (i >= this.nestedElements.size() - 1) continue;
                buf.append(" ");
            }
        } else {
            buf.append("-container");
        }
        if (this.namespaceExp != null) {
            buf.append(" in ");
            buf.append(this.namespaceExp.getCanonicalForm());
        }
        if (canonical) {
            buf.append("/>");
        }
        return buf.toString();
    }

    int getParameterCount() {
        return 2;
    }

    Object getParameterValue(int idx) {
        switch (idx) {
            case 0: {
                return new Integer(this.scope);
            }
            case 1: {
                return this.namespaceExp;
            }
        }
        return null;
    }

    ParameterRole getParameterRole(int idx) {
        switch (idx) {
            case 0: {
                return ParameterRole.VARIABLE_SCOPE;
            }
            case 1: {
                return ParameterRole.NAMESPACE;
            }
        }
        return null;
    }

    String getNodeTypeSymbol() {
        return Assignment.getDirectiveName(this.scope);
    }

    public TemplateElement postParseCleanup(boolean stripWhitespace) throws ParseException {
        super.postParseCleanup(stripWhitespace);
        if (this.nestedElements.size() == 1) {
            Assignment ass = (Assignment)this.nestedElements.get(0);
            ass.setLocation(this.getTemplate(), (TemplateObject)this, (TemplateObject)this);
            return ass;
        }
        return this;
    }
}

