/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.util;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Properties;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.StringUtils;

public class PropertiesPlaceholderResolver {
    private final PropertyResolver propertyResolver;

    public PropertiesPlaceholderResolver(PropertyResolver propertyResolver) {
        this.propertyResolver = propertyResolver;
    }

    public Properties resolve(Annotation annotation) {
        Map attributes = AnnotationUtils.getAnnotationAttributes((Annotation)annotation);
        return this.resolve(attributes);
    }

    public Properties resolve(Map<?, ?> properties) {
        Properties resolvedProperties = new Properties();
        for (Map.Entry<?, ?> entry : properties.entrySet()) {
            if (!(entry.getValue() instanceof CharSequence)) continue;
            String key = String.valueOf(entry.getKey());
            String value = String.valueOf(entry.getValue());
            String resolvedValue = this.propertyResolver.resolvePlaceholders(value);
            if (!StringUtils.hasText((String)resolvedValue)) continue;
            resolvedProperties.setProperty(key, resolvedValue);
        }
        return resolvedProperties;
    }
}

