/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.es.util.bloomfilter;

import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TraceIdRedisBloomUtil {
    private static final Logger log = LoggerFactory.getLogger(TraceIdRedisBloomUtil.class);
    private String localUpdateTime = "04:00:00";
    private String localUpdateTimeMiddle = "12:00:00";
    private static final long LOCAL_EXPECTEDINSERTIONS = 100000000L;
    private static final double LOCAL_REDIS_ACCIRACY = 1.0E-4;
    private static final long PERIOD_DAY = 86400000L;
    public static volatile BloomFilter<CharSequence> localBloomFilter;
    private Funnel<CharSequence> charSequenceFunnel = Funnels.stringFunnel((Charset)Charset.defaultCharset());
    private ReentrantLock lock = new ReentrantLock();

    @PostConstruct
    public void init() {
        localBloomFilter = BloomFilter.create(this.charSequenceFunnel, (long)100000000L, (double)1.0E-4);
        this.updateLocalBloomTimer();
        this.updateLocalBloomTimerMiddle();
    }

    public boolean isExistLocal(String traceId) {
        try {
            return localBloomFilter.mightContain((Object)traceId);
        }
        catch (Exception e) {
            log.error("judgment traceID: " + traceId + " whether there are failures in the local bloomfilter:", (Throwable)e);
            return true;
        }
    }

    public void addBatch(String traceId) {
        this.lock.lock();
        try {
            localBloomFilter.put((Object)traceId);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void updateLocalBloomTimer() {
        long initDelay = TraceIdRedisBloomUtil.getTimeMillis(this.localUpdateTime) - System.currentTimeMillis();
        initDelay = initDelay > 0L ? initDelay : 86400000L + initDelay;
        new ScheduledThreadPoolExecutor(1).scheduleAtFixedRate(() -> this.updateLocalBloom(), initDelay, 86400000L, TimeUnit.MILLISECONDS);
    }

    private void updateLocalBloomTimerMiddle() {
        long initDelay = TraceIdRedisBloomUtil.getTimeMillis(this.localUpdateTimeMiddle) - System.currentTimeMillis();
        initDelay = initDelay > 0L ? initDelay : 86400000L + initDelay;
        new ScheduledThreadPoolExecutor(1).scheduleAtFixedRate(() -> this.updateLocalBloom(), initDelay, 86400000L, TimeUnit.MILLISECONDS);
    }

    private static long getTimeMillis(String time) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
            SimpleDateFormat dayFormat = new SimpleDateFormat("yy-MM-dd");
            Date curDate = dateFormat.parse(dayFormat.format(new Date()) + " " + time);
            return curDate.getTime();
        }
        catch (Exception e) {
            log.error("time transfer error : ", (Throwable)e);
            return 0L;
        }
    }

    private void updateLocalBloom() {
        localBloomFilter = BloomFilter.create(this.charSequenceFunnel, (long)100000000L, (double)1.0E-4);
        log.info("update local bloom filter success");
    }
}

