/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.es.queue.impl;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.ozhera.trace.etl.es.queue.DiskStoreService;
import org.apache.ozhera.trace.etl.es.queue.impl.TeSnowFlake;
import org.rocksdb.CompactionStyle;
import org.rocksdb.CompressionType;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.TtlDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksdbStoreServiceImpl
implements DiskStoreService {
    private static Logger log = LoggerFactory.getLogger(RocksdbStoreServiceImpl.class);
    private RocksDB rocksDB;
    private String keyPrefix;
    public static final String FIRST_ORDER = "first";
    public static final String SECOND_ORDER = "second";

    public RocksDB getRocksDB() {
        return this.rocksDB;
    }

    public RocksdbStoreServiceImpl(String path, String keyPrefix) {
        this.keyPrefix = keyPrefix;
        try {
            boolean mkdir;
            File file = new File(path);
            if (!file.exists() && !(mkdir = file.mkdirs())) {
                log.error("rocksdb mkdir failed, ptah : " + path);
                throw new RuntimeException("rocksdb mkdir failed, ptah : " + path);
            }
        }
        catch (Exception e) {
            log.error("rocksdb mkdir failed, ptah : " + path, (Throwable)e);
            throw new RuntimeException("rocksdb mkdir failed, ptah : " + path);
        }
        Options options = new Options();
        options.setCreateIfMissing(true).setLevelCompactionDynamicLevelBytes(true).setPeriodicCompactionSeconds(3600L).setWriteBufferSize(0x800000L).setMaxWriteBufferNumber(3).setDbWriteBufferSize(0x1E00000L).setMaxBackgroundJobs(10).setCompressionType(CompressionType.SNAPPY_COMPRESSION).setNumLevels(5).setMaxBytesForLevelBase(0xC800000L).setMaxBytesForLevelMultiplier(3.0).setCompactionStyle(CompactionStyle.LEVEL).setWalTtlSeconds(60L).setKeepLogFileNum(1L).setMaxLogFileSize(0x100000L).setInfoLogLevel(InfoLogLevel.ERROR_LEVEL);
        try {
            this.rocksDB = TtlDB.open((Options)options, (String)path, (int)60, (boolean)false);
        }
        catch (RocksDBException e) {
            log.error("RocksdbStoreService init error:{}", (Throwable)e);
            throw new RuntimeException("rocksdb init failed");
        }
    }

    @Override
    public void put(String key, byte[] value) {
        try {
            this.rocksDB.put(key.getBytes(StandardCharsets.UTF_8), value);
        }
        catch (RocksDBException e) {
            log.error("RocksdbStoreService put error : ", (Throwable)e);
        }
    }

    @Override
    public void delete(String key) {
        try {
            this.rocksDB.delete(key.getBytes(StandardCharsets.UTF_8));
        }
        catch (RocksDBException e) {
            log.error("RocksdbStoreService delete error : ", (Throwable)e);
        }
    }

    @Override
    public byte[] get(String key) {
        try {
            return this.rocksDB.get(key.getBytes(StandardCharsets.UTF_8));
        }
        catch (RocksDBException e) {
            log.error("RocksdbStoreService get error : ", (Throwable)e);
            return null;
        }
    }

    public void delayTake(String begin, Long gapBetweenLatest, Consumer<byte[]> listener, TeSnowFlake snowFlake) {
        ReadOptions readOptions = new ReadOptions();
        readOptions.setVerifyChecksums(false);
        String[] beginArr = begin.split("_");
        String beginPrefix = beginArr[0];
        long lastkeySuffix = Long.valueOf(beginArr[1]);
        while (true) {
            try (RocksIterator iterator = this.rocksDB.newIterator();){
                long latestKeyTime = 0L;
                iterator.seek(beginPrefix.getBytes(StandardCharsets.UTF_8));
                while (iterator.isValid()) {
                    String key = new String(iterator.key(), StandardCharsets.UTF_8);
                    long latestTime = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()) - gapBetweenLatest;
                    if (key.indexOf("_") >= 0) {
                        String[] keyArr = key.split("_");
                        latestKeyTime = Long.valueOf(keyArr[0]);
                        long suffix = Long.valueOf(keyArr[1]);
                        if (!beginPrefix.equals(String.valueOf(latestKeyTime)) || lastkeySuffix < suffix) {
                            if (latestKeyTime > latestTime) {
                                lastkeySuffix = 0L;
                                break;
                            }
                            listener.accept(iterator.value());
                            lastkeySuffix = suffix;
                            snowFlake.storeLastTimestamp(this.keyPrefix, key);
                        }
                    }
                    iterator.next();
                }
                if (latestKeyTime > 0L) {
                    beginPrefix = String.valueOf(latestKeyTime);
                }
            }
            catch (Throwable e) {
                log.error("delayTake error:{}", e);
            }
            try {
                TimeUnit.SECONDS.sleep(1L);
                continue;
            }
            catch (InterruptedException e) {
                log.error("delayTake sleep error:{}", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public String getKey(long currSecond, long suffix) {
        String key = currSecond + "_" + suffix;
        return key;
    }
}

