/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.notify;

import com.xiaomi.youpin.docean.bo.Bean;
import com.xiaomi.youpin.docean.bo.MvcConfig;
import com.xiaomi.youpin.docean.listener.Listener;
import com.xiaomi.youpin.docean.listener.event.Event;
import com.xiaomi.youpin.docean.listener.event.EventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoceanNotify
implements Listener {
    private static final Logger log = LoggerFactory.getLogger(DoceanNotify.class);

    @Override
    public void onEvent(Event event) {
        Bean bean;
        if (event.getEventType().equals((Object)EventType.addBean)) {
            String name = (String)event.getData();
            log.info("Docean ioc:{} add bean:{}", (Object)event.getIocName(), (Object)name);
        } else if (event.getEventType().equals((Object)EventType.initFinish)) {
            long useTime = (Long)event.getData();
            String name = event.getAttachments().getOrDefault("name", "").toString();
            log.info("Docean ioc:{} {} init finish use time:{}ms", new Object[]{event.getIocName(), name, useTime});
        } else if (event.getEventType().equals((Object)EventType.putBean)) {
            bean = (Bean)event.getData();
            log.debug("Docean ioc put bean:{}", (Object)bean.getName());
        } else if (event.getEventType().equals((Object)EventType.mvcBegin)) {
            MvcConfig mvcConfig = (MvcConfig)event.getData();
            log.info("Docean mvc config:{}", (Object)mvcConfig);
        } else if (event.getEventType().equals((Object)EventType.initController)) {
            String path = (String)event.getData();
            log.info("Docean mvc add controller path:{}", (Object)path);
        }
        switch (event.getEventType()) {
            case initBean: {
                bean = (Bean)event.getData();
                long useTime = (Long)event.getAttachments().get("useTime");
                if (useTime <= 50L) break;
                log.warn("Docean ioc:{} init bean:{} use time:{}ms", new Object[]{event.getIocName(), bean.getName(), useTime});
                break;
            }
        }
    }
}

