/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.mvc.session;

import com.xiaomi.youpin.docean.common.Safe;
import com.xiaomi.youpin.docean.mvc.MvcContext;
import com.xiaomi.youpin.docean.mvc.session.DefaultHttpSession;
import com.xiaomi.youpin.docean.mvc.session.HttpSession;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class HttpSessionManager {
    private static final Map<String, HttpSession> SESSION_MAP = new ConcurrentHashMap<String, HttpSession>();

    public static String createSession() {
        DefaultHttpSession session = new DefaultHttpSession();
        String sessionId = session.getId();
        SESSION_MAP.put(sessionId, session);
        return sessionId;
    }

    public static boolean isExists(String sessionId) {
        if (SESSION_MAP.containsKey(sessionId)) {
            HttpSession session = SESSION_MAP.get(sessionId);
            if (session.getId() == null) {
                SESSION_MAP.remove(sessionId);
                return false;
            }
            return true;
        }
        return false;
    }

    public static void invalidate(String sessionId) {
        SESSION_MAP.remove(sessionId);
    }

    public static HttpSession getSession(String sessionId) {
        return SESSION_MAP.compute(sessionId, (k, v) -> {
            if (null != v && v instanceof DefaultHttpSession) {
                DefaultHttpSession dhs = (DefaultHttpSession)v;
                dhs.setUpdateTime(System.currentTimeMillis());
            }
            return v;
        });
    }

    public static HttpSession getSession(MvcContext context) {
        String sid = HttpSessionManager.getSessionId(context.getHeaders());
        if (sid.equals("")) {
            String session = HttpSessionManager.createSession();
            context.setSessionId(session);
            return HttpSessionManager.getSession(session);
        }
        return Optional.ofNullable(HttpSessionManager.getSession(sid)).orElseGet(() -> {
            String session = HttpSessionManager.createSession();
            context.setSessionId(session);
            return HttpSessionManager.getSession(session);
        });
    }

    public static void setSessionId(MvcContext context, boolean exists, FullHttpResponse response) {
        if (!context.getSessionId().equals("")) {
            DefaultCookie cookie = new DefaultCookie("DOCEANID", context.getSessionId());
            cookie.setPath("/");
            String encodeCookie = ServerCookieEncoder.STRICT.encode((Cookie)cookie);
            response.headers().set((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)encodeCookie);
            return;
        }
        if (!exists) {
            DefaultCookie cookie = new DefaultCookie("DOCEANID", HttpSessionManager.createSession());
            cookie.setPath("/");
            String encodeCookie = ServerCookieEncoder.STRICT.encode((Cookie)cookie);
            response.headers().set((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)encodeCookie);
        }
    }

    public static boolean isHasSessionId(Map<String, String> headers) {
        String cookieStr = headers.get("Cookie");
        if (cookieStr == null || "".equals(cookieStr)) {
            if (!headers.containsKey("cookie")) {
                return false;
            }
            cookieStr = headers.get("cookie");
        }
        Set cookieSet = ServerCookieDecoder.STRICT.decode(cookieStr);
        for (Cookie cookie : cookieSet) {
            if (!"DOCEANID".equals(cookie.name()) || !HttpSessionManager.isExists(cookie.value())) continue;
            return true;
        }
        return false;
    }

    public static String getSessionId(Map<String, String> headers) {
        String cookieStr = headers.get("Cookie");
        if ((cookieStr == null || "".equals(cookieStr)) && ((cookieStr = headers.get("cookie")) == null || "".equals(cookieStr))) {
            return "";
        }
        Set cookieSet = ServerCookieDecoder.STRICT.decode(cookieStr);
        for (Cookie cookie : cookieSet) {
            if (!"DOCEANID".equals(cookie.name())) continue;
            return cookie.value();
        }
        return "";
    }

    static {
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(() -> Safe.run(() -> {
            long now = System.currentTimeMillis();
            List<String> ids = SESSION_MAP.values().stream().filter(it -> {
                DefaultHttpSession hs = (DefaultHttpSession)it;
                return now - hs.getUpdateTime() > TimeUnit.MINUTES.toMillis(60L);
            }).map(it -> it.getId()).collect(Collectors.toList());
            ids.forEach(id -> SESSION_MAP.remove(id));
        }, e -> {}), 10L, 5L, TimeUnit.SECONDS);
    }
}

