/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.mvc;

import com.xiaomi.youpin.docean.Ioc;
import com.xiaomi.youpin.docean.common.DoceanVersion;
import com.xiaomi.youpin.docean.common.NamedThreadFactory;
import com.xiaomi.youpin.docean.common.NetUtils;
import com.xiaomi.youpin.docean.common.Safe;
import com.xiaomi.youpin.docean.common.StringUtils;
import com.xiaomi.youpin.docean.config.HttpServerConfig;
import com.xiaomi.youpin.docean.exception.DoceanException;
import com.xiaomi.youpin.docean.mvc.HttpHandler;
import com.xiaomi.youpin.docean.mvc.TextWebSocketHandler;
import com.xiaomi.youpin.docean.mvc.http2.Http2ServerInitializer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OptionalSslHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoceanHttpServer {
    private static final Logger log = LoggerFactory.getLogger(DoceanHttpServer.class);
    private HttpServerConfig config;
    private SslContext sslContext;
    private CountDownLatch latch = new CountDownLatch(1);

    public DoceanHttpServer(HttpServerConfig config) {
        this.config = config;
        if (this.config.getPort() == 0) {
            String port = (String)Ioc.ins().getBean("$http_port");
            this.config.setPort(Integer.valueOf(port));
        }
        if (this.config.isSsl() && this.config.getHttpVersion().equals("http1")) {
            Safe.runAndLog(() -> {
                String domain = (String)Ioc.ins().getBean("$ssl_domain");
                boolean test = Boolean.valueOf((String)Ioc.ins().getBean("$ssl_self_sign", "true"));
                if (test) {
                    SelfSignedCertificate certificate = new SelfSignedCertificate(domain);
                    this.sslContext = SslContextBuilder.forServer((File)certificate.certificate(), (File)certificate.privateKey()).build();
                } else {
                    String certificate = (String)Ioc.ins().getBean("$ssl_certificate");
                    String privateKey = (String)Ioc.ins().getBean("$ssl_cprivateKey");
                    if (StringUtils.isEmpty(certificate) || StringUtils.isEmpty(privateKey)) {
                        String message = "Please provide the file addresses of the public key and private key.";
                        log.error(message);
                        throw new RuntimeException(message);
                    }
                    File certChainFile = new File(certificate);
                    File privateKeyFile = new File(privateKey);
                    this.sslContext = SslContextBuilder.forServer((File)certChainFile, (File)privateKeyFile).build();
                }
            });
        }
    }

    public void start() throws InterruptedException {
        log.info("docean http server start:{}", (Object)new DoceanVersion());
        boolean useEpoll = NetUtils.useEpoll();
        NioEventLoopGroup eventLoopGroupBoss = null;
        NioEventLoopGroup eventLoopGroupWorker = null;
        int nThreads = Runtime.getRuntime().availableProcessors() * 2 + 1;
        if (useEpoll) {
            log.info("use epollEventLoopGroup nThreads:{}", (Object)nThreads);
            eventLoopGroupBoss = new EpollEventLoopGroup(1, (ThreadFactory)new NamedThreadFactory("EpollNettyServerBoss_", false));
            eventLoopGroupWorker = new EpollEventLoopGroup(nThreads, (ThreadFactory)new NamedThreadFactory("NettyEpollServerWorker_", false));
        } else {
            eventLoopGroupBoss = new NioEventLoopGroup(1, (ThreadFactory)new NamedThreadFactory("NettyServerBoss_", false));
            eventLoopGroupWorker = new NioEventLoopGroup(nThreads, (ThreadFactory)new NamedThreadFactory("NettyServerWorker_", false));
        }
        ServerBootstrap serverBootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)eventLoopGroupBoss, (EventLoopGroup)eventLoopGroupWorker).channel(useEpoll ? EpollServerSocketChannel.class : NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)1024)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)false)).childOption(ChannelOption.TCP_NODELAY, (Object)true);
        ChannelInitializer initializer = null;
        if (this.config.getHttpVersion().equals((Object)HttpServerConfig.HttpVersion.http1)) {
            final HttpHandler httpHandler = new HttpHandler(this.config);
            initializer = new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    if (DoceanHttpServer.this.config.isSsl()) {
                        ch.pipeline().addLast(new ChannelHandler[]{new OptionalSslHandler(DoceanHttpServer.this.sslContext)});
                    }
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpServerCodec()});
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpObjectAggregator(0x100000)});
                    ch.pipeline().addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                    ch.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(15, 15, 15)});
                    ch.pipeline().addLast(new ChannelHandler[]{httpHandler});
                    if (DoceanHttpServer.this.config.isWebsocket()) {
                        ch.pipeline().addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler("/ws")});
                        ch.pipeline().addLast(new ChannelHandler[]{new TextWebSocketHandler()});
                    }
                }
            };
        } else if (this.config.getHttpVersion().equals((Object)HttpServerConfig.HttpVersion.http2)) {
            SslContext sslCtx;
            if (this.config.isSsl()) {
                SslProvider provider = OpenSsl.isAlpnSupported() ? SslProvider.OPENSSL : SslProvider.JDK;
                String certificate = (String)Ioc.ins().getBean("$ssl_certificate");
                String privateKey = (String)Ioc.ins().getBean("$ssl_cprivateKey");
                if (StringUtils.isEmpty(certificate) || StringUtils.isEmpty(privateKey)) {
                    throw new RuntimeException("certificate or privateKey is null");
                }
                sslCtx = SslContextBuilder.forServer((File)new File(certificate), (File)new File(privateKey)).sslProvider(provider).ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"})).build();
            } else {
                sslCtx = null;
            }
            initializer = new Http2ServerInitializer(sslCtx, this.config);
        }
        serverBootstrap.childHandler(initializer);
        ChannelFuture future = serverBootstrap.bind("0.0.0.0", this.config.getPort()).addListener((GenericFutureListener)((ChannelFutureListener)future1 -> {
            if (future1.isSuccess()) {
                log.info("start finish");
            }
        })).awaitUninterruptibly();
        Throwable cause = future.cause();
        if (cause != null) {
            throw new DoceanException(cause);
        }
        InetSocketAddress boundAddress = (InetSocketAddress)future.channel().localAddress();
        log.info("tesla started at address:{}", (Object)boundAddress);
        this.latch.await();
    }

    public void stop() {
        log.info("stop server");
        this.latch.countDown();
    }
}

