/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.common;

import com.xiaomi.youpin.docean.exception.DoceanException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Safe {
    private static final Logger log = LoggerFactory.getLogger(Safe.class);

    public static void run(ExRunnable runnable, Consumer<Throwable> consumer) {
        try {
            runnable.run();
        }
        catch (Throwable ex) {
            log.error(ex.getMessage(), ex);
            consumer.accept(ex);
        }
    }

    public static void run(ExRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable ex) {
            log.error(ex.getMessage(), ex);
            throw new DoceanException(ex);
        }
    }

    public static void runAndLog(ExRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable ex) {
            log.error(ex.getMessage(), ex);
        }
    }

    public static <T> T callAndLog(ExCallable callable, T defaultValue) {
        try {
            return (T)callable.call();
        }
        catch (Throwable ex) {
            log.error(ex.getMessage(), ex);
            return defaultValue;
        }
    }

    public static interface ExRunnable {
        public void run() throws Throwable;
    }

    public static interface ExCallable {
        public Object call() throws Throwable;
    }
}

