/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.aop;

import com.google.common.collect.Lists;
import com.xiaomi.youpin.docean.aop.AopContext;
import com.xiaomi.youpin.docean.aop.EnhanceInterceptor;
import com.xiaomi.youpin.docean.aop.IProxy;
import com.xiaomi.youpin.docean.common.MutableObject;
import com.xiaomi.youpin.docean.exception.DoceanException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;

public class CglibProxy
implements IProxy {
    private Class clazz;
    private LinkedHashMap<Class, EnhanceInterceptor> interceptor;

    public CglibProxy(Class clazz, LinkedHashMap<Class, EnhanceInterceptor> interceptor) {
        this.clazz = clazz;
        this.interceptor = interceptor;
    }

    @Override
    public <T> T getInstance() {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(this.clazz);
        MethodInterceptor callback = (obj, method, args, proxy) -> {
            ArrayList interceptors = Lists.newArrayList();
            for (Map.Entry<Class, EnhanceInterceptor> entry : this.interceptor.entrySet()) {
                if (method.getAnnotation(entry.getKey()) == null) continue;
                interceptors.add(entry.getValue());
            }
            if (interceptors.size() == 0) {
                return proxy.invokeSuper(obj, args);
            }
            AopContext context = new AopContext();
            try {
                interceptors.stream().forEach(it -> {
                    if (it.needEnhance(method)) {
                        it.before(context, method, args);
                    }
                });
                Object result = proxy.invokeSuper(obj, args);
                MutableObject o = new MutableObject(result);
                interceptors.stream().forEach(it -> {
                    if (it.needEnhance(method)) {
                        Object r = it.after(context, method, o.getObj());
                        o.setObj(r);
                    }
                });
                return o.getObj();
            }
            catch (Throwable ex) {
                interceptors.stream().forEach(it -> {
                    if (it.needEnhance(method)) {
                        it.exception(context, method, ex);
                    }
                });
                throw new DoceanException(ex);
            }
        };
        enhancer.setCallback((Callback)callback);
        return (T)enhancer.create();
    }
}

